/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

#ifndef __WAVEGEN_WIDG_H__
#define __WAVEGEN_WIDG_H__


#include <gdk/gdk.h>
#include <gtk/gtkdrawingarea.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define WAVEGEN(obj)                  (GTK_CHECK_CAST ((obj), wavegen_get_type (), Wavegen))
#define WAVEGEN_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), wavegen_get_type (), WavegenClass))
#define IS_WAVEGEN(obj)               (GTK_CHECK_TYPE ((obj), wavegen_get_type ()))
#define IS_WAVEGEN_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), wavegen_get_type ()))


typedef struct _Wavegen	Wavegen;
typedef struct _WavegenClass	WavegenClass;


struct _Wavegen
{
  GtkDrawingArea graph;

  gint cursor_type;
  gfloat min_x;
  gfloat max_x;
  gfloat min_y;
  gfloat max_y;
  GdkPixmap *pixmap;
  GtkCurveType curve_type;
  gint height;                  /* (cached) graph height in pixels */
  gint grab_point;              /* point currently grabbed */
  gint last;

  gboolean changed;		/* changed since last reset? */

  /* (cached) curve points: */
  gint num_points;
  GdkPoint *point;

  /* control points: */
  gint num_ctlpoints;           /* number of control points */
  gfloat (*ctlpoint)[2];        /* array of control points */
};

struct _WavegenClass
{
  GtkDrawingAreaClass parent_class;

  void (* curve_type_changed) (Wavegen *curve);
};


GtkType		wavegen_get_type	(void);
GtkWidget*	wavegen_new		(void);
void		wavegen_reset		(Wavegen *curve);
void		wavegen_set_gamma	(Wavegen *curve, gfloat gamma);
void		wavegen_set_range	(Wavegen *curve,
					 gfloat min_x, gfloat max_x,
					 gfloat min_y, gfloat max_y);
void		wavegen_get_vector	(Wavegen *curve,
					 int veclen, gfloat vector[]);
void		wavegen_set_vector	(Wavegen *curve,
					 int veclen, gfloat vector[]);
void		wavegen_set_curve_type (Wavegen *curve, GtkCurveType type);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WAVEGEN_H__ */
