/* Some misc util functions for audio DSP work, written by Steve Harris,
   December 2000

   steve@plugin.org.uk
*/

// Denormalise floats, only actually needed for PIII and very recent PowerPC
#define FLUSH_TO_ZERO(fv) (((*(unsigned int*)&(fv))&0x7f800000)==0)?0.0f:(fv)

// Limit a value to be l<=v<=u
#define LIMIT(v,l,u) ((v)<(l)?(l):((v)>(u)?(u):(v)))

// Truncate-to-zero modulo (ANSI C doesn't specify) will only work
// if v > -m and v < 2m
#define MOD(v,m) (v<0?v+m:(v>=m?v-m:v))

// Truncate-to-zero modulo (ANSI C doesn't specify) will only work
// if v > -m and v < m
#define NEG_MOD(v,m) (v<0?v+m:v)

// Convert a value in dB's to a coefficent
#define DB_CO(g) ((g) > -70.0f ? pow(10.0f, (g) * 0.05f) : 0.0f)

// Linearly interpolate
#define LIN_INTERP(f,a,b) ((1.0f - f) * (a) + (f) * (b))

// Cubic interpolation function (probably not very fast)
inline float cube_interp(const float fr, const float inm1, const float in,
                         const float inp1, const float inp2) {
        const float a = ((3.0f * (in - inp1)) - inm1 + inp2) * 0.5f;
        const float b = (2.0f * inp1) + inm1 - ((5.0f * in + inp2) * 0.5f);
        const float c = (inp1 - inm1) * 0.5f;

        return ((a*fr*fr) + (b*fr) + c)*fr + in;
}

// Truncate float to int
inline int f_trunc(float f) {
        f -= 0.5f;
        f += (3<<22);
        return *((int*)&f) - 0x4b400000;
}

// Round float to int (faster than f_trunc)
inline int f_round(float f) {
        f += (3<<22);
        return *((int*)&f) - 0x4b400000;
}
