/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.util.Hashtable;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.GridBagConstraints;
import swingwt.awt.GridBagLayoutInfo;
import swingwt.awt.Insets;
import swingwt.awt.LayoutManager2;
import swingwt.awt.Point;
import swingwt.awt.Rectangle;

public class GridBagLayout
implements LayoutManager2 {
    protected GridBagConstraints defaultConstraints = null;
    protected GridBagLayoutInfo layoutInfo = null;
    protected Hashtable components = new Hashtable();
    public int[] columnWidths = null;
    public int[] rowHeights = null;
    public double[] columnWeights = null;
    public double[] rowWeights = null;
    boolean rightToLeft = false;
    protected static final int MAXGRIDSIZE = 512;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;

    public GridBagLayout() {
        this.defaultConstraints = new GridBagConstraints();
    }

    public void setConstraints(Component comp, GridBagConstraints constraints) {
        this.components.put(comp, constraints.clone());
    }

    public GridBagConstraints getConstraints(Component comp) {
        GridBagConstraints con = (GridBagConstraints)this.components.get(comp);
        if (con != null) {
            return (GridBagConstraints)con.clone();
        }
        this.setConstraints(comp, this.defaultConstraints);
        return (GridBagConstraints)this.defaultConstraints.clone();
    }

    private void removeConstraints(Component comp) {
        this.components.remove(comp);
    }

    public Point getLayoutOrigin() {
        Point origin = new Point(0, 0);
        if (this.layoutInfo != null) {
            origin.x = this.layoutInfo.startx;
            origin.y = this.layoutInfo.starty;
        }
        return origin;
    }

    public int[][] getLayoutDimensions() {
        return new int[2][0];
    }

    public double[][] getLayoutWeights() {
        return new double[2][0];
    }

    public Point location(int x, int y) {
        return new Point(x, y);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints != null) {
            this.setConstraints(comp, (GridBagConstraints)constraints);
        }
    }

    public void removeLayoutComponent(Component comp) {
        this.removeConstraints(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        GridBagLayoutInfo info = this.getLayoutInfo(parent, 2);
        return this.getSmallestLayoutSize(parent, info);
    }

    public Dimension minimumLayoutSize(Container parent) {
        GridBagLayoutInfo info = this.getLayoutInfo(parent, 1);
        return this.getSmallestLayoutSize(parent, info);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container parent) {
        int i;
        double weight;
        Insets insets = parent.getInsets();
        Component[] components = parent.getComponents();
        Rectangle r = new Rectangle();
        boolean bl = this.rightToLeft = !parent.getComponentOrientation().isLeftToRight();
        if (components.length == 0) {
            return;
        }
        GridBagLayoutInfo info = this.getLayoutInfo(parent, 2);
        Dimension d = this.getSmallestLayoutSize(parent, info);
        if (parent.getWidth() < d.width || parent.getHeight() < d.height) {
            info = this.getLayoutInfo(parent, 1);
            d = this.getSmallestLayoutSize(parent, info);
        }
        this.layoutInfo = info;
        r.width = d.width;
        r.height = d.height;
        int diffw = parent.getWidth() - r.width;
        if (diffw != 0) {
            weight = 0.0;
            for (i = 0; i < info.width; ++i) {
                weight += info.weightX[i];
            }
            if (weight > 0.0) {
                for (i = 0; i < info.width; ++i) {
                    int dx = (int)((double)diffw * info.weightX[i] / weight);
                    int n = i;
                    info.minWidth[n] = info.minWidth[n] + dx;
                    r.width += dx;
                    if (info.minWidth[i] >= 0) continue;
                    r.width -= info.minWidth[i];
                    info.minWidth[i] = 0;
                }
            }
            diffw = parent.getWidth() - r.width;
        } else {
            diffw = 0;
        }
        int diffh = parent.getHeight() - r.height;
        if (diffh != 0) {
            weight = 0.0;
            for (i = 0; i < info.height; ++i) {
                weight += info.weightY[i];
            }
            if (weight > 0.0) {
                for (i = 0; i < info.height; ++i) {
                    int dy = (int)((double)diffh * info.weightY[i] / weight);
                    int n = i;
                    info.minHeight[n] = info.minHeight[n] + dy;
                    r.height += dy;
                    if (info.minHeight[i] >= 0) continue;
                    r.height -= info.minHeight[i];
                    info.minHeight[i] = 0;
                }
            }
            diffh = parent.getHeight() - r.height;
        } else {
            diffh = 0;
        }
        info.startx = diffw / 2 + insets.left;
        info.starty = diffh / 2 + insets.top;
        for (int compindex = 0; compindex < components.length; ++compindex) {
            Component comp = components[compindex];
            if (!comp.isVisible()) continue;
            GridBagConstraints constraints = this.lookupConstraints(comp);
            if (!this.rightToLeft) {
                r.x = info.startx;
                for (i = 0; i < constraints.tempX; ++i) {
                    r.x += info.minWidth[i];
                }
            } else {
                r.x = parent.getWidth() - (diffw / 2 + insets.right);
                for (i = 0; i < constraints.tempX; ++i) {
                    r.x -= info.minWidth[i];
                }
            }
            r.y = info.starty;
            for (i = 0; i < constraints.tempY; ++i) {
                r.y += info.minHeight[i];
            }
            r.width = 0;
            for (i = constraints.tempX; i < constraints.tempX + constraints.tempWidth; ++i) {
                r.width += info.minWidth[i];
            }
            r.height = 0;
            for (i = constraints.tempY; i < constraints.tempY + constraints.tempHeight; ++i) {
                r.height += info.minHeight[i];
            }
            this.moveComponentInsets(constraints, r);
            if (r.x < 0) {
                r.width -= r.x;
                r.x = 0;
            }
            if (r.y < 0) {
                r.height -= r.y;
                r.y = 0;
            }
            if (r.width <= 0 || r.height <= 0) {
                comp.setBounds(0, 0, 0, 0);
                continue;
            }
            if (comp.getX() == r.x && comp.getY() == r.y && comp.getWidth() == r.width && comp.getHeight() == r.height) continue;
            comp.setBounds(r.x, r.y, r.width, r.height);
        }
    }

    protected GridBagConstraints lookupConstraints(Component comp) {
        GridBagConstraints con = (GridBagConstraints)this.components.get(comp);
        if (con != null) {
            return con;
        }
        this.setConstraints(comp, this.defaultConstraints);
        return (GridBagConstraints)this.components.get(comp);
    }

    protected GridBagLayoutInfo getLayoutInfo(Container parent, int sizeflag) {
        int py;
        int i;
        int px;
        int curHeight;
        int curWidth;
        int curY;
        int curX;
        GridBagConstraints constraints;
        Component comp;
        int compindex;
        GridBagLayoutInfo r = new GridBagLayoutInfo();
        Component[] components = parent.getComponents();
        r.height = 0;
        r.width = 0;
        int curCol = -1;
        int curRow = -1;
        int[] xMax = new int[512];
        int[] yMax = new int[512];
        for (compindex = 0; compindex < components.length; ++compindex) {
            comp = components[compindex];
            if (!comp.isVisible()) continue;
            constraints = this.lookupConstraints(comp);
            curX = constraints.gridx;
            curY = constraints.gridy;
            curWidth = constraints.gridwidth;
            if (curWidth <= 0) {
                curWidth = 1;
            }
            if ((curHeight = constraints.gridheight) <= 0) {
                curHeight = 1;
            }
            if (curX < 0 && curY < 0) {
                if (curRow >= 0) {
                    curY = curRow;
                } else if (curCol >= 0) {
                    curX = curCol;
                } else {
                    curY = 0;
                }
            }
            if (curX < 0) {
                px = 0;
                for (i = curY; i < curY + curHeight; ++i) {
                    px = Math.max(px, xMax[i]);
                }
                if ((curX = px - curX - 1) < 0) {
                    curX = 0;
                }
            } else if (curY < 0) {
                py = 0;
                for (i = curX; i < curX + curWidth; ++i) {
                    py = Math.max(py, yMax[i]);
                }
                if ((curY = py - curY - 1) < 0) {
                    curY = 0;
                }
            }
            px = curX + curWidth;
            while (r.width < px) {
                ++r.width;
            }
            py = curY + curHeight;
            while (r.height < py) {
                ++r.height;
            }
            for (i = curX; i < curX + curWidth; ++i) {
                yMax[i] = py;
            }
            for (i = curY; i < curY + curHeight; ++i) {
                xMax[i] = px;
            }
            Dimension d = sizeflag == 2 ? comp.getPreferredSize() : comp.getMinimumSize();
            constraints.minWidth = d.width;
            constraints.minHeight = d.height;
            if (constraints.gridheight == 0 && constraints.gridwidth == 0) {
                curCol = -1;
                curRow = -1;
            }
            if (constraints.gridheight == 0 && curRow < 0) {
                curCol = curX + curWidth;
                continue;
            }
            if (constraints.gridwidth != 0 || curCol >= 0) continue;
            curRow = curY + curHeight;
        }
        if (this.columnWidths != null && r.width < this.columnWidths.length) {
            r.width = this.columnWidths.length;
        }
        if (this.rowHeights != null && r.height < this.rowHeights.length) {
            r.height = this.rowHeights.length;
        }
        curCol = -1;
        curRow = -1;
        xMax = new int[512];
        yMax = new int[512];
        for (compindex = 0; compindex < components.length; ++compindex) {
            comp = components[compindex];
            if (!comp.isVisible()) continue;
            constraints = this.lookupConstraints(comp);
            curX = constraints.gridx;
            curY = constraints.gridy;
            curWidth = constraints.gridwidth;
            curHeight = constraints.gridheight;
            if (curX < 0 && curY < 0) {
                if (curRow >= 0) {
                    curY = curRow;
                } else if (curCol >= 0) {
                    curX = curCol;
                } else {
                    curY = 0;
                }
            }
            if (curX < 0) {
                if (curHeight <= 0 && (curHeight += r.height - curY) < 1) {
                    curHeight = 1;
                }
                px = 0;
                for (i = curY; i < curY + curHeight; ++i) {
                    px = Math.max(px, xMax[i]);
                }
                if ((curX = px - curX - 1) < 0) {
                    curX = 0;
                }
            } else if (curY < 0) {
                if (curWidth <= 0 && (curWidth += r.width - curX) < 1) {
                    curWidth = 1;
                }
                py = 0;
                for (i = curX; i < curX + curWidth; ++i) {
                    py = Math.max(py, yMax[i]);
                }
                if ((curY = py - curY - 1) < 0) {
                    curY = 0;
                }
            }
            if (curWidth <= 0 && (curWidth += r.width - curX) < 1) {
                curWidth = 1;
            }
            if (curHeight <= 0 && (curHeight += r.height - curY) < 1) {
                curHeight = 1;
            }
            px = curX + curWidth;
            py = curY + curHeight;
            for (i = curX; i < curX + curWidth; ++i) {
                yMax[i] = py;
            }
            for (i = curY; i < curY + curHeight; ++i) {
                xMax[i] = px;
            }
            if (constraints.gridheight == 0 && constraints.gridwidth == 0) {
                curCol = -1;
                curRow = -1;
            }
            if (constraints.gridheight == 0 && curRow < 0) {
                curCol = curX + curWidth;
            } else if (constraints.gridwidth == 0 && curCol < 0) {
                curRow = curY + curHeight;
            }
            constraints.tempX = curX;
            constraints.tempY = curY;
            constraints.tempWidth = curWidth;
            constraints.tempHeight = curHeight;
        }
        if (this.columnWidths != null) {
            System.arraycopy(this.columnWidths, 0, r.minWidth, 0, this.columnWidths.length);
        }
        if (this.rowHeights != null) {
            System.arraycopy(this.rowHeights, 0, r.minHeight, 0, this.rowHeights.length);
        }
        if (this.columnWeights != null) {
            System.arraycopy(this.columnWeights, 0, r.weightX, 0, this.columnWeights.length);
        }
        if (this.rowWeights != null) {
            System.arraycopy(this.rowWeights, 0, r.weightY, 0, this.rowWeights.length);
        }
        int nextSize = Integer.MAX_VALUE;
        i = 1;
        while (i != Integer.MAX_VALUE) {
            for (compindex = 0; compindex < components.length; ++compindex) {
                int pixels_diff;
                double wt;
                double weight;
                int k;
                double weight_diff;
                comp = components[compindex];
                if (!comp.isVisible()) continue;
                constraints = this.lookupConstraints(comp);
                if (constraints.tempWidth == i) {
                    px = constraints.tempX + constraints.tempWidth;
                    weight_diff = constraints.weightx;
                    for (k = constraints.tempX; k < px; ++k) {
                        weight_diff -= r.weightX[k];
                    }
                    if (weight_diff > 0.0) {
                        weight = 0.0;
                        for (k = constraints.tempX; k < px; ++k) {
                            weight += r.weightX[k];
                        }
                        k = constraints.tempX;
                        while (weight > 0.0 && k < px) {
                            wt = r.weightX[k];
                            double dx = wt * weight_diff / weight;
                            int n = k++;
                            r.weightX[n] = r.weightX[n] + dx;
                            weight_diff -= dx;
                            weight -= wt;
                        }
                        int n = px - 1;
                        r.weightX[n] = r.weightX[n] + weight_diff;
                    }
                    pixels_diff = constraints.minWidth + constraints.ipadx + constraints.insets.left + constraints.insets.right;
                    for (k = constraints.tempX; k < px; ++k) {
                        pixels_diff -= r.minWidth[k];
                    }
                    if (pixels_diff > 0) {
                        weight = 0.0;
                        for (k = constraints.tempX; k < px; ++k) {
                            weight += r.weightX[k];
                        }
                        k = constraints.tempX;
                        while (weight > 0.0 && k < px) {
                            wt = r.weightX[k];
                            int dx = (int)(wt * (double)pixels_diff / weight);
                            int n = k++;
                            r.minWidth[n] = r.minWidth[n] + dx;
                            pixels_diff -= dx;
                            weight -= wt;
                        }
                        int n = px - 1;
                        r.minWidth[n] = r.minWidth[n] + pixels_diff;
                    }
                } else if (constraints.tempWidth > i && constraints.tempWidth < nextSize) {
                    nextSize = constraints.tempWidth;
                }
                if (constraints.tempHeight == i) {
                    py = constraints.tempY + constraints.tempHeight;
                    weight_diff = constraints.weighty;
                    for (k = constraints.tempY; k < py; ++k) {
                        weight_diff -= r.weightY[k];
                    }
                    if (weight_diff > 0.0) {
                        weight = 0.0;
                        for (k = constraints.tempY; k < py; ++k) {
                            weight += r.weightY[k];
                        }
                        k = constraints.tempY;
                        while (weight > 0.0 && k < py) {
                            wt = r.weightY[k];
                            double dy = wt * weight_diff / weight;
                            int n = k++;
                            r.weightY[n] = r.weightY[n] + dy;
                            weight_diff -= dy;
                            weight -= wt;
                        }
                        int n = py - 1;
                        r.weightY[n] = r.weightY[n] + weight_diff;
                    }
                    pixels_diff = constraints.minHeight + constraints.ipady + constraints.insets.top + constraints.insets.bottom;
                    for (k = constraints.tempY; k < py; ++k) {
                        pixels_diff -= r.minHeight[k];
                    }
                    if (pixels_diff <= 0) continue;
                    weight = 0.0;
                    for (k = constraints.tempY; k < py; ++k) {
                        weight += r.weightY[k];
                    }
                    k = constraints.tempY;
                    while (weight > 0.0 && k < py) {
                        wt = r.weightY[k];
                        int dy = (int)(wt * (double)pixels_diff / weight);
                        int n = k++;
                        r.minHeight[n] = r.minHeight[n] + dy;
                        pixels_diff -= dy;
                        weight -= wt;
                    }
                    int n = py - 1;
                    r.minHeight[n] = r.minHeight[n] + pixels_diff;
                    continue;
                }
                if (constraints.tempHeight <= i || constraints.tempHeight >= nextSize) continue;
                nextSize = constraints.tempHeight;
            }
            i = nextSize;
            nextSize = Integer.MAX_VALUE;
        }
        return r;
    }

    protected void moveComponentInsets(GridBagConstraints constraints, Rectangle r) {
        r.x = !this.rightToLeft ? (r.x += constraints.insets.left) : (r.x -= r.width - constraints.insets.right);
        r.width -= constraints.insets.left + constraints.insets.right;
        r.y += constraints.insets.top;
        r.height -= constraints.insets.top + constraints.insets.bottom;
        int diffx = 0;
        if (constraints.fill != 2 && constraints.fill != 1 && r.width > constraints.minWidth + constraints.ipadx) {
            diffx = r.width - (constraints.minWidth + constraints.ipadx);
            r.width = constraints.minWidth + constraints.ipadx;
        }
        int diffy = 0;
        if (constraints.fill != 3 && constraints.fill != 1 && r.height > constraints.minHeight + constraints.ipady) {
            diffy = r.height - (constraints.minHeight + constraints.ipady);
            r.height = constraints.minHeight + constraints.ipady;
        }
        switch (constraints.anchor) {
            case 10: {
                r.x += diffx / 2;
                r.y += diffy / 2;
                break;
            }
            case 11: 
            case 19: {
                r.x += diffx / 2;
                break;
            }
            case 12: {
                r.x += diffx;
                break;
            }
            case 13: {
                r.x += diffx;
                r.y += diffy / 2;
                break;
            }
            case 14: {
                r.x += diffx;
                r.y += diffy;
                break;
            }
            case 15: 
            case 20: {
                r.x += diffx / 2;
                r.y += diffy;
                break;
            }
            case 16: {
                r.y += diffy;
                break;
            }
            case 17: {
                r.y += diffy / 2;
                break;
            }
            case 18: {
                break;
            }
            case 21: {
                if (this.rightToLeft) {
                    r.x += diffx;
                }
                r.y += diffy / 2;
                break;
            }
            case 22: {
                if (!this.rightToLeft) {
                    r.x += diffx;
                }
                r.y += diffy / 2;
                break;
            }
            case 23: {
                if (!this.rightToLeft) break;
                r.x += diffx;
                break;
            }
            case 24: {
                if (this.rightToLeft) break;
                r.x += diffx;
                break;
            }
            case 25: {
                if (this.rightToLeft) {
                    r.x += diffx;
                }
                r.y += diffy;
                break;
            }
            case 26: {
                if (!this.rightToLeft) {
                    r.x += diffx;
                }
                r.y += diffy;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
        }
    }

    protected Dimension getSmallestLayoutSize(Container parent, GridBagLayoutInfo info) {
        int i;
        Dimension d = new Dimension();
        Insets insets = parent.getInsets();
        int t = 0;
        for (i = 0; i < info.width; ++i) {
            t += info.minWidth[i];
        }
        d.width = t + insets.left + insets.right;
        t = 0;
        for (i = 0; i < info.height; ++i) {
            t += info.minHeight[i];
        }
        d.height = t + insets.top + insets.bottom;
        return d;
    }
}

