/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import swingwt.awt.Color;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public final class SystemColor
extends Color {
    private static SystemColor[] systemColors = new SystemColor[35];
    public static final SystemColor desktop;
    public static final SystemColor activeCaption;
    public static final SystemColor activeCaptionText;
    public static final SystemColor activeCaptionBorder;
    public static final SystemColor inactiveCaption;
    public static final SystemColor inactiveCaptionText;
    public static final SystemColor inactiveCaptionBorder;
    public static final SystemColor window;
    public static final SystemColor windowBorder;
    public static final SystemColor windowText;
    public static final SystemColor menu;
    public static final SystemColor menuText;
    public static final SystemColor text;
    public static final SystemColor textText;
    public static final SystemColor textHighlight;
    public static final SystemColor textHighlightText;
    public static final SystemColor textInactiveText;
    public static final SystemColor control;
    public static final SystemColor controlText;
    public static final SystemColor controlHighlight;
    public static final SystemColor controlLtHighlight;
    public static final SystemColor controlShadow;
    public static final SystemColor controlDkShadow;
    public static final SystemColor scrollbar;
    public static final SystemColor info;
    public static final SystemColor infoText;
    private int colorId;
    private boolean initialized = false;

    public static final SystemColor getSystemColor(int swtId) {
        return systemColors[swtId - 1];
    }

    private SystemColor(org.eclipse.swt.graphics.Color swtColour) {
        super(swtColour);
    }

    private SystemColor(float r, float g, float b) {
        super(r, g, b);
    }

    private SystemColor(float r, float g, float b, float a) {
        super(r, g, b);
    }

    private SystemColor(int r, int g, int b) {
        super(r, g, b);
    }

    private SystemColor(int r, int g, int b, int a) {
        super(r, g, b, a);
    }

    private SystemColor(int colorId) {
        super(null);
        this.colorId = colorId;
    }

    private void validate() {
        if (!this.initialized) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    SystemColor.this.swtColour = SwingWTUtils.getDisplay().getSystemColor(SystemColor.this.colorId);
                    SystemColor.this.initialized = true;
                }
            });
        }
    }

    public org.eclipse.swt.graphics.Color getSWTColor() {
        this.validate();
        return super.getSWTColor();
    }

    public int getRed() {
        this.validate();
        return super.getRed();
    }

    public int getGreen() {
        this.validate();
        return super.getGreen();
    }

    public int getBlue() {
        this.validate();
        return super.getBlue();
    }

    public int getRGB() {
        this.validate();
        return super.getBlue();
    }

    protected int[] breakRGBComponents(int value) {
        this.validate();
        return super.breakRGBComponents(value);
    }

    public Color brighter() {
        this.validate();
        return super.brighter();
    }

    public Color darker() {
        this.validate();
        return super.darker();
    }

    public String toString() {
        this.validate();
        return super.toString();
    }

    public void dispose() {
    }

    static {
        for (int i = 0; i < systemColors.length; ++i) {
            SystemColor.systemColors[i] = new SystemColor(i + 1);
        }
        desktop = SystemColor.getSystemColor(22);
        activeCaption = SystemColor.getSystemColor(31);
        activeCaptionText = SystemColor.getSystemColor(30);
        activeCaptionBorder = SystemColor.getSystemColor(32);
        inactiveCaption = SystemColor.getSystemColor(34);
        inactiveCaptionText = SystemColor.getSystemColor(33);
        inactiveCaptionBorder = SystemColor.getSystemColor(35);
        window = SystemColor.getSystemColor(22);
        windowBorder = SystemColor.getSystemColor(23);
        windowText = SystemColor.getSystemColor(21);
        menu = SystemColor.getSystemColor(29);
        menuText = SystemColor.getSystemColor(28);
        text = SystemColor.getSystemColor(22);
        textText = SystemColor.getSystemColor(21);
        textHighlight = SystemColor.getSystemColor(31);
        textHighlightText = SystemColor.getSystemColor(30);
        textInactiveText = SystemColor.getSystemColor(33);
        control = SystemColor.getSystemColor(22);
        controlText = SystemColor.getSystemColor(21);
        controlHighlight = SystemColor.getSystemColor(31);
        controlLtHighlight = SystemColor.getSystemColor(32);
        controlShadow = SystemColor.getSystemColor(18);
        controlDkShadow = SystemColor.getSystemColor(17);
        scrollbar = SystemColor.getSystemColor(34);
        info = SystemColor.getSystemColor(29);
        infoText = SystemColor.getSystemColor(28);
    }
}

