/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.KeyStroke;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyEvent;

public class KeyHandler {
    private Map actions;
    private KeyHandler parent;

    public boolean keyPressed(KeyEvent event) {
        if (this.performStroke(new KeyStroke(event, true))) {
            event.doit = false;
            return true;
        }
        return this.parent != null && this.parent.keyPressed(event);
    }

    public boolean keyReleased(KeyEvent event) {
        if (this.performStroke(new KeyStroke(event, false))) {
            return true;
        }
        return this.parent != null && this.parent.keyReleased(event);
    }

    private final boolean performStroke(KeyStroke key) {
        if (this.actions == null) {
            return false;
        }
        IAction action = (IAction)this.actions.get(key);
        if (action == null) {
            return false;
        }
        if (action.isEnabled()) {
            action.run();
        }
        return true;
    }

    public void put(KeyStroke keystroke, IAction action) {
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        this.actions.put(keystroke, action);
    }

    public void remove(KeyStroke keystroke) {
        if (this.actions != null) {
            this.actions.remove(keystroke);
        }
    }

    public KeyHandler setParent(KeyHandler parent) {
        this.parent = parent;
        return this;
    }
}

