/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.ref.WeakReference;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.presentations.BasicStackPresentation;
import org.eclipse.ui.themes.ITheme;

public class ColorSchemeService {
    private static final String LISTENER_KEY = "org.eclipse.ui.internal.ColorSchemeService";

    public static void setViewColors(final Control control) {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (control.getData(LISTENER_KEY) == null) {
            final IPropertyChangeListener listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if (property.equals("CHANGE_CURRENT_THEME") || property.equals("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END") || property.equals("org.eclipse.ui.workbench.VIEW_MESSAGE_TEXT_FONT")) {
                        ColorSchemeService.setViewColors(control);
                    }
                }
            };
            control.setData(LISTENER_KEY, (Object)listener);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(listener);
                    control.setData(ColorSchemeService.LISTENER_KEY, null);
                }
            });
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(listener);
        }
        control.setBackground(theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END"));
        control.setFont(theme.getFontRegistry().get("org.eclipse.ui.workbench.VIEW_MESSAGE_TEXT_FONT"));
    }

    public static void setTabAttributes(BasicStackPresentation presentation, final CTabFolder control) {
        if (presentation == null) {
            return;
        }
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (control.getData(LISTENER_KEY) == null) {
            final WeakReference<BasicStackPresentation> ref = new WeakReference<BasicStackPresentation>(presentation);
            final IPropertyChangeListener listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if (property.equals("CHANGE_CURRENT_THEME") || property.equals("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START") || property.equals("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END") || property.equals("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR") || property.equals("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR") || property.equals("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START") || property.equals("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END") || property.equals("org.eclipse.ui.workbench.TAB_TEXT_FONT")) {
                        ColorSchemeService.setTabAttributes((BasicStackPresentation)ref.get(), control);
                    }
                }
            };
            control.setData(LISTENER_KEY, (Object)listener);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(listener);
                    control.setData(ColorSchemeService.LISTENER_KEY, null);
                }
            });
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(listener);
        }
        int[] percent = new int[1];
        ColorRegistry colorRegistry = theme.getColorRegistry();
        control.setForeground(colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR"));
        Color[] c = new Color[]{colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START"), colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END")};
        percent[0] = theme.getInt("org.eclipse.ui.workbench.INACTIVE_TAB_PERCENT");
        boolean vertical = theme.getBoolean("org.eclipse.ui.workbench.INACTIVE_TAB_VERTICAL");
        presentation.setBackgroundColors(c[0], c[1], c[1]);
        if (presentation.isActive()) {
            control.setSelectionForeground(colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
            c[0] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            c[1] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
            percent[0] = theme.getInt("org.eclipse.ui.workbench.ACTIVE_TAB_PERCENT");
            vertical = theme.getBoolean("org.eclipse.ui.workbench.ACTIVE_TAB_VERTICAL");
        }
        control.setSelectionBackground(c, percent, vertical);
        CTabItem[] items = control.getItems();
        Font tabFont = theme.getFontRegistry().get("org.eclipse.ui.workbench.TAB_TEXT_FONT");
        control.setFont(tabFont);
        int i = 0;
        while (i < items.length) {
            items[i].setFont(tabFont);
            ++i;
        }
    }
}

