/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.internal.presentations.AbstractTableInformationControl;
import org.eclipse.ui.internal.presentations.EditorPresentation;
import org.eclipse.ui.presentations.IPresentablePart;

public class EditorList
extends AbstractTableInformationControl {
    public EditorList(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, treeStyle);
        this.setBackgroundColor(new Color((Device)parent.getDisplay(), 255, 255, 255));
    }

    protected TableViewer createTableViewer(Composite parent, int style) {
        Table table = new Table(parent, 4 | style & 0xFFFFFFFD);
        table.setLayoutData((Object)new GridData(1808));
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.addFilter((ViewerFilter)new AbstractTableInformationControl.NamePatternFilter());
        tableViewer.setContentProvider((IContentProvider)new EditorListContentProvider());
        tableViewer.setSorter(new ViewerSorter());
        tableViewer.setLabelProvider((IBaseLabelProvider)new EditorListLabelProvider());
        return tableViewer;
    }

    public void setInput(Object information) {
        EditorPresentation editorPresentation = (EditorPresentation)information;
        this.inputChanged(editorPresentation, editorPresentation.getTabFolder().getSelection());
    }

    protected void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            EditorPresentation editorPresentation = (EditorPresentation)this.getTableViewer().getInput();
            editorPresentation.setSelection((CTabItem)selectedElement);
        }
        this.dispose();
    }

    protected void deleteSelectedElements() {
        IStructuredSelection structuredSelection = this.getSelectedElements();
        if (structuredSelection != null) {
            EditorPresentation editorPresentation = (EditorPresentation)this.getTableViewer().getInput();
            Iterator iterator = structuredSelection.iterator();
            while (iterator.hasNext()) {
                IPresentablePart presentablePart = editorPresentation.getPartForTab((CTabItem)iterator.next());
                editorPresentation.close(presentablePart);
            }
        }
    }

    private class EditorListContentProvider
    implements IStructuredContentProvider {
        private EditorPresentation editorPresentation;

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.editorPresentation == null) {
                return new CTabItem[0];
            }
            CTabFolder tabFolder = this.editorPresentation.getTabFolder();
            return tabFolder.getItems();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.editorPresentation = (EditorPresentation)newInput;
        }
    }

    private class EditorListLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            CTabItem tabItem = (CTabItem)element;
            EditorPresentation editorPresentation = (EditorPresentation)EditorList.this.getTableViewer().getInput();
            IPresentablePart presentablePart = editorPresentation.getPartForTab(tabItem);
            return editorPresentation.getLabelText(presentablePart, false, true);
        }

        public Image getImage(Object element) {
            CTabItem tabItem = (CTabItem)element;
            EditorPresentation editorPresentation = (EditorPresentation)EditorList.this.getTableViewer().getInput();
            IPresentablePart presentablePart = editorPresentation.getPartForTab(tabItem);
            return editorPresentation.getLabelImage(presentablePart);
        }
    }
}

