/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: KeyStroke.java,v $
   Revision 1.5  2004/04/20 15:11:26  bobintetley
   awt.MenuShortcut implementation

   Revision 1.4  2004/04/16 10:19:07  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing;


public class KeyStroke {
    
    private int keyCode = 0;
    private int modifiers = 0;
    
    /** Only way to get one of these is through static methods */
    private KeyStroke() { }

    public static KeyStroke getKeyStroke(int keyCode, int modifiers) {
        KeyStroke k = new KeyStroke();
        k.setKeyCode(keyCode);
        k.setModifiers(modifiers);
        return k;
    }
    
    /** FIXME: NEEDS IMPLEMENTING */
    public static KeyStroke getKeyStroke(String namedConstant) {
        // Translate named constant to key code and modifier
        // Eg: "control a" for CTRL modifier _+ a
        //     "shift alt b" for SHIFT|ALT + b
        return new KeyStroke();
    }

    public static KeyStroke getKeyStroke(int keyCode) {
        return getKeyStroke(keyCode, 0);
    }
    
    /** Getter for property keyCode.
     * @return Value of property keyCode.
     *
     */
    public int getKeyCode() {
        return keyCode;
    }
    
    /** Setter for property keyCode.
     * @param keyCode New value of property keyCode.
     *
     */
    public void setKeyCode(int keyCode) {
        this.keyCode = keyCode;
    }
    
    /** Getter for property modifiers.
     * @return Value of property modifiers.
     *
     */
    public int getModifiers() {
        return modifiers;
    }
    
    /** Setter for property modifiers.
     * @param modifiers New value of property modifiers.
     *
     */
    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }
    
}
