//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "bookmarkfrm.h"
#include <swconfig.h>
#include <dirent.h>
#include "mainfrm.h"
#include "newbmfilefrm.h"
#include <io.h>
#include <dir.h>

//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TBookmarksfrm *Bookmarksfrm;
//---------------------------------------------------------------------------
__fastcall TBookmarksfrm::TBookmarksfrm(TComponent* Owner)
	: TForm(Owner)
{
	SWConfig *bookmarks;
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit;
	TTreeNode *node;
	
	DIR *dir;
	struct dirent *ent;
	string conffile;
	bmdir = "";
	
	bmtree->Items->Clear();

	if ((sit = Form1->optionsconf->Sections.find("Bookmarks")) != Form1->optionsconf->Sections.end())
		bmdir = (*sit).second["Directory"];
		
//	Add Personal Bookmarks first, or if they don't exist, ADD A BLANK BRANCH first in the tree
//	--------------------------------------------------------------------------

	if (bmdir == "")
		bmdir = "./bookmarks/";
	
	if (access(bmdir.c_str(), 0)) {		// directory does not exist
		_mkdir(bmdir.c_str());
	}
		
	conffile = bmdir + "personal.conf";
	bookmarks = new SWConfig(conffile);
	if ((sit = bookmarks->Sections.find("ROOT")) != bookmarks->Sections.end()) {
		if ((eit = (*sit).second.begin()) != (*sit).second.end()) {
			node = bmtree->Items->AddObject(bmtree->Selected, (*eit).second.c_str(), *bmfiles.insert(bmfiles.begin(), new String(conffile.c_str())));
			AddSection(bookmarks, bmtree, node, (*eit).first.c_str());
		}
	}
	else	bmtree->Items->AddObject(bmtree->Selected, "Personal Bookmarks", *bmfiles.insert(bmfiles.begin(), new String(conffile.c_str())));
	delete bookmarks;
//	--------------------------------------------------------------------------

//	Add all other bookmark files ---------------------------------------------
	if (dir = opendir(bmdir.c_str())) {
		rewinddir(dir);
		while ((ent = readdir(dir))) {
			if ((strcmp(ent->d_name, "personal.conf")) && (strcmp(ent->d_name, "."))&& (strcmp(ent->d_name, ".."))) {
				conffile = bmdir;
				conffile += ent->d_name;
				bookmarks = new SWConfig(conffile);
				if ((sit = bookmarks->Sections.find("ROOT")) != bookmarks->Sections.end()) {
					if ((eit = (*sit).second.begin()) != (*sit).second.end()) {	// Currently supports only ONE topsection per file because on save, each topsection designates which file to rewrite
						node = bmtree->Items->AddObject(bmtree->Selected, (*eit).second.c_str(), *bmfiles.insert(bmfiles.begin(), new String(conffile.c_str())));
						AddSection(bookmarks, bmtree, node, (*eit).first.c_str());
					}
				}
				delete bookmarks;
			}
		}
		closedir(dir);
	}
}


__fastcall TBookmarksfrm::~TBookmarksfrm()
{
	list <String *>::iterator it;

	SaveBookmarks();

	for (it = bmfiles.begin(); it != bmfiles.end(); it++)
		delete *it;
}


//--------------------------------------------------------------------------- 

void TBookmarksfrm::AddSection(SWConfig *config, TTreeView *tree, TTreeNode *parent, String section)
{
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit;
	TTreeNode *node;
	
	if ((sit = config->Sections.find(section.c_str())) != config->Sections.end()) {
		for (eit = (*sit).second.begin(); eit != (*sit).second.end(); eit++) {
			node = tree->Items->AddChild(parent, (*eit).second.c_str());
			AddSection(config, tree, node, (*eit).first.c_str());
		}
	}
}


void __fastcall TBookmarksfrm::bmtreeDragDrop(TObject *Sender, TObject *Source,
	int X, int Y)
{
	bmtree->Selected->MoveTo(bmtree->DropTarget, naAddChildFirst);
}
//---------------------------------------------------------------------------
void __fastcall TBookmarksfrm::bmtreeDragOver(TObject *Sender, TObject *Source,
	int X, int Y, TDragState State, bool &Accept)
{
	Accept = false;
	
	if (String(Source->ClassName()) == "TTreeView") {
		if (Source == bmtree) {
			if (bmtree->Selected->Data) {
				if (strcmp((*(String*)(bmtree->Selected->Data)).c_str(),(bmdir + "personal.conf").c_str())) {
					Accept = true;
				}
			}
			else	Accept = true;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TBookmarksfrm::bmtreeDblClick(TObject *Sender)
{
	if (!bmtree->Selected->getFirstChild()) {
		Form1->DefaultVSKey = bmtree->Selected->Text.c_str();	
		Form1->TextKeyChanged();
	}
	
}
//---------------------------------------------------------------------------
void __fastcall TBookmarksfrm::AddChild1Click(TObject *Sender)
{
	bmtree->Selected->Expand(false);
	bmtree->Items->AddChildFirst(bmtree->Selected, "New Topic")->EditText();	
}
//---------------------------------------------------------------------------
void __fastcall TBookmarksfrm::Delete1Click(TObject *Sender)
{
	if (bmtree->Selected->Data) {
		if (strcmp((*(String*)(bmtree->Selected->Data)).c_str(),(bmdir + "personal.conf").c_str())) {
			bmtree->Selected->Delete();
		}
	}
	else	bmtree->Selected->Delete();
}
//---------------------------------------------------------------------------
void __fastcall TBookmarksfrm::Rename1Click(TObject *Sender)
{
	bmtree->Selected->EditText();	
}
//---------------------------------------------------------------------------

void TBookmarksfrm::SaveBookmarks()
{
	TTreeNode *tree = 0;
	SWConfig *bmconf;
	ConfigEntMap emap;
	SectionMap::iterator sit;
	char buf[15];
	bool personal, other;
	list <String *>::iterator it;
	string persfile;

	if (bmtree->Items->Count)
		tree = bmtree->Items->Item[0];

	if ((sit = Form1->optionsconf->Sections.find("Bookmarks")) != Form1->optionsconf->Sections.end()) {
		personal = (atoi((*sit).second["AutoSavePersonal"].c_str())) ? true:false;
		other = (atoi((*sit).second["AutoSaveOther"].c_str())) ? true:false;
	}

	persfile = bmdir + "personal.conf";
	for (it = bmfiles.begin(); it != bmfiles.end(); it++) {		// delete all bookmark files before saving in case a top level was deleted
		if (((!strcmp((*it)->c_str(), persfile.c_str())) && personal) || ((strcmp((*it)->c_str(), persfile.c_str())) && other))
			unlink((*it)->c_str());
	}
	
	for (;tree;tree = tree->getNextSibling()) {
		if (((*((String *)tree->Data) == persfile.c_str()) && personal) || ((*((String *)tree->Data) != persfile.c_str()) && other)) {
			bmconf = new SWConfig(((String *)tree->Data)->c_str());
			emap = bmconf->Sections["ROOT"];
			sprintf(buf, "branch%d", tree->AbsoluteIndex);
			emap[buf] = tree->Text.c_str();
			AddSectionToConf(bmconf, buf, tree);
			bmconf->Sections["ROOT"] = emap;
			bmconf->Save();
		}
	}
}


void TBookmarksfrm::AddSectionToConf(SWConfig *config, String section, TTreeNode *tree)
{
	ConfigEntMap sit;
	char buf[15];
	
	if (tree = tree->getFirstChild()) {
		sit = config->Sections[section.c_str()];
		for (; tree; tree = tree->getNextSibling()) {
			sprintf(buf, "branch%d", tree->AbsoluteIndex);
			sit[buf] = tree->Text.c_str();
			AddSectionToConf(config, buf, tree);
		}
		config->Sections[section.c_str()] = sit;
	}
}

void __fastcall TBookmarksfrm::NewBookmarkFile1Click(TObject *Sender)
{
	if (NewBMfrm->ShowModal() == mrOk) {
		bmtree->Items->AddObject(bmtree->Items->Item[0], NewBMfrm->bmtitle->Text, *bmfiles.insert(bmfiles.begin(), new String(String(bmdir.c_str()) + NewBMfrm->bmfile->Text + String(".conf"))));
	}
}
//---------------------------------------------------------------------------