
#ifndef _RWWINDOW_H_
#define _RWWINDOW_H_


#include <WINGs/WINGs.h>

#include <string>

class RWWindow {   
protected:
   WMWindow *_win;
   WMBox *_topBox;
   
   static void windowCloseAction(WMWidget *win, void *data);
   virtual void close();
   
public:
   inline virtual WMWindow *window() { return _win; };
   
   virtual void setTitle(string title);
   
   inline virtual void hide() { WMCloseWindow(_win); };
   inline virtual void show() { WMMapWidget(_win); };

   RWWindow(WMScreen *scr, string name, bool makeBox = true);
   RWWindow(RWWindow *parent, string name, bool makeBox = true,
	    bool closable = true);
   ~RWWindow();
};

#endif
    
