/*
 * synergy -- mouse and keyboard sharing utility
 * Copyright (C) 2004 Chris Schoeneman
 * 
 * This package is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * found in the file COPYING that should have accompanied this file.
 * 
 * This package is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef CMETHODEVENTJOB_H
#define CMETHODEVENTJOB_H

#include "IEventJob.h"

//! Use a member function as an event job
/*!
An event job class that invokes a member function.
*/
template <class T>
class TMethodEventJob : public IEventJob {
public:
	//! run(event) invokes \c object->method(event, arg)
	TMethodEventJob(T* object,
							void (T::*method)(const CEvent&, void*),
							void* arg = NULL);
	virtual ~TMethodEventJob();

	// IJob overrides
	virtual void		run(const CEvent&);

private:
	T*					m_object;
	void				(T::*m_method)(const CEvent&, void*);
	void*				m_arg;
};

template <class T>
inline
TMethodEventJob<T>::TMethodEventJob(T* object,
				void (T::*method)(const CEvent&, void*), void* arg) :
	m_object(object),
	m_method(method),
	m_arg(arg)
{
	// do nothing
}

template <class T>
inline
TMethodEventJob<T>::~TMethodEventJob()
{
	// do nothing
}

template <class T>
inline
void
TMethodEventJob<T>::run(const CEvent& event)
{
	if (m_object != NULL) {
		(m_object->*m_method)(event, m_arg);
	}
}

#endif
