C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=CBARY2,SSI=0
                        SUBROUTINE CBARY2
C                       *****************
C
C      ---------------------------
     * (XX,YY,XA,YA,XB,YB,XL1,XL2)
C      ---------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            CALCUL DES COORDONNEES BARYCENTRIQUES D'UN POINT SUR      *
C            UN SEGMENT                                                *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C ! XX,YY     !  R ! D  ! COORDONNEES DU POINT DONT ON CHERCHE LES     !
C !           !    !    ! COORD. BARYCENTRIQUES                        !
C ! XA,YA     !  R ! D  ! COORD. DES 2 POINTS DU SEGEMENT  PAR RAPPORT !
C ! XB,YB,ZB, !  R ! D  ! AUXQUELS ON CHERCHE LES COORD. BARY.         !
C ! XL1,XL2   !  R ! R  ! COORDONNEES BARYCENTRIQUES                   !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : CORFS2
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C
      DOUBLE PRECISION XX,YY,XA,YA,XB,YB,XL1,XL2,DENO
C
C***********************************************************************
C
C
      DENO = XA - XB
C
      IF (ABS(DENO) .GT. 1.D-6) THEN
C      
         XL1  = (XX - XB) / DENO
         XL2  = 1.D0 - XL1
C
C
      ELSE
C
         DENO = YA - YB
C
         XL1  = (YY - YB) / DENO
         XL2  = 1.D0 - XL1
C
      ENDIF
C
C 
      END
