/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "abs.h"

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | derriere                                                             |
  |         Detection des segments en arriere et retour d'un code de     |
  |         Classement                                                   |
  |======================================================================| */

void derriere_2d (int nel2, int nel_i, int nel_j, 
		  double *xnf,double *pland,double xi[],double yi[],
		  double dsign[],int *code_decoupe)

{
  int k;
  double epsder;

  epsder = 1e-3;


  for (k=0;k<2;k++)
    dsign[k] = xnf[nel_j]*xi[k]+xnf[nel_j+nel2]*yi[k] + pland[nel_j] ;

  for (k=2;k<4;k++)
    dsign[k]  = xnf[nel_i]*xi[k]+xnf[nel_i+nel2]*yi[k] + pland[nel_i] ;

  if (( dsign[0]< epsder && dsign[1]< epsder) ||
      ( dsign[2]< epsder && dsign[3]< epsder))          *code_decoupe = -10;

  else if ( dsign[0]> -epsder && dsign[1]> -epsder &&
	    dsign[2]> -epsder && dsign[3]> -epsder )    *code_decoupe =   0;

  else if ( dsign[0]> -epsder && dsign[1]> -epsder &&
	    dsign[2]> -epsder && dsign[3]<  epsder)     *code_decoupe =   1;

  else if ( dsign[0]> -epsder && dsign[1]> -epsder &&
	    dsign[3]> -epsder && dsign[2]<  epsder)     *code_decoupe =  -1;

  else if ( dsign[2]> -epsder && dsign[3]> -epsder &&
	    dsign[0]> -epsder && dsign[1]<  epsder)     *code_decoupe =   2;

  else if ( dsign[2]> -epsder && dsign[3]> -epsder &&
	    dsign[1]> -epsder && dsign[0]<  epsder)     *code_decoupe =  -2;

  else if ( dsign[0]*dsign[1]< epsder &&
	    dsign[2]*dsign[3]< epsder )
    {
      printf( " Erreur DERRIERE : il semble y avoir une erreur dans le maillage. \n\
les elements %d et %d sont superposes \n",nel_i+1,nel_j+1) ;
      exit(0);
    }
  else
    {
    printf(" Cas non prevu pour les elements nel_i= %d nel_j=%d \n",nel_i+1,nel_j+1); 
    *code_decoupe = -6;
    }

}



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | decoupe_seg                                                          |
  |         Decoupage de segment pour optimisation de la qualite         |
  |                                                                      |
  |======================================================================| */

void decoupe_seg (int nel2, int nel_i, int nel_j, 
		  double *xnf,double *pland,double xi[],double yi[],
		  double dsign[],int code_decoupe)
     
{
  double xnj1,xnj2;
  double denom,numer,alfa;
  double pa[2],plac;
  double epsd=1.e-5,eps=1.e-6;

  if ( code_decoupe == 1 ) 
    {
      xnj1 = xnf[nel_i];
      xnj2 = xnf[nel_i+nel2];
      plac = pland[nel_i];
 
      /* Determination de la racine pa  */
      denom = xnj1*(xi[3]-xi[2])
             +xnj2*(yi[3]-yi[2]);

      if ( abs(denom) > eps )
	{
	  numer =  xnj1*xi[2]+ xnj2*yi[2]+ plac ;
	  alfa  = - numer/denom - epsd ;

	  pa[0]= xi[2]+ alfa*(xi[3]-xi[2]);
	  pa[1]= yi[2]+ alfa*(yi[3]-yi[2]);
	}

      xi[0]=xi[0];  yi[0]=yi[0];   
      xi[1]=xi[1];  yi[1]=yi[1];   
      xi[2]=xi[2];  yi[2]=yi[2];  
      xi[3]=pa[0];  yi[3]=pa[1];  
    }

  else if( code_decoupe == -1 )
    {
      xnj1 = xnf[nel_i];
      xnj2 = xnf[nel_i+nel2];
      plac = pland[nel_i];
 
      denom = xnj1*(xi[3]-xi[2])
             +xnj2*(yi[3]-yi[2]);

      if ( abs(denom) > eps )
	{
	  numer =  xnj1*xi[2]+ xnj2*yi[2]+ plac ;
	  alfa  = - numer/denom + epsd ;

	  pa[0]= xi[2]+ alfa*(xi[3]-xi[2]);
	  pa[1]= yi[2]+ alfa*(yi[3]-yi[2]);
	}

      xi[0]=xi[0];  yi[0]=yi[0];   
      xi[1]=xi[1];  yi[1]=yi[1];   
      xi[2]=pa[0];  yi[2]=pa[1];  
      xi[3]=xi[3];  yi[3]=yi[3];  
    }


   else if( code_decoupe == 2 )
    {
      xnj1 = xnf[nel_j];
      xnj2 = xnf[nel_j+nel2];
      plac = pland[nel_j];
 
      denom = xnj1*(xi[1]-xi[0])
             +xnj2*(yi[1]-yi[0]);

      if ( abs(denom) > eps )
	{
	  numer =  xnj1*xi[0]+ xnj2*yi[0]+ plac ;
	  alfa  = - numer/denom - epsd ;

	  pa[0]= xi[0]+ alfa*(xi[1]-xi[0]);
	  pa[1]= yi[0]+ alfa*(yi[1]-yi[0]);
	}

      xi[0]=xi[0];  yi[0]=yi[0];   
      xi[1]=pa[0];  yi[1]=pa[1];   
      xi[2]=xi[2];  yi[2]=yi[2];  
      xi[3]=xi[3];  yi[3]=yi[3];  
    }


   else if( code_decoupe == -2 )
    {
      xnj1 = xnf[nel_j];
      xnj2 = xnf[nel_j+nel2];
      plac = pland[nel_j];
 
      denom = xnj1*(xi[1]-xi[0])
             +xnj2*(yi[1]-yi[0]);

      if ( abs(denom) > eps )
	{
	  numer =  xnj1*xi[0]+ xnj2*yi[0]+ plac ;
	  alfa  = - numer/denom + epsd ;

	  pa[0]= xi[0]+ alfa*(xi[1]-xi[0]);
	  pa[1]= yi[0]+ alfa*(yi[1]-yi[0]);
	}

      xi[0]=pa[0];  yi[0]=pa[1];   
      xi[1]=xi[1];  yi[1]=yi[1];   
      xi[2]=xi[2];  yi[2]=yi[2];  
      xi[3]=xi[3];  yi[3]=yi[3];  
    }

     else
       printf(" Erreur derriere_2d : Cas non prevu \n" );

     
}
