C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=INT2EG,SSI=0
C
                        SUBROUTINE INT2EG
C                       *****************
C    --------------------
     *(A,B,C,ITYP,VALINT)
C    --------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   Calcul de facteur de forme par integrale de contour     *
C              Application a des triangles                             *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !   XI   !  TR  !  D ! Coordonnees X des 6 points des 2 triangles  !
C   !        !      !    ! (dans l'ordre xa,xb,xc,   xd,xe,xf)         !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/XREFER/!      ! M  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
C
C**********************************************************************
C
C.. Variables externes
      DOUBLE PRECISION A,B,C,RES
      INTEGER ITYP
C
C.. Variables locales
      DOUBLE PRECISION VALINT
      DOUBLE PRECISION TERM1,TERM2,AL,B2,U,V,U2,V2
      DOUBLE PRECISION DEL,AL1,AL2,C2
C
C**********************************************************************
C
C     =====================
      IF (ITYP .EQ. 1) THEN
C     =====================
C     Dans tout ce qui suit, on a soit A = D soit B=C
C
C
C
      AL = SQRT(ABS(4.*A*C-B*B))
      U = 2.*A/AL
      V = B/AL
      U2 = U*U
      V2 = V*V
C
C
      RES = 0.5*U2/((V2+1.)*(V2+1.)) *
     *              ( (V2-1)*(ATAN(V)-ATAN((U*V-1.-V2)/U)) -
     *                  V*(LOG(U2)-LOG(V2-2.*U*V+1.+U2)) )
     *       + 0.5*( ATAN(U-V) + U/(V2+1.) )
C
      RES = RES*AL/A
C
      RES = RES + 0.5*AL/A*ATAN(B/AL)
C
C
C
      U = 0.5*B/A
      C2 = C*C
      B2 = B*B
      DEL = SQRT(ABS(4.*C*A-B2))
      AL1 = ATAN((2.*C-B)/DEL)
      AL2 = ATAN(B/DEL)
      TERM1 = 0.5/C2 *  (
     *    (AL1+AL2) * (U*(B*B*B-4.*A*B*C)+2.*C*(4.*A*C-B2))/DEL
     *  + 0.5 *(B*(2.*C-B*U)+2.*U*A*C) * LOG(A)
     *  + (C2*(-U+2.)-C*(B+U*A)+0.5*U*B2) * LOG(A-B+C)
     *  + U*B*C+C2*(U-4.)  )
C
C
C
      TERM2 = 0.25*B/A *(LOG(C)-1.)
C
      VALINT = RES + TERM1 + TERM2 -2.
C
C
C     =========================
      ELSEIF (ITYP .EQ. 2) THEN
C     =========================
C     Dans tout ce qui suit, on a A = C
C
C
C
      AL = SQRT(ABS(4.*A*C-B*B))
      U = 2.*A/AL
      V = B/AL
      U2 = U*U
      V2 = V*V
C
C
      RES = 0.5*U2/((V2+1.)*(V2+1.)) *
     *              ( (V2-1)*(-ATAN(V)+ATAN((U*V+1.+V2)/U)) 
     *                +  V*(LOG(U2)-LOG(V2+2.*U*V+1.+U2)) )
     *       + 0.5*( ATAN(U+V) + U/(V2+1.) )
C
      RES = RES*AL/A
C
      RES = RES - 0.5*AL/A*ATAN(B/AL)
C
C
C
      U = 0.5*B/A
      C2 = C*C
      B2 = B*B
      DEL = SQRT(ABS(4.*C*A-B2))
      AL1 = ATAN((2.*C+B)/DEL)
      AL2 = ATAN(B/DEL)
      TERM1 = 0.5/C2 *  (
     *    (AL1-AL2) * (U*(B*B*B-4.*A*B*C)+2.*C*(4.*A*C-B2))/DEL
     *  - 0.5 *(B*(2.*C-B*U)+2.*U*A*C) * LOG(A)
     *  + (C2*(U+2.)+C*(B+U*A)-0.5*U*B2) * LOG(A+B+C)
     *  + U*B*C-C2*(U+4.)  )
C
C
C
      TERM2 = 0.25*B/A *(-LOG(C)+1.)
C
      VALINT = RES + TERM1 + TERM2 -2.
C
C
C
C     =========================
      ELSEIF (ITYP .EQ. 3) THEN
C     =========================
C
C
C
      AL = SQRT(4.*A*C-B*B)
      U = 2.*A/AL
      V = -B/AL
      U2 = U*U
      V2 = V*V
C
C
      RES = 0.5*U2/((V2+1.)*(V2+1.)) *
     *              ( (V2-1)*(ATAN(V)-ATAN((U*V-1.-V2)/U)) -
     *                  V*(LOG(U2)-LOG(V2-2.*U*V+1.+U2)) )
     *       + 0.5*( ATAN(U-V) + U/(V2+1.) )
C
      RES = RES*AL/A
C
      RES = RES - 0.5*AL/A*ATAN(B/AL)
C
C
C
      U = 0.5*B/A
      C2 = C*C
      B2 = B*B
      DEL = SQRT(ABS(4.*C*A-B2))
      AL1 = ATAN((2.*C+B)/DEL)
      AL2 = ATAN(B/DEL)
      TERM1 = 0.5/C2 *  (
     *    (AL1-AL2) * (U*(B*B*B-4.*A*B*C)+2.*C*(4.*A*C-B2))/DEL
     *  - 0.5 *(B*(2.*C-B*U)+2.*U*A*C) * LOG(A)
     *  + (C2*(U+2.)+C*(B+U*A)-0.5*U*B2) * LOG(A+B+C)
     *  + U*B*C-C2*(U+4.)  )
C
C
C
      TERM2 = 0.25*B/A *(1.-LOG(C))
C
      VALINT = RES + TERM1 + TERM2 -2.
C
      ENDIF
C
C--------
C FORMATS
C--------
C----
C FIN
C----
C
      END
