C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                    *****************
                     SUBROUTINE MOBDIS
C                    *****************
C
C     -------------------------------------------------
     *( NBMOBS,NDIM,NODERC,NELERC,NDMASS,NPOINS,COORDS)
C     -------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------                                                       *
C         SOLIDE MOBILE : INITIALISATION DE :                          *
C            - D1MAXS (plus petite distance entre 2 noeuds de bords     *
C                      du solide)                                      *
C-----------------------------------------------------------------------
C                   (*)    (*)                  ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NDIM    !   E  ! D  ! DIMENSION DU PROBLEME                    !
C   !   NPOINS  !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE             !
C   !   NBMOBS  !   E  ! D  ! NOMBRE DE NOEUDS MOBILES                 !
C   !   NMOBIL  !   E  ! D  ! NUM GLOB ET NUM DE SOLIDE DES NOEUDS MOB !
C   !   COORDS  !  TR  ! M  ! COORDONNEES DES NOEUDS DU MAILLAGE       !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ROTATI
C                                     
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : RESSOL
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "mobil.h"
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NBMOBS,NDIM
      INTEGER NELERC,NDMASS,NPOINS,NODERC(NELERC,NDMASS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)
C
C..Variables internes
      INTEGER N,N1,N2,N3,N4,N5,N6
      DOUBLE PRECISION X1,Y1,Z1,X2,Y2,Z2,X3,Y3
      DOUBLE PRECISION X4,Y4,Z4,X5,Y5,Z5,X6,Y6,Z6
      DOUBLE PRECISION D14,D16,D25,D13

C
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
      D1MAXS = 1.E6
C
      IF (NBMOBS.EQ.0 .AND. .NOT.LSDEPL) RETURN
C
C
C     3- CALCUL DE D1MAXS EN DIMENSION 2
C     ==================================
C
      IF (NDIM.EQ.2) THEN
C      
        DO 300 N=1,NELERC
C
          N1 = NODERC(N,1)
          N2 = NODERC(N,2)
          N3 = NODERC(N,3)
C
          X1 = COORDS(N1,1)
          Y1 = COORDS(N1,2)
          X3 = COORDS(N3,1)
          Y3 = COORDS(N3,2)
C
          D13 = (X3-X1)*(X3-X1) + (Y3-Y1)*(Y3-Y1) 
C
          IF (D13.LT.D1MAXS) D1MAXS = D13
C
  300   CONTINUE
C
C
C     4- CALCUL DE D1MAXS EN DIMENSION 3
C     ==================================
C
      ELSE
C      
        DO 400 N=1,NELERC
C
          N1 = NODERC(N,1)
          N2 = NODERC(N,2)
          N4 = NODERC(N,4)
          N5 = NODERC(N,5)
          N6 = NODERC(N,6)
C
          X1 = COORDS(N1,1)
          Y1 = COORDS(N1,2)
          Z1 = COORDS(N1,3)
          X2 = COORDS(N2,1)
          Y2 = COORDS(N2,2)
          Z2 = COORDS(N2,3)
          X4 = COORDS(N4,1)
          Y4 = COORDS(N4,2)
          Z4 = COORDS(N4,3)
          X5 = COORDS(N5,1)
          Y5 = COORDS(N5,2)
          Z5 = COORDS(N5,3)
          X6 = COORDS(N6,1)
          Y6 = COORDS(N6,2)
          Z6 = COORDS(N6,3)
C
          D14 = (X4-X1)*(X4-X1) + (Y4-Y1)*(Y4-Y1) + (Z4-Z1)*(Z4-Z1)
          D16 = (X6-X1)*(X6-X1) + (Y6-Y1)*(Y6-Y1) + (Z6-Z1)*(Z6-Z1)
          D25 = (X5-X2)*(X5-X2) + (Y5-Y2)*(Y5-Y2) + (Z5-Z2)*(Z5-Z2) 
C
          IF (D14.LT.D1MAXS) D1MAXS = D14
          IF (D16.LT.D1MAXS) D1MAXS = D16
          IF (D25.LT.D1MAXS) D1MAXS = D25
C
  400   CONTINUE
C
C
C 
      ENDIF
C
C
C     5- Correction pour les problemes d'arrondis
C     ===========================================
      D1MAXS = D1MAXS / 2.
C
C
C     6- Impressions
C     ==============
      IF (NELERC.GT.0 .AND. NBLBLA.GT.0) 
     &                 WRITE(NFECRA,6010) SQRT(D1MAXS)
C
C--------
C FORMATS
C--------
 6010 FORMAT(/,' *** MOBDIS : ',/,
     &       ' Distance d''acceptation des correspondants',/,
     &       ' pour les resistances de contact : ',E12.5)
C
      RETURN
      END

