/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "f2c_syrthes.h"
# include "tree.h"
# include "abs.h"
# include "interfaces.h"

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | orie2d                                                               |
  |                                                                      |
  |======================================================================| */

void orie2d (int *nodray, int nelray, int npoinr,
	     int *nrfray, double *cooray, double *pvinter,
	     int numgu,int ndim,int nblblr,int *grconv)

{
     
    int *grconx, *norini, *ifabor;
    int numg,i,ielem,nbmalo ;

    ifabor = (int *)malloc( nelray * 2 * sizeof(int));
    grconx = (int *)malloc( nelray * sizeof(int));
    if (ifabor==NULL || grconx==NULL) 
      {printf(" ERREUR orie2d : probleme d'allocation memoire\n");
       exit(0);}

    nbmalo = 0 ;

    voisic_2d(ifabor,nodray,nelray,npoinr,nblblr) ;

    connex_2d(ifabor,grconx,nelray,npoinr,&numg,numgu,nblblr) ;

    /* On stockera autant d'elements de depart que de surfaces connexes  trouves */
    norini = (int *)malloc( numg  * sizeof(int));
    if (norini==NULL) 
      {printf(" ERREUR orie2d : probleme d'allocation memoire\n");
       exit(0);}
     
    iniori_2d(ifabor,nodray,cooray,nrfray,grconx,nelray,npoinr,
	      pvinter,&numg,ndim,norini,grconv,numgu,&nbmalo,nblblr) ;
    
     
    oriene_2d( ifabor, nodray, nelray, grconx, norini, &numg, &nbmalo,nblblr) ;
    

      /* 4- Post processing pour developpeur (IR,CP)
      ---------------------------------------------- */
      if ( nblblr > 10 ) 
      {
         for ( i=0; i < 2 * nelray; i++ ) 
         {
           if ( ifabor[i] != -1 )  ifabor[i] += 1 ; 
         }
         printf(" \n Table des elements colles aux faces de chaque element \n ") ;

         for ( ielem=0; ielem < nelray; ielem++ )
         {
            printf( " Element %d  :  %d %d  \n", ielem+1,
                      ifabor[ielem] ,ifabor[ielem+ nelray] ) ;
         }


	 for ( ielem=0; ielem < nelray; ielem++ )
	   {
	     printf( " Element %d  :  %d %d  \n", ielem+1,
		    nodray[ielem] ,nodray[ielem+ nelray] ) ;
	   }	 

      }

    free(grconx);free(norini) ;
}



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | voisic_2d                                                            |
  |                                                                      |
  |======================================================================| */
    void voisic_2d(int *ifabor,int *nodray,int nelray,int npoinr,int nblblr)
{    
    int i;
    int i1,i2;
    int ielem;
    int *itrav;


    itrav = (int *)malloc( (2* npoinr) * sizeof(int));
    if (itrav==NULL) 
      {printf(" ERREUR voisic_2d : probleme d'allocation memoire\n");
       exit(0);}


    /* 1- INITIALISATION 
       ==================== */
    for (i=0; i < 2* npoinr ; i++) *(itrav+i) = -1 ;
    for (i=0; i < 2* nelray ; i++) *(ifabor+i) = -1 ;

    for ( ielem=0; ielem < nelray; ielem++ )
      {
	i1 = nodray[ielem]-1;
	i2 = nodray[ielem+nelray]-1;


        if(itrav[i1]==-1)
	  {
	    itrav[i1]         = ielem ;
	    if(itrav[i2] == -1)
	      itrav[i2] = ielem ;
	    else if(itrav[i2+npoinr] == -1)
	      itrav[i2+npoinr] = ielem ;
	    else printf("\n *** VOISIC_2D : erreur 1 pour element ielem %d i1=%d i2=%d \n",ielem,i1,i2);
	  }
	else if( itrav[i1+npoinr] == -1)
	  {
	    itrav[i1+npoinr] = ielem ;
	    if(itrav[i2] == -1)
	      itrav[i2] = ielem ;
	    else if(itrav[i2+npoinr] == -1)
	      itrav[i2+npoinr] = ielem ;
	    else printf("\n *** VOISIC_2D : erreur 2 pour element ielem %d i1=%d i2=%d \n",ielem,i1,i2);
	  }
	else
	  printf("\n *** VOISIC_2D : erreur 3 pour element ielem %d i1=%d i2=%d \n",ielem,i1,i2);

      }

    if( nblblr > 10 )
    {for (i=0;i<npoinr;i++)
	printf("VOISIC_2D : noeud %d : element_1= %d element_2=%d \n",i+1,itrav[i]+1,itrav[i+npoinr]+1);}

    for ( ielem=0; ielem < nelray; ielem++ )
      {
	i1 = nodray[ielem]-1;
	i2 = nodray[ielem+nelray]-1;
	    if(itrav[i1] == ielem)
	      ifabor[ielem]             = itrav[i1+npoinr];
	    else
	      ifabor[ielem]             = itrav[i1];

	    if(itrav[i2] == ielem )
	      ifabor[ielem+nelray]     = itrav[i2+npoinr];
	    else
	      ifabor[ielem+nelray]     = itrav[i2];
      }




      /* 4- Post processing pour developpeur (IR,CP)
      ---------------------------------------------- */
     if ( nblblr > 10 ) 
      {
         for ( i=0; i < 2 * nelray; i++ ) 
         {
           if ( ifabor[i] != -1 )  ifabor[i] += 1 ; 
         }
         printf(" VOISIC_2D : Table des elements colles aux faces de chaque element \n ") ;

         for ( ielem=0; ielem < nelray; ielem++ )
         {
            printf( " VOISIC_2D :Element %d  :  %d %d  \n", ielem+1,
                      ifabor[ielem] ,ifabor[ielem+ nelray] ) ;
         }

         for ( i=0; i < 2 * nelray; i++ ) 
         {
           if ( ifabor[i] != -1 )  ifabor[i] -= 1 ; 
         }

      }



      free(itrav) ;


}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | connex_2d                                                            |
  |                                                                      |
  |======================================================================| */
    void connex_2d(int *ifabor,int *grconx,int nelray,int npoinr,int *numg,int numgu, int nblblr) 
    
{

    int i;
    int iel1,iel2;

    for (i=0; i < nelray ; i++) *(grconx+i) = 0 ;

    iel1 = 0 ;
    iel2 = -10 ;
    *numg = 1 ;
    grconx[0] = *numg ;

    for (i=0; i <  2 ; i++ ) 
      if ( ifabor[iel1+i* nelray] != -1 ) iel2 = ifabor[iel1+i* nelray];
       

    if ( iel2 == -10 )
       printf( " $$ ATTENTION CONNEX_2D : Element %d isole \n" , iel1+1) ;
    else
      {

	for (i=0; i <  2 ; i++ )
          {
	    iel2 = ifabor[iel1+i* nelray] ;
	    if (iel2==-1) continue;
	    if (grconx[iel2]!=0) continue ;       
	    group_2d(iel1,iel2,nelray,grconx,ifabor,nblblr) ;
	  }
      }


    for (i=0; i <  nelray ; i++ )
    { 
       if ( grconx[i] == 0 )
       {
          if ( nblblr >10 )
	    printf(" CONNEX_2D : Le segment %d n'appartient pas encore a un groupe \n", i+1) ;

          iel1 = i ;
          iel2 = -10 ;
          *numg += 1 ;
          grconx[i] = *numg ;

	  if(ifabor[iel1+nelray]+ifabor[iel1]==-2)
	    {
	      printf( " $$ ATTENTION CONNEX_2D : Element %d isole \n" , iel1+1)  ;
	      continue ;
	    }
    
          for (i=0; i <  2 ; i++ )
          {
	    iel2 = ifabor[iel1+i* nelray] ;
	    if (iel2==-1) continue;
	    if (grconx[iel2]!=0) continue ;       
	    group_2d( iel1,iel2,nelray,grconx,ifabor,nblblr ) ;

	  }   /* fin de la boucle sur tous les cotes */

        }      /* Fin du test sur l'appartenance a un groupe */

     }         /* Fin de la boucle sur tous les elements */
   

      printf("\n *** CONNEX_2D : Le maillage surfacique contient %d surfaces connexes et %d volumes connexes \n", *numg,numgu) ;

}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | group_2d                                                             |
  |                                                                      |
  |======================================================================| */
void group_2d(int iel1,int iel2,int nelray,int *grconx,int *ifabor, int nblblr)

{
    int i ;
    int ielv ;

    grconx[iel2] = grconx[iel1] ;

/*    printf(" dans group2 : iel1+1=%d iel2+1=%d \n",iel1+1,iel2+1); */
/*    printf(" grconx[iel1]+1 : %d",grconx[iel1]); */

    for (i=0; i <  2 ; i++ )
    {
      ielv = ifabor[iel2+i* nelray] ;
      if ( ielv != -1 && grconx[ielv] == 0)
      {
          group_2d( iel2,ielv,nelray,grconx,ifabor,nblblr) ;
      }
    }
}
    
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | oriene_2d                                                            |
  |                                                                      |
  |======================================================================| */
void oriene_2d(int *ifabor, int *nodray, int nelray, 
	       int *grconx, int *norini, int *numg, int* nbmalo, int nblblr)

{

    int i,ip,iel1,iel2;
    int ifp;

    for ( i=0 ; i < *numg ; i++ ) 
    {        
       iel1 = norini[i] ;

       for ( ifp=0 ; ifp < 2 ; ifp++ )
       {
          ip   = nodray[iel1+ifp*nelray] ;
          iel2 = ifabor[iel1+ifp*nelray] ;
          if ( iel2 != -1 && grconx[iel2] > 0 )
          {
              rorien_2d(ifp,ip,iel2,ifabor,grconx,nodray,nelray,
                      nbmalo,nblblr ) ;
          }
       }
     }

    printf("\n *** ORIENE_2D : Le nombre de facettes reorientees est : %d \n", *nbmalo ) ;


}  


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | rorien_2d                                                            |
  |                                                                      |
  |======================================================================| */
void rorien_2d(int ifp,int ip,int iel2,int *ifabor,int *grconx,
            int *nodray,int nelray, int *nbmalo, int nblblr)

{ 
     int jp;
     int ielv;
     int lmalo,nodaux,neleaux;

     lmalo = 0 ;

     jp = nodray[iel2+ifp*nelray] ;
             
     if ( ip == jp )
       {
	 lmalo = 1 ;
       }

      if ( lmalo == 1 )
      {
          *nbmalo += 1 ;
          nodaux = nodray[iel2] ;
          nodray[iel2] = nodray[iel2+nelray] ;  
          nodray[iel2+ nelray] = nodaux ;

          neleaux = ifabor[iel2] ;
          ifabor[iel2] = ifabor[iel2+nelray ] ;
          ifabor[iel2+nelray] = neleaux ;
        
          grconx[iel2] = - grconx[iel2] ;
          
          if ( nblblr > 10 ) printf( "RORIEN_2D : La facette %d etait mal orientee \n",iel2+1 ) ;
      }
      else
      {
          grconx[iel2] = - grconx[iel2] ;     
      }     


        jp = nodray[iel2+ ifp*nelray ] ;             
        ielv = ifabor[iel2 + ifp* nelray] ;
        if ( ielv != -1 && grconx[ielv] > 0 )
        {
           rorien_2d(ifp,jp,ielv,ifabor,grconx,nodray,nelray,nbmalo,nblblr) ;      
        }

}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | iniori_2d                                                            |
  |        Initialisation des processus recursifs                        |
  |======================================================================| */
void iniori_2d(int *ifabor,int *nodray,double *cooray,int *nrfray,
            int *grconx,int nelray,int npoinr,
            double *pvinter,int *numg,int ndim,int *norini,
	    int *grconv,int numgu,
            int *nbmalo, int nblblr)

{

     int i,j,k,imin ;
     int n1,n2 ;
     int iel,nodaux,neleaux ;
     int iv,pintok,dejaunpoint;
     double xint,yint ;
     double dmin ;
     double x1,y1,x2,y2;
     double xnorelx,xnorely,xnormel ;
     double xvecgix,xvecgiy,xnormve ;
     double xvec1ix,xvec1iy ;
     double pscal ;
     double xxg,yyg;
     double dist;
     
     int *norinit, *npvint, *ncompteur ;
     double eps ;

		  
     eps = 1e-6 ;


     norinit = (int *)malloc( *numg * numgu * sizeof(int) );
     npvint = (int *)malloc( *numg * sizeof(int) );
     ncompteur = (int *)malloc( *numg * sizeof(int) );
     if (norinit==NULL || npvint==NULL || ncompteur==NULL) 
       {printf(" ERREUR iniori_2d : probleme d'allocation memoire\n");
	exit(0);}

     for (i=0; i < nelray ; i++) *(grconv+i) = 0 ;
     for (i=0; i < *numg ; i++) *(npvint+i) = 0 ;
     for (i=0; i < *numg ; i++) *(ncompteur+i) = 0 ;
     for (i=0; i < *numg*numgu ; i++) *(norinit+i) = 0 ;

     if ( nblblr > 10 )
     {
        for ( i=0 ; i < nelray ; i++ ) printf(" INIORI_2D : Element , nrfray : %d   %d \n",i+1,nrfray[i] ) ;
	printf("    \n");
        for ( i=0 ; i < nelray ; i++ ) printf(" INIORI_2D : Element , grconx : %d   %d \n",i+1,grconx[i] ) ;
	printf("    \n");
        for ( i=0 ; i < npoinr ; i++ )
        {
           printf(" INIORI_2D : Noeud %d  x y z :   %f %f %f \n",i+1,cooray[i],cooray[i+npoinr],cooray[i+2* npoinr]) ;
        }
      }
      
     /* Boucle sur les surfaces connexes */
     for ( j=0 ; j < *numg ; j++ )
        {
           
            /* boucle sur les points volumiques internes */
            for (iv=0;iv<numgu;iv++)
	      {
		xint = pvinter[3*iv] ;
		yint = pvinter[3*iv + 1] ;
		dmin = 1.E6 ;
		dist = 1.E+6 ;
		for ( i=0 ; i < nelray ; i++ )
		  {
		    if ( grconx[i]-1 == j )
                    /* On se restreint ici a la composante connexe j  vis a vis du point volumique iv */
		      {

			n1  = nodray[i]-1 ;          
			x1  = cooray[n1] ;
			y1  = cooray[n1+ npoinr] ;
          
			n2  = nodray[i+ nelray]-1 ;          
			x2  = cooray[n2] ;
			y2  = cooray[n2+ npoinr] ;

			xxg = (x1+x2)/2.;
			yyg = (y1+y2)/2.;
			/* On commence par se baser sur un test peu fiable 
			 la distance minimal G-PINT*/
			dist = (xxg-xint)*(xxg-xint)+(yyg-yint)*(yyg-yint);
			if (dist < dmin) {dmin = dist ; imin = i;}
		      }
		  }

		if (dist<eps*eps*1.)
		  {printf("\n *** INIORI_2D : Point interne %d mal choisi : sur la facette %d \n",iv+1,imin+1);exit(0);}

		/* La facette potentielle que l'on va tester est imin */
		  i= imin ;
		  n1  = nodray[i]-1 ;          
		  x1  = cooray[n1] ;
		  y1  = cooray[n1+ npoinr] ;
		  
		  n2  = nodray[i+ nelray]-1 ;          
		  x2  = cooray[n2] ;
		  y2  = cooray[n2+ npoinr] ;
		  
		  xxg = (x1+x2)/2.;
		  yyg = (y1+y2)/2.;

		  xnorelx = -y2+y1;
		  xnorely =  x2-x1;
		  xnormel = sqrt( xnorelx*xnorelx + xnorely*xnorely ) ;
		  if ( xnormel > -eps && xnormel < eps )
		    { printf( "\n *** INIORI_2D : L'element %d est vraisemblablement degenere (applati)\n",i+1 ) ;  exit(0) ; }
		  else
		    {
		      xnorelx = xnorelx / xnormel ;
		      xnorely = xnorely / xnormel ;
		    }

		xvecgix = xint - xxg ;
		xvecgiy = yint - yyg ;
		xnormve = sqrt( xvecgix*xvecgix + xvecgiy*xvecgiy) ;
		xvecgix = xvecgix / xnormve ;
		xvecgiy = xvecgiy / xnormve ;

		pscal = xnorelx*xvecgix + xnorely*xvecgiy ;
		if ( pscal > -eps && pscal < eps )
		  {
		    printf("\n *** INIORI_2D : Le point interne %d de coordonnees xc = %f , yc = %f  \n"
			   "                   est mal choisi, car dans le plan de la facette %d \n",
			   j+1,xint,yint,i+1) ;
		    exit(0);
		  }
			
		/* Verif de non recoupage de la surface connexe j */
		xvecgix = xvecgix * xnormve ;
		xvecgiy = xvecgiy * xnormve ;
		for ( k=0;k<nelray;k++ )
		  {
		    if ( grconx[k]-1 == j && k!=i )
		      {
			n1  = nodray[k]-1 ;          
			x1  = cooray[n1] ;
			y1  = cooray[n1+ npoinr] ;
			
			n2  = nodray[k+ nelray]-1 ;          
			x2  = cooray[n2] ;
			y2  = cooray[n2+ npoinr] ;
			
			if (racines_2d(x1,y1,x2,y2,xvecgix,xvecgiy,xxg,yyg,k))
			  {printf("\n *** INIORI_2D : Il y a une ambiguite --> changer la position du point %d \n",iv+1); exit(0);}
		      }
		  }

		/* Stockage tous les elements correspondants au couple iv et surface connexe j */
		norinit[iv +j*numgu] = imin ;
		if (nblblr > 12 ) {for (k=0;k<*numg*numgu;k++) printf (" INIORI_2D : norinit[ %d ] = %d \n",k+1,norinit[k]+1);}
	      }
	  }

      if (nblblr>10)
       {
	 printf("   \n");
	 for ( j=0;j<*numg ; j++ )
	   {
	     printf("  \n");
	     for (iv=0;iv<numgu;iv++)
	       {
		 printf(" INIORI_2D : composante connexe %d , face initiale %d pour le noeud volumique %d  \n",
			j+1,norinit[ iv +j* numgu]+1,iv+1);
	       }
	   }
       }

     /* Determination du point interieur iv qui convient a la surface connexe j
        Recoupage pair des autres surfaces connexes necessaire
     */

       for ( j=0 ; j < *numg ; j++ )
        {	  
	  dejaunpoint = 0;
	  for (iv=0;iv<numgu;iv++)
	    {
	      xint = pvinter[3*iv] ;
	      yint = pvinter[3*iv + 1] ;
	      for (i=0; i<*numg; i++) ncompteur[i]=0;
	      iel = norinit[iv + j* numgu] ;

	      n1  = nodray[iel]-1 ;          
	      x1  = cooray[n1] ;
	      y1  = cooray[n1+ npoinr] ;
           
	      n2  = nodray[iel+ nelray]-1 ;          
	      x2  = cooray[n2] ;
	      y2  = cooray[n2+ npoinr] ;

	      xxg = (x1+x2)/2.;
	      yyg = (y1+y2)/2.;

	      xvecgix = xint - xxg ;
	      xvecgiy = yint - yyg ;
	      
	      for ( k=0;k<nelray;k++ )
		{
		  if ( grconx[k]-1 != j )
		    {
		      n1  = nodray[k]-1 ;          
		      x1  = cooray[n1] ;
		      y1  = cooray[n1+ npoinr] ;
		      
		      n2  = nodray[k+ nelray]-1 ;          
		      x2  = cooray[n2] ;
		      y2  = cooray[n2+ npoinr] ;
		      
		      if (nblblr>14)
			printf(" comp conex %d face depart %d noeud volumique %d facette ocultrice k = %d \n",
			       j+1,iel+1,iv+1,k+1); 
		      if (racines_2d(x1,y1,x2,y2,xvecgix,xvecgiy,xxg,yyg,k))
			{
			 if (nblblr > 14 )
			   printf(" INIORI_2D : Intersection avec une autre surface connexe (face %d) composante connexe %d \n",
				  k+1,grconx[k]-1);
			  ncompteur[grconx[k]-1] += 1;
			}
		    }

		}

	      if (nblblr>10) printf("INIORI_2D : composante connexe j = %d noeud interieur iv = %d \n",j+1,iv+1);
	      if (nblblr>13) {for (i=0;i<*numg;i++) printf( " INIORI_2D : ncompteur[ %d ] = %d \n",i+1,ncompteur[i]);}

	      pintok =1;
	      /* flag  des intersections impaires */
	      for (i=0; i<*numg;i++)
		{
		  if ((ncompteur[i]/2)*2-ncompteur[i]!=0)
		    pintok = 0;
		}
	      if (pintok == 0)
		  {if (nblblr>10) printf( " INIORI_2D : le point interieur %d non ok pour la surface connexe  %d \n",iv+1,j+1);}
	      else
		{ 
		  if(nblblr>10)
		    printf(" INIORI_2D : le point interieur %d semble ok pour la surface connexe  %d \n",iv+1,j+1);
		  if (dejaunpoint==1)
		    {
		      printf("\n *** INIORI_2D : Ce volume est :\n");
                      printf("                   soit deja defini par un point precedent \n");
		      printf("                   soit une ambiguite existe sur le volume ---> a verifier tres soigneusement \n" );
		      printf("                   --> essayer de modifier la position du noeud interieur %d \n",iv+1);
		      exit(0);
		    }
		  else	  
		    {norini[j] = iel;npvint[j]=iv;dejaunpoint=1;}
		}
	    }

	  if (dejaunpoint==0 ) 
	    {
	      printf("\n *** INIORI_2D : Il y a un probleme pour la surface connexe j= %d\n" ,j+1);
	      printf("                   Aucun des points fournis par l'utilisateur  ne permet de la definir \n");
	      printf("                   Verifier bien que tous les volumes independants ont ete definis par un point \n");

	      exit(0);
	    }

	}

     if (nblblr>=10)
       {
	 printf("\n");
	 for (i=0;i<*numg;i++) printf(" *** INIORI_2D : Composante connexe %d   face de depart %d   point interieur %d \n",
				      i+1,norini[i]+1,npvint[i]+1);
       }

     /* Traitement proprement dit */
       for ( j= 0 ; j < *numg ; j++ )
       { 
            xint = pvinter[3*npvint[j]] ;
            yint = pvinter[3*npvint[j] + 1] ;

            iel = norini[j] ;

            n1  = nodray[iel]-1 ;          
            x1  = cooray[n1] ;
            y1  = cooray[n1+ npoinr] ;
           
            n2  = nodray[iel+ nelray]-1 ;          
            x2  = cooray[n2] ;
            y2  = cooray[n2+ npoinr] ;


           xnorelx = -y2+y1;
           xnorely =  x2-x1;
           xnormel = sqrt( xnorelx*xnorelx + xnorely*xnorely) ;
           if ( xnormel > -eps && xnormel < eps )
           {
              printf( "\n ERREUR CONNEX_2D : L'element %d est vraisemblablement degenere (longeur nulle) \n",iel+1 ) ;
              exit(0) ;
           }
           else
           {
              xnorelx = xnorelx / xnormel ;
              xnorely = xnorely / xnormel ;
           }


           xvec1ix = xint - x1 ;
           xvec1iy = yint - y1 ;
           xnormve = sqrt( xvec1ix*xvec1ix + xvec1iy*xvec1iy) ;
           if ( xnormve > -eps && xnormve < eps )
           {
              printf("\n *** INIORI_2D : Le point interne %d de coordonnees xc = %f , yc = %f \n"
                     "                   est mal choisi, car confondu avec le noeud  %d\n",
                     j+1,xint,yint,n1) ;
              exit(0) ;
           }
           else
           {
              xvec1ix = xvec1ix / xnormve ;
              xvec1iy = xvec1iy / xnormve ;
           }

           pscal = xnorelx*xvec1ix + xnorely*xvec1iy ;
           if ( pscal > -eps && pscal < eps )
           {
               printf("\n *** INIORI_2D : Le point interne %d de coordonnees xc = %f , yc = %f \n"
                      "                   est mal choisi, car dans l'alignement de l'element %d \n",
                      j+1,xint,yint,iel) ;
               exit(0) ;
           }
          
           if ( pscal < -eps )
           {
               nodaux = nodray[iel+ nelray ] ;
               nodray[iel+ nelray ] = nodray[iel] ;  
               nodray[iel ] = nodaux ;

               neleaux = ifabor[iel] ;
               ifabor[iel] = ifabor[iel + nelray ] ;
               ifabor[iel + nelray] = neleaux ;

               *nbmalo += 1 ;
               if ( nblblr > 10 ) printf( "\n INIORI_2D : Le segment %d etait mal orientee \n",iel+1 ) ;
           }
      }


     /* Volumes connexes  */
     for (j=0;j<*numg;j++)
       {
	 for (k=0;k<nelray;k++)
	   {
	     if( grconx[k]-1==j) grconv[k] =  npvint[j];
	   }
       }

     if (nblblr>10) {printf("\n");for ( i=0 ; i < nelray ; i++ ) printf(" INIORI_2D : element , grconv : %d   %d \n",i,grconv[i] ) ;}

     free(norinit);free(npvint);free(ncompteur) ; 
}
           

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | racines_2d                                                           |
  |        Calcul de la racine eventuelle entre la facette consideree    |
  |        et le vecteur xvec,yvec                                       |
  |        Si l'intersection n'est pas dans le sgement on met 1e6        |
  |        sur chaque composante                                         |
  |======================================================================| */
int racines_2d(double x1,double y1,
	       double x2,double y2,
	       double xvec,double yvec,
	       double xxg,double yyg,int iel)
{
  int ii;
  double eps,xp,yp;
  double denom,numer,alfa,d;
  double xnorelx,xnorely,xnormel;



  eps = 1.e-5;

  xnorelx = -y2+y1 ;
  xnorely =  x2-x1 ;
  xnormel = sqrt( xnorelx*xnorelx + xnorely*xnorely ) ;
  if ( xnormel > -eps && xnormel < eps )
    {
      printf( "\n *** RACINES-2D : L'element %d est vraisemblablement degenere (longueur nulle) \n",
              iel+1 ) ;
      exit(0) ;
    }
  else
    {
      xnorelx = xnorelx / xnormel ;
      xnorely = xnorely / xnormel ;
    }

  d = -x1*xnorelx-y1*xnorely;

  denom = xnorelx*xvec+xnorely*yvec;
  if ( abs(denom) > eps ) 
    {
      numer = - ( xnorelx*xxg +  xnorely*yyg + d);
      alfa  = numer/denom;
    }
  else
    alfa = 1.e6;

  if ((0.<alfa) && (alfa < 1.))
    {
      xp = xxg+alfa*xvec;  yp = yyg+alfa*yvec;  
      ii = in_seg(x1,y1,x2,y2,xp,yp);
      if (! ii)
	return(0);
      else
	return(1);
    }
  else
    return(0);

}


