.\" You can view this file with:
.\" nroff -man [file]
.\" Adapted from libcurl docs by fandom@retemail.es
.TH TclCurl n "31 March 2002" "TclCurl 0.9.5" "TclCurl Manual"
.SH NAME
TclCurl: - get  a  URL with FTP, TELNET, LDAP, GOPHER, DICT, FILE, HTTP or HTTPS syntax.
.SH SYNOPSIS
.BI "curl::init"
.sp
.IB curlHandle " configure " "?options?"
.sp
.IB curlHandle " perform"
.sp
.IB curlHandle " duhandle"
.sp
.IB curlHandle " getinfo " curlinfo_option
.sp
.IB curlhandle " cleanup"
.sp
.BI curl::transfer " ?options?"
.sp
.BI curl::version
.sp
.BI "curl::escape " url 
.sp
.BI "curl::unescape " url 
.sp
.BI "curl::curlConfig " option 
.SH DESCRIPTION
The TclCurl extension gives Tcl programmers access to the libcurl
library written by
.B Daniel Stenberg,
with it you can download urls, upload them and many other neat tricks,
for more information check
.I http://curl.haxx.se
.SH curl::init
This procedure must be the first one to call, it returns a
.I curlHandle
that you need to use to invoke TclCurl procedures. The init calls intializes
curl and this call MUST have a corresponding call to
.I cleanup
when the operation is completed.
You should perform all your sequential file transfers using the same
curlHandle. This enables TclCurl to use persistant connections when
possible.
.sp
.B RETURN VALUE
.sp
.I curlHandle
to use.
.SH curlHandle configure ?options?
.sp
.B configure
is called to set the options for the transfer. Most operations in TclCurl
have default actions, and by using the appropriate options you can
make them behave differently (as documented). All options are set with
the
.I option
followed by a parameter.
.sp
.B Notes:
the options set with this procedure are valid for the
forthcoming data transfers that are performed when you invoke
.I perform
.sp
The options are not reset between transfers (except where noted), so if
you want subsequent transfer with different options, you must change them
between the transfers.
.sp
.I "curlHandle"
is the return code from the
.I "curl::init"
call.
.sp

.BOPTIONS
.sp
These options are in a bit of random order, but you will figure it out!
.TP
.B -file
File in which the transfered data will be saved.
.TP
.B -infile
File from which the data will be transfered.
.TP
.B -infilesize
When uploading a file to a remote site, this option should be used to tell
TclCurl what the expected size of the infile is.
.TP
.B -url
The actual URL to deal with. NOTE: this option is required to be set
before
.I perform
is called.
.TP
.B -proxy
If you need to use a http proxy to access the outside world, set the
proxy string with this option. To specify port number in this string,
append :[port] to the end of the host name. The proxy string may be
prefixed with [protocol]:// since any such prefix will be ignored.
.TP
.B -proxyport
Use this option to set the proxy port to use unless it is
specified in the proxy string by
.I -proxy
.TP
.B -httpproxytunnel
Set the parameter to non-zero to get the library to tunnel all non-HTTP
operations through the given HTTP proxy. Do note that there is a big
difference to use a proxy and to tunnel through it. If you don't know what
this means, you probably don't want this tunnel option.
.TP
.B -verbose
Set the parameter to non-zero to get the library to display a lot of verbose
information about its operations.
.TP
.B -header
A non-zero parameter tells the library to include the header in the
output. This is only relevant for protocols that actually have a header
preceeding the data (like HTTP).
.TP
.B -noprogress
A non-zero parameter tells the library to turn on the built-in progress meter.
Nowadays it is turn off by default.
.TP
.B -nobody
A non-zero parameter tells the library not to include the body-part in the
output. This is only relevant for protocols that have a separate header and
body part.
.TP
.B -failonerror
A non-zero parameter tells the library to fail silently if the HTTP code
returned is equal or larger than 400. The default action would be to return
the page normally, ignoring that code.
.TP
.B -upload
A non-zero parameter tells the library to prepare for an upload. The
.B infile
and
.B infilesize
are also interesting for uploads.
.TP
.B -post
A non-zero parameter tells the library to do a regular HTTP post. This is a
normal application/x-www-form-urlencoded kind, which is the most commonly used
one by HTML forms. See the
.B postfields
option for how to specify the data to post and
.B postfieldsize
about how to set the data size.
.TP
.B -ftplistonly
A non-zero parameter tells the library to just list the names of a ftp
directory, instead of doing a full directory listing that would include file
sizes, dates etc.
.TP
.B -ftpappend
A non-zero parameter tells the library to append to the remote file instead of
overwriting it. This is only useful when uploading to a ftp site.
.TP
.B -netrc
A non-zero parameter tells the extension to scan your
.I ~/.netrc
file to find user name and password for the remote site you are about to
access. Do note that TclCurl does not verify that the file has the correct
properties set (as the standard unix ftp client does), and that only machine
name, user name and password is taken into account (init macros and similar
things are not supported).
.TP
.B -followlocation
A non-zero parameter tells the library to follow any
.I Location:
header that the server sends as part of a HTTP header. NOTE that this means
that the extension will resend the same request on the new location and
follow new
.I Location:
headers all the way until no more such headers are returned.
.TP
.B -transfertext
A non-zero parameter tells the extension to use ASCII mode for ftp transfers,
instead of the default binary transfer. For LDAP transfers it gets the data in
plain text instead of HTML and for win32 systems it does not set the stdout to
binary mode. This option can be useable when transfering text data between
systems with different views on certain characters, such as newlines or
similar.
.TP
.B -put
A non-zero parameter tells the extension to use HTTP PUT a file. The file to put
must be set with
.B infile
and
.B infilesize
.
.TP
.B -userpwd
Pass a string as parameter, which should be [username]:[password] to use for
the connection.
.TP
.B -proxyuserpwd
Pass a string as parameter, which should be [username]:[password] to use for
the connection to the HTTP proxy. If the password is left out, you will be
prompted for it.
.TP
.B -range
Pass a string as parameter, which should contain the specified range you
want. It should be in the format "X-Y", where X or Y may be left out. HTTP
transfers also support several intervals, separated with commas as in
.I "X-Y,N-M"
. Using this kind of multiple intervals will cause the HTTP server to send the
response document in pieces.
.TP
.B -errorbuffer
Pass a variable name where TclCurl may store human readable error
messages in. This may be more helpful than just the return code from the
extension.
.TP
.B -timeout
Pass the maximum time in seconds that you allow
the TclCurl transfer operation to take. Do note that normally, name lookups
may take a considerable time and that limiting the operation to less than a
few minutes risks aborting perfectly normal operations.
.TP
.B -postfields
Pass a string as parameter, which should be the full data to post in a HTTP
post operation. See also the
.B post
option.
.TP
.B -postfieldsize
If you want to post data to the server without letting TclCurl do a strlen()
to measure the data size, this option must be used. Also, when this option is
used, you can post fully binary data which otherwise is likely to fail. If
this size is set to zero, the library will use strlen() to get the data
size.
.TP
.B -referer
Pass a string as parameter. It will be used to
set the
.B referer:
header in the http request sent to the remote server. This can be used to
fool servers or scripts.
.TP
.B -useragent
Pass a string as parameter. It will be used to
set the
.B user-agent:
header in the http request sent to the remote server. This
can be used to fool servers or scripts.
.TP
.B -ftpport
Pass a string as parameter. It will be used to
get the IP address to use for the ftp PORT instruction. The PORT instruction
tells the remote server to connect to our specified IP address. The string may
be a plain IP address, a host name, an network interface name (under unix) or
just a '-' letter to let the library use your systems default IP address.
.TP
.B -lowspeedlimit
Pass the transfer speed in bytes per second
that the transfer should be below during
.B lowspeedtime
seconds for the extension to consider it too slow and abort.
.TP
.B -lowspeedtime
Pass the time in seconds that the transfer
should be below the
.B lowspeedlimit
for the extension to consider it too slow and abort.
.TP
.B -resumefrom
Pass the offset in number of bytes that you
want the transfer to start from.
.TP
.B -cookie
Pass string as parameter. It will be used to
set a cookie in the http request. The format of the string should be
[NAME]=[CONTENTS]; Where NAME is the cookie name.
.TP
.B -httpheader
Pass a
.B list
with the HTTP headers to pass to the server in your request.
If you add a header that is otherwise generated
and used by TclCurl internally, your added one will be used instead. If you
add a header with no contents as in 'Accept:', the internally used header will
just get disabled. Thus, using this option you can add new headers, replace
internal headers and remove internal headers.
.TP
.B -httppost
Tells tclcurl you want a multipart/formdata HTTP POST to be made and you
give a
.B Tcl list
with the data to pass on to the server. This is the only case where the
data is reset after a transfer.
The list must contain a 'name' tag with the name of the section followed
by a string with the name, there are three tag to indicate the value of
the section: 'value' followed by a string with the data to post, 'file'
followed by the name of the file to post and 'contenttype' with the
type of the data (text/plain, image/jpg, ...), see 'httpPost.tcl'
for an example.
.TP
.B -sslcert
Pass a string as parameter. The string should be
the file name of your certificate. The default format is "PEM" and can be
changed with \fIsslcerttype\fP.
.TP
.B -sslcerttype
Pass a string as parameter. The string should be
the format of your certificate. Supported formats are "PEM" and "DER".
.TP
.B -sslcertpasswd
Pass a string as parameter. It will be used as
the password required to use the
.B sslcert
certificate.

\fBNOTE:\fPThis option is replaced by \fIsslkeypasswd\fP and only
kept for backward compatibility. You never needed a pass phrase to load
a certificate but you need one to load your private key.
.TP

.TP
.B -sslkey
Pass a pointer to a zero terminated string as parameter. The string should be
the file name of your private key. The default format is "PEM" and can be
changed with \fIsslkeytype\fP.
.TP
.B -sslkeytype
Pass a pointer to a zero terminated string as parameter. The string should be
the format of your private key. Supported formats are "PEM", "DER" and "ENG".

\fBNOTE:\fPThe format "ENG" enables you to load the private key from a crypto
engine. in this case \fIsslkey\fP is used as an identifier passed to
the engine. You have to set the crypto engine with \fIsslengine\fP.
.TP
.B -sslkeypasswd
Pass a string as parameter. It will be used as
the password required to use the \fIsslkey\fP private key.
.TP
.B -sslengine
Pass a string as parameter. It will be used as
the identifier for the crypto engine you want to use for your private key.

\fBNOTE:\fPIf the crypto device cannot be loaded, an error will be returned.
.TP
.B -sslenginedefault
Sets the actual crypto engine as the default for (asymetric) crypto operations.

\fBNOTE:\fPIf the crypto device cannot be set, an error will be returned.
.TP
.B -crlf
Convert unix newlines to CRLF newlines on FTP uploads.
.TP
.B -quote
Pass a
.B list
with the FTP commands to pass to the server prior to your ftp request. If you
don't want to transfer any files, set
.B nobody
to '1' and
.B header
to '0'.
.TP
.B -prequote
Pass a
.B list
of FTP commands to issue
.I just before
the transfer command (RETR or STOR etc). It has turned up a few systems that
really need this.
.TP
.B -postquote
Pass a
.B list
with the FTP commands to pass to the server after your ftp transfer request.
If you don't want to transfer any files, set
.B nobody
to '1' and
.B header
to '0'.
.TP
.B -writeheader
Pass a the file to be used to write the header part of the received data to.
The headers are guaranteed to be written one-by-one to this file handle and
only complete lines are written. Parsing headers should be easy enough using
this.
.TP
.B -cookiefile
Pass a string as parameter. It should contain the
name of your file holding cookie data. The cookie data may be in netscape
cookie data format or just regular HTTP-style headers dumped to a file.
.TP
.B -sslversion
Pass what version of SSL to attempt to use, 2 or
3. By default, the SSL library will try to solve this by itself although some
servers make this difficult, that is why you at times will have to use this
option.
.TP
.B -timecondition
Pass how the
.B timevalue
time value is treated. You can set this parameter to
.B ifmodsince
or
.B ifunmodsince
. This is a HTTP-only feature. (TBD)
.TP
.B -timevalue
Pass the time in seconds since 1 jan 1970, and the time will be used as
specified in
.B timecondition
or if that is not used, it will be
.b ifmodsince
by default.
.TP
.B -customrequest
Pass a string as parameter. It will be used
instead of GET or HEAD when doing the HTTP request. This is useful for doing
DELETE or other more obscure HTTP requests. Don't do this at will, make sure
your server supports the command first.
.TP
.B -stderr
Pass a file as parameter. This is the stream to use instead of stderr
internally when reporting errors.
.TP
.B -interface
Pass the interface name to use as outgoing
network interface. The name can be an interface name, an IP address or a host
name.
.TP
.B -krb4level
Set the krb4 security level, this also enables
krb4 awareness.  This is a string, 'clear', 'safe', 'confidential' or
\& 'private'.  If the string is set but doesn't match one of these, 'private'
will be used. Set the string to NULL to disable kerberos4. The kerberos
support only works for FTP.
.TP
.B -sslverifypeer
Pass a non-zero value to make TclCurl verify the peer's
certificate. The certificate to verify against must be specified with the
.B cainfo
option.
.TP
.B -cainfo
Pass a file naming holding the certificate to
verify the peer with. This only makes sense when used in combination with the
.I sslverifypeer
option.
.TP
.B -filetime
If you pass a non-zero value, TclCurl will attempt to get the
modification date of the remote document in this operation. This requires that
the remote server sends the time or replies to a time querying command. The
getinfo procedure with the
.I filetime
argument can be used after a transfer to extract the received time (if any).
.TP
.B -maxredirs
Sets the redirection limit. If that many
redirections have been followed, the next redirect will cause an error. This
option only makes sense if the
.B followlocation
is used at the same time.
.TP
.B -maxconnects
Sets the persistant connection cache size. The
set amount will be the maximum amount of simultaneous connections that TclCurl
may cache between file transfers. Default is 5, and there isn't much point in
changing this value unless you are perfectly aware of how this work and
changes TclCurl's behaviour. Note: if you have already performed transfers
with this curl handle, setting a smaller
.B maxconnects
than before may cause open connections to unnecessarily get closed.
.TP
.B -closepolicy
This option sets what policy TclCurl should use when the
connection cache is filled and one of the open connections has to be closed to
make room for a new connection. Use 
.B leastrecentlyused
to make libcurl close the connection that was least recently used, that connection
is also least likely to be capable of re-use. Use 
.B oldest
to make libcurl close the oldest connection, the one that was created first
among the ones in the connection cache.
.TP
.B -randomfile
Pass a file name. The file will be used to read
from to seed the random engine for SSL. The more random the specified file is,
the more secure will the SSL connection becomes.
.TP
.B -egdsocket
Pass a path name to the Entropy Gathering Daemon
socket. It will be used to seed the random engine for SSL.
.TP
.B -connecttimeout
Maximum time in seconds that you allow the
connection to the server to take.  This only limits the connection phase, once
it has connected, this option is of no more use. Set to zero to disable
connection timeout (it will then only timeout on the system's internal
timeouts).
.TP
.B -headervar
Name of the Tcl array variable where TclCurl will store the headers returned
by the server.
.TP
.B -bodyvar
Name of the Tcl variable where TclCurl will store the file requested, the file
may contain text or binary data.
.TP
.B -progressproc
Name of the Tcl procedure that will invoked by TclCurl whenever there is
new data, the prototype of the procedure must be:
.sp
.B proc ProgressCallback {dltotal dlnow ultotal ulnow}
.sp
In order to this option to work you have to set the
.B noprogress
option to '0'.
.TP
.B  -canceltransvar
Name of a Tcl variable, in case you have defined a procedure to call with
.B -progressproc
setting this variable to '1' will cancel the transfer.
.TP
.B -writeproc
Use it to set a Tcl procedure that will be invoked by TclCurl as soon as
there is received data that needs to be written down.
.TP
.B -readproc
Sets a Tcl procedure to be called by TclCurl as soon as it needs to read
data in order to send it to the peer. The procedure has to take one
parameter, which will contain the maximun numbers of bytes to read. It
should return the actual number of bytes read, or '0' if you want to
stop the transfer.
.TP
.B -httpget
If set to non-zero forces the HTTP  request to get back to GET. Only really
usable if POST, PUT or a custom request have been used previously with the
same curl handle.
.TP
.B -sslverifyhost
Set to non-zero if we should verify the Common name from the peer certificate
in the SSL handshake, set 1 to check existence, 2 to ensure that it matches
the provided hostname.
.TP
.B -cookiejar
Pass a file name in which TclCurl will dump all internally known cookies
when
.B curlHandle cleanup
is called. If no cookies are known, no file will be created.
Specify "-" to have the cookies written to stdout.
.TP
.B -sslcypherlist
Pass a string holding the ciphers to use for the SSL connection.
The list must consists of one or more cipher strings separated by
colons. Commas or spaces are also acceptable separators but colons
are normally used, , - and + can be used as operators. Valid examples
of cipher lists include 'RC4-SHA', SHA1+DES, 'TLSv1' and
'DEFAULT'. The default list is normally set when you compile OpenSSL.
You'll find all details about cipher lists on this URL:
.I http://www.openssl.org/docs/apps/ciphers.html
.TP
.B -httpversion
Set to one of the values decribed below, they force TclCurl to use the
specific http versions. It should only be used if you really MUST do
that because of a silly remote server.
.RS
.TP 5
.B none
We don't care about what version the library uses. TclCurl will use whatever
it thinks fit.
.TP
.B 1.0
Enforce HTTP 1.0 requests.
.TP
.B 1.1
Enforce HTTP 1.1 requests.
.RE
.TP
.B -ftpuseepvs
Set to one to tell TclCurl to use the EPSV command when doing passive FTP
downloads (which is always does by default). Using EPSV means that it will
first attempt to use EPSV before using PASV, but if you pass a zero to this
option, it will not try using EPSV, only plain PASV.



.SH NOT SUPPORTED
Some of the options libcurl offers are not supported, I don't think them
worth supporting in TclCurl but if you need one of them don't forget to
complain:
.sp
.B CURLOPT_PASSWDFUNCTION, CURLOPT_PASSWDDATA,
.B CURLOPT_FRESH_CONNECT, CURLOPT_FORBID_REUSE

.SH curlHandle perform
This procedure is called after the
.B init
and all the
.B configure
calls are made, and will perform the transfer as described in the options.
.sp
It must be called with the same
.I curlHandle
.B curl::init
call returned.
You can do any amount of calls to perform while using the same handle. If you
intend to transfer more than one file, you are even encouraged to do
so. TclCurl will then attempt to re-use the same connection for the following
transfers, thus making the operations faster, less CPU intense and using less
network resources. Just note that you will have to use
.I configure
between the invokes to set options for the following perform.
.sp
You must never call this procedure simultaneously from two places using the
same handle. Let it return first before invoking it another time. If
you want parallel transfers, you must use several curl handles.
.TP
.B RETURN VALUE
'0' if all went well, non-zero if it didn't. In case of error, if the
.I errorBuffer
was set with
.I configure
there will be a readable error message.
The error codes are:
.IP 1
Unsupported protocol. This build of TclCurl has no support for this protocol.
.IP 2
Failed to initialize.
.IP 3
URL malformat. The syntax was not correct.
.IP 4
URL user malformatted. The user-part of the URL syntax was not correct.
.IP 5
Couldn't resolve proxy. The given proxy host could not be resolved.
.IP 6
Couldn't resolve host. The given remote host was not resolved.
.IP 7
Failed to connect to host.
.IP 8
FTP weird server reply. The server sent data TclCurl couldn't parse.
.IP 9
FTP access denied. The server denied login.
.IP 10
FTP user/password incorrect. Either one or both were not accepted by the
server.
.IP 11
FTP weird PASS reply. TclCurl couldn't parse the reply sent to the PASS request.
.IP 12
FTP weird USER reply. TclCurl couldn't parse the reply sent to the USER request.
.IP 13
FTP weird PASV reply, TclCurl couldn't parse the reply sent to the PASV request.
.IP 14
FTP weird 227 format. TclCurl couldn't parse the 227-line the server sent.
.IP 15
FTP can't get host. Couldn't resolve the host IP we got in the 227-line.
.IP 16
FTP can't reconnect. Couldn't connect to the host we got in the 227-line.
.IP 17
FTP couldn't set binary. Couldn't change transfer method to binary.
.IP 18
Partial file. Only a part of the file was transfered.
.IP 19
FTP couldn't RETR file. The RETR command failed.
.IP 20
FTP write error. The transfer was reported bad by the server.
.IP 21
FTP quote error. A quote command returned error from the server.
.IP 22
HTTP not found. The requested page was not found. This return code only
appears if --fail is used.
.IP 23
Write error. TclCurl couldn't write data to a local filesystem or similar.
.IP 24
Malformat user. User name badly specified.
.IP 25
FTP couldn't STOR file. The server denied the STOR operation.
.IP 26
Read error. Various reading problems.
.IP 27
Out of memory. A memory allocation request failed.
.IP 28
Operation timeout. The specified time-out period was reached according to the
conditions.
.IP 29
FTP couldn't set ASCII. The server returned an unknown reply.
.IP 30
FTP PORT failed. The PORT command failed.
.IP 31
FTP couldn't use REST. The REST command failed.
.IP 32
FTP couldn't use SIZE. The SIZE command failed. The command is an extension
to the original FTP spec RFC 959.
.IP 33
HTTP range error. The range "command" didn't work.
.IP 34
HTTP post error. Internal post-request generation error.
.IP 35
SSL connect error. The SSL handshaking failed.
.IP 36
FTP bad download resume. Couldn't continue an earlier aborted download.
.IP 37
FILE couldn't read file. Failed to open the file. Permissions?
.IP 38
LDAP cannot bind. LDAP bind operation failed.
.IP 39
LDAP search failed.
.IP 40
Library not found. The LDAP library was not found.
.IP 41
Function not found. A required LDAP function was not found.
.IP 42
Aborted by callback. An application told curl to abort the operation.
.IP 43
Internal error. A function was called with a bad parameter.
.IP 44
Internal error. A function was called in a bad order.
.IP 45
Interface error. A specified outgoing interface could not be used.
.IP 46
Bad password entered. An error was signalled when the password was entered.
.IP 47
Too many redirects. When following redirects, curl hit the maximum amount.
.IP 48
Unknown TELNET option specified.
.IP 49
Malformed telnet option.
.IP 51
The remote peer's SSL certificate wasn't ok
.IP 52
The server didn't reply anything, which here is considered an error.



.SH curlHandle getinfo option
Request internal information from the curl session with this procedure.
This procedure is intended to get used *AFTER* a performed transfer,
all results from this function are undefined until the transfer is completed.
.SH AVAILABLE INFORMATION
These are informations that can be extracted:
.TP 0.8i
.B effectiveurl
Returns the last used effective URL.
.TP 0.8i
.B httpcode
Returns the last received HTTP code.
.TP 0.8i
.B filetime
Returns the remote time of the retrieved document. If you get -1, TclCurl 
couldn't read it, which can be because of many reasons (unknown, the server
hides it or the server doesn't support the command that tells document time,
etc) and the time of the document is unknown.
.sp
In order for this to work you have to set the
.B -filetime
option before the transfer.
.TP 0.8i
.B totaltime
Returns the total transaction time in seconds for the previous transfer.
.TP 0.8i
.B namelookuptime
Returns the time, in seconds, it took from the start until the name resolving
was completed.
.TP 0.8i
.B connecttime
Returns the time, in seconds, it took from the start until the connect to the
remote host (or proxy) was completed.
.TP 0.8i
.B pretransfertime
Returns the time, in seconds, it took from the start until the file transfer
is just about to begin. This includes all pre-transfer commands and
negotiations that are specific to the particular protocol(s) involved.
.TP 0.8i
.B starttransfertime
Returns the time, in seconds, it took from the start until the first byte
is just about to be transfered. This includes the
.B pretransfertime
and also the time the server needs to calculate the result.
.TP 0.8i
.B sizeupload
Returns the total amount of bytes that were uploaded.
.TP 0.8i
.B sizedownload
Returns the total amount of bytes that were downloaded.
.TP 0.8i
.B speeddownload
Returns the average download speed that curl measured for the complete download.
.TP 0.8i
.B speedupload
Returns the average upload speed that curl measured for the complete upload.
.TP 0.8i
.B headersize
Returns the total size of all the headers received.
.TP 0.8i
.B requestsize
Returns the total size of the issued requests. This is so far only for HTTP
requests. Note that this may be more than one request if followLocation is true.
.TP 0.8i
.B sslverifyresult
Returns the result of the certification verification that was requested
(using the -sslverifypeer option to configure).
.TP 0.8i
.B contentlengthdownload
Returns the content-length of the download. This is the value read from the
.B Content-Length:
field.
.TP 0.8i
.B contentlengthupload
Returns the specified size of the upload.
.TP 0.8i
.B contenttype
Returns the content-type of the downloaded object. This is the value
read from the Content-Type: field. If you get an empty string, it  means
the server didn't send a valid Content-Type header or that the protocol
used doesn't support this.


.SH curlHandle duphandle
This procedure will return a new curl handle, a duplicate,
using all the options previously set in the input curl handle.
Both handles can subsequently be used independently and
they must both be freed with
.B cleanup.
The new handle will not inherit any state information, no
connections, no SSL sessions and no cookies.
.TP
.B RETURN VALUE
A new curl handle or an error message if the copy fails.

.SH curlHandle cleanup
This procedure must be the last one to call for a curl session. It is the
opposite of the
.I curl::init
procedure and must be called with the same
.I curlhandle
as input as the curl::init call returned.
This will effectively close all connections TclCurl has used and possibly
has kept open until now. Don't call this procedure if you intend to transfer
more files.

.SH curl::transfer
In case you do not want to use persistant connections and you are not going
to use the
.B curl::getinfo
command, you can use this command, it takes the same arguments as
.B curl::configure
and will init, configure, perform and cleanup a connection for you.
.SH curl::version
Returns a string with the version number of tclcurl, libcurl and some of
its important components (like OpenSSL version).
.TP
.B RETURN VALUE
The string with the version info.

.SH curl::escape url
This procedure will convert the given input string to an URL encoded string and
return that. All input characters that are not a-z,
A-Z or 0-9 will be converted to their "URL escaped" version. If a sequence of
%NN (where NN is a two-digit hexadecimal number) is found in the string to
encode, that 3-letter combination will be copied to the output unmodifed,
assuming that it is an already encoded piece of data.
.TP
.B RETURN VALUE
The converted string.
.SH curl::unescape url
This procedure will convert the given URL encoded input string to a "plain
string" and return that. All input characters that
are URL encoded (%XX where XX is a two-digit hexadecimal number, or +) will be
converted to their plain text versions (up to a ? letter, no letters to the
right of a ? letter will be converted).
.TP
.B RETURN VALUE
The string unencoded.

.SH curl::curlConfig option
Returns some information about the how you have
.B cURL
installed:
.TP
.B OPTIONS
.TP
.B -prefix
Returns the directory root where you installed
.B cURL
.TP
.B -feature
Returns a list containing particular main features the installed
.B libcurl
was built with. The list may include SSL, KRB4 or IPv6, do not
assume any particular order.
.TP
.B -vernum
Outputs  version  information  about  the installed libcurl, in
numerical mode.  This outputs the  version  number,  in hexadecimal,
 with 8 bits for each part; major, minor, patch. So  that  libcurl
 7.7.4 would  appear  as 070704 and libcurl 12.13.14 would appear as
0c0d0e...

.SH "SEE ALSO"
.I curl, curl_formparse, The art of HTTP scripting (at http://curl.haxx.se), RFC 2396,
