/*
 * tclcurl.h --
 *
 * Header file for the TclCurl extension to enable Tcl interpreters 
 * to access libcurl.
 *
 * Copyright (c) 2001-2002 Andrs Garca Garca.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>
#include <tcl.h>
#include <tclDecls.h>
#include <stdio.h>
#include <string.h>

#define _MPRINTF_REPLACE 
#include <curl/mprintf.h>

#ifdef  __cplusplus
extern "C" {
#endif 

/*
 * Windows needs to know which symbols to export.  Unix does not.
 * BUILD_tclcurl should be undefined for Unix.
 * Actually I don't use this, but it was in TEA so I keep in case
 * I ever understand what it is for.
 */

#ifdef BUILD_tclcurl
#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLEXPORT
#endif

#define TclCurlVersion "0.9.5"

/*
 * This struct will contain the data of a transfer if the user wants
 * to put the body into a Tcl variable
 */
struct MemoryStruct {
    char   *memory;
    size_t size;
};

struct curlObjData {
    CURL                *curl;
    Tcl_Command         token;
    Tcl_Interp          *interp;
    struct curl_slist   *headerList;
    struct curl_slist   *quote;
    struct curl_slist   *prequote;
    struct curl_slist   *postquote;
    struct curl_slist   *formHeaderList;
    struct HttpPost     *postListFirst;
    struct HttpPost     *postListLast;
    char                *outFile;
    char                *inFile;
    char                *URL;
    char                *useragent;
    char                *referer;
    char                *proxy;
    int                  transferText;
    char                *userpwd;
    char                *proxyuserpwd;
    char                *range;
    char                *errorBuffer;
    char                *errorBufferName;
    char                *errorBufferKey;
    char                *postFields;
    char                *ftpport;
    char                *cookie;
    char                *cookiefile;
    char                *sslcert;
    char                *sslcertpasswd;
    char                *headerFile;
    char                *customrequest;
    char                *stderrFile;
    char                *interface;
    char                *krb4level;
    char                *cainfo;
    char                *randomFile;
    char                *egdsocket;
    char                *headerVar;
    char                *bodyVarName;
    struct MemoryStruct bodyVar;
    char                *progressProc;
    char                *cancelTransVarName;
    int                 cancelTrans;
    char                *writeProc;
    char                *readProc;
    char                *cookiejar;
    char                *sslcipherlist;
    char                *sslcerttype;
    char                *sslkey;
    char                *sslkeytype;
    char                *sslkeypasswd;
    char                *sslengine;
    char                *sslenginedefault;
};

static char *commandTable[] = {
    "setopt",
    "perform",
    "getinfo",
    "cleanup",
    "configure",
    "duphandle",
    (char *) NULL
};

static char    *optionTable[] = {
    "CURLOPT_URL",           "CURLOPT_FILE",           "CURLOPT_INFILE",
    "CURLOPT_USERAGENT",     "CURLOPT_REFERER",        "CURLOPT_VERBOSE",
    "CURLOPT_HEADER",        "CURLOPT_NOBODY",         "CURLOPT_PROXY",
    "CURLOPT_PROXYPORT",     "CURLOPT_HTTPPROXYTUNNEL","CURLOPT_FAILONERROR",
    "CURLOPT_TIMEOUT",       "CURLOPT_LOW_SPEED_LIMIT","CURLOPT_LOW_SPEED_TIME",
    "CURLOPT_RESUME_FROM",   "CURLOPT_INFILESIZE",     "CURLOPT_UPLOAD",
    "CURLOPT_FTPLISTONLY",   "CURLOPT_FTPAPPEND",      "CURLOPT_NETRC",
    "CURLOPT_FOLLOWLOCATION","CURLOPT_TRANSFERTEXT",   "CURLOPT_PUT",
    "CURLOPT_MUTE",          "CURLOPT_USERPWD",        "CURLOPT_PROXYUSERPWD",
    "CURLOPT_RANGE",         "CURLOPT_ERRORBUFFER",    "CURLOPT_HTTPGET",
    "CURLOPT_POST",          "CURLOPT_POSTFIELDS",     "CURLOPT_POSTFIELDSIZE",
    "CURLOPT_FTPPORT",       "CURLOPT_COOKIE",         "CURLOPT_COOKIEFILE",
    "CURLOPT_HTTPHEADER",    "CURLOPT_HTTPPOST",       "CURLOPT_SSLCERT",
    "CURLOPT_SSLCERTPASSWD", "CURLOPT_SSLVERSION",     "CURLOPT_CRLF",
    "CURLOPT_QUOTE",         "CURLOPT_POSTQUOTE",      "CURLOPT_WRITEHEADER",
    "CURLOPT_TIMECONDITION", "CURLOPT_TIMEVALUE",      "CURLOPT_CUSTOMREQUEST",
    "CURLOPT_STDERR",        "CURLOPT_INTERFACE",      "CURLOPT_KRB4LEVEL",
    "CURLOPT_SSL_VERIFYPEER","CURLOPT_CAINFO",         "CURLOPT_FILETIME",
    "CURLOPT_MAXREDIRS",     "CURLOPT_MAXCONNECTS",    "CURLOPT_CLOSEPOLICY",
    "CURLOPT_RANDOM_FILE",   "CURLOPT_EGDSOCKET",      "CURLOPT_CONNECTTIMEOUT",
    "CURLOPT_NOPROGRESS",    "CURLOPT_HEADERVAR",      "CURLOPT_BODYVAR",
    "CURLOPT_PROGRESSPROC","CURLOPT_CANCELTRANSVARNAME","CURLOPT_WRITEPROC",
    "CURLOPT_READPROC",      "CURLOPT_SSL_VERIFYHOST",  "CURLOPT_COOKIEJAR",
    "CURLOPT_SSL_CIPHER_LIST","CURLOPT_HTTP_VERSION",  "CURLOPT_FTP_USE_EPSV",
    "CURLOPT_SSLCERTTYPE",    "CURLOPT_SSLKEY",        "CURLOPT_SSLKEYTYPE",
    "CURLOPT_SSLKEYPASSWD",   "CURLOPT_SSL_ENGINE",    "CURLOPT_SSL_ENGINEDEFAULT",
    "CURLOPT_PREQUOTE",
    (char *) NULL
};

static char    *configTable[] = {
    "-url",               "-file",               "-infile",
    "-useragent",         "-referer",            "-verbose",
    "-header",            "-nobody",             "-proxy",
    "-proxyport",         "-httpproxytunnel",    "-failonerror",
    "-timeout",           "-lowspeedlimit",      "-lowspeedtime",
    "-resumefrom",        "-infilesize",         "-upload",
    "-ftplistonly",       "-ftpappend",          "-netrc",
    "-followlocation",    "-transfertext",       "-put",
    "-mute",              "-userpwd",            "-proxyuserpwd",
    "-range",             "-errorbuffer",        "-httpget",
    "-post",              "-postfields",         "-postfieldssize",
    "-ftpport",           "-cookie",             "-cookiefile",
    "-httpheader",        "-httppost",           "-sslcert",
    "-sslcertpasswd",     "-sslversion",         "-crlf",
    "-quote",             "-postquote",          "-writeheader",
    "-timecondition",     "-timevalue",          "-customrequest",
    "-stderr",            "-interface",          "-krb4level",
    "-sslverifypeer",     "-cainfo",             "-filetime",
    "-maxredirs",         "-maxconnects",        "-closepolicy",
    "-randomfile",        "-egdsocket",          "-connecttimeout",
    "-noprogress",        "-headervar",          "-bodyvar",
    "-progressproc",      "-canceltransvarname", "-writeproc",
    "-readproc",          "-sslverifyhost",      "-cookiejar",
    "-sslcipherlist",     "-httpversion",        "-ftpuseepsv",
    "-sslcerttype",       "-sslkey",             "-sslkeytype",
    "-sslkeypasswd",      "-sslengine",          "-sslenginedefault",
    "-prequote",
    (char *) NULL
};

static char    *timeCond[] = {
    "ifmodsince", "ifunmodsince",
    (char *) NULL
};

static char    *closePolicy[]={
    "oldest", "leastrecentlyused", "leasttraffic", "slowest",
    (char *) NULL
};

static char    *getInfoTable[]={
    "effectiveurl",   "httpcode",       "filetime",
    "totaltime",      "namelookuptime", "connecttime",
    "pretransfertime","sizeupload",     "sizedownload",
    "speeddownload",  "speedupload",    "headersize",
    "requestsize",    "sslverifyresult","contentlengthdownload",
    "contentlengthupload",              "starttransfertime",
    "contenttype",
    (char *) NULL
};

static char   *curlFormTable[]={
    "name", "contents", "file", "contenttype", "contentheader", (char *)NULL
};

static char   *httpVersionTable[] = {
    "none", "1.0", "1.1", (char *)NULL
};

int Tclcurl_Init(Tcl_Interp *interp);

char *curlCreateObjCmd(Tcl_Interp *interp,struct curlObjData  *curlData);
int curlInitObjCmd(ClientData clientData, Tcl_Interp *interp, int objc,
        Tcl_Obj *CONST objv[]);
int curlObjCmd(ClientData clientData, Tcl_Interp *interp, int objc,
        Tcl_Obj *CONST objv[]);
int curlDeleteCmd(ClientData clientData);

int curlOpenFiles(Tcl_Interp *interp,struct curlObjData *curlData);

int curlPerform(Tcl_Interp *interp,CURL *curlHandle,struct curlObjData *curlData);

int curlSetOptsTransfer(Tcl_Interp *interp, struct curlObjData *curlData,int objc,
        Tcl_Obj *CONST objv[]);

int curlConfigTransfer(Tcl_Interp *interp, struct curlObjData *curlData,int objc,
        Tcl_Obj *CONST objv[]);

int curlSetOpts(Tcl_Interp *interp, struct curlObjData *curlData,
        Tcl_Obj *CONST objv,int tableIndex);

int SetoptInt(Tcl_Interp *interp,CURL *curlHandle,CURLoption opt,int tableIndex,
            Tcl_Obj *tclObj);
int SetoptLong(Tcl_Interp *interp,CURL *curlHandle,CURLoption opt,int tableIndex,
            Tcl_Obj *tclObj);
int SetoptChar(Tcl_Interp *interp,char **charPtr,CURL *curlHandle,CURLoption opt,
            int tableIndex,Tcl_Obj *tclObj);
int SetoptsList(Tcl_Interp *interp,struct curl_slist **slistPtr,Tcl_Obj *CONST objv);

CURLcode curlGetInfo(Tcl_Interp *interp,CURL *curlHandle,int tableIndex);

void curlFreeSpace(CURL *curlHandle,struct curlObjData *curlData);

void curlErrorSetOpt(Tcl_Interp *interp, int option, char *parPtr);

size_t curlHeaderReader(void *ptr,size_t size,size_t nmemb,FILE *stream);

size_t curlBodyReader(void *ptr,size_t size,size_t nmemb,FILE *curlDataPtr);

int curlProgressCallback(void *clientp,size_t dltotal,size_t dlnow,
        size_t ultotal,size_t ulnow);

size_t curlWriteProcInvoke(void *ptr,size_t size,size_t nmemb,FILE *curlDataPtr);
size_t curlReadProcInvoke(void *ptr,size_t size,size_t nmemb,FILE *curlDataPtr);

int curlVersion (ClientData clientData, Tcl_Interp *interp,
    int objc,Tcl_Obj *CONST objv[]);

int curlEscape(ClientData clientData, Tcl_Interp *interp,
    int objc,Tcl_Obj *CONST objv[]);

int curlUnescape(ClientData clientData, Tcl_Interp *interp,
    int objc,Tcl_Obj *CONST objv[]);

int curlCopyCurlData (struct curlObjData *curlDataOld,
                      struct curlObjData *curlDataNew);

char *curlstrdup (char *old);


#ifdef  __cplusplus
}
#endif

