/************************************************************************/
/*									*/
/*  Ted: Manipulation of font and text attributes.			*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Get font properties of the current position.			*/
/*									*/
/************************************************************************/

static void tedGetPositionAttributes(
				const BufferDocument *		bd,
				const DocumentPosition *	dp,
				char **				pFamilyName,
				int *				pPsFamilyNumber,
				int *				pEncoding,
				PropertyMask *			pUpdMask,
				TextAttribute *			pTaNew )
    {
    const DocumentFontList *	dfl= &(bd->bdProperties.dpFontList);
    BufferItem *		bi= dp->dpBi;
    int				part= dp->dpParticule;
    TextParticule *		tp= bi->biParaParticules+ part;
    DocumentFont *		df;

    df= dfl->dflFonts+ tp->tpTextAttribute.taFontNumber;

    *pFamilyName= df->dfName;
    *pPsFamilyNumber= df->dfPsFamilyNumber;
    *pEncoding= df->dfEncodingUsed;

    *pTaNew= tp->tpTextAttribute;

    PROPmaskCLEAR( pUpdMask );
    PROPmaskFILL( pUpdMask, TAprop_COUNT );

    return;
    }

/************************************************************************/
/*									*/
/*  Get the common text properties of the current selection.		*/
/*									*/
/************************************************************************/

static void tedGetSelectionAttributes(
				TedDocument *		td,
				const char **		pFamilyName,
				int *			pPsFamilyNumber,
				int *			pEncoding,
				PropertyMask *		pUpdMask,
				TextAttribute *		pTaNew )
    {
    const BufferDocument *	bd= td->tdDocument;
    const DocumentFontList *	dfl= &(bd->bdProperties.dpFontList);
    BufferItem *		bi;
    int				part;
    const TextParticule *	tp;


    char *			familyName= (char *)0;
    int				psFamilyNumber= -1;
    int				encoding= -1;

    TextAttribute		taNew;
    PropertyMask		updMask;

    DocumentSelection		ds;
    SelectionGeometry		sg;

    if  ( tedGetSelection( &ds, &sg, td ) )
	{ LDEB(1); return;	}

    bi= ds.dsBegin.dpBi;
    part= ds.dsBegin.dpParticule;
    tp= bi->biParaParticules+ part;

    tedGetPositionAttributes( bd, &(ds.dsBegin),
				    &familyName, &psFamilyNumber, &encoding,
				    &updMask, &taNew );

    PROPmaskCLEAR( &updMask );

    for (;;)
	{
	int	col;

	col= bi->biParent->biNumberInParent;

	if  ( ds.dsCol0 < 0					||
	      ds.dsCol1 < 0					||
	      ( col >= ds.dsCol0 && col <= ds.dsCol1 )	)
	    {
	    while( part < bi->biParaParticuleCount )
		{
		PropertyMask	pm;
		PropertyMask	pmAll;

		TextAttribute	ta= tp->tpTextAttribute;
		DocumentFont *	df= dfl->dflFonts+ ta.taFontNumber;

		if  ( bi == ds.dsEnd.dpBi			&&
		      tp->tpStroff >= ds.dsEnd.dpStroff	)
		    { break;	}

		PROPmaskCLEAR( &pm );

		PROPmaskCLEAR( &pmAll );
		PROPmaskFILL( &pmAll, TAprop_COUNT );

		docAttributeDifference( &pm, taNew,
					    tp->tpTextAttribute, &pmAll );

		utilPropMaskOr( &updMask, &updMask, &pm );

		if  ( df->dfEncodingUsed != encoding )
		    { encoding= -1;	}

		tp++; part++;
		}
	    }

	if  ( bi == ds.dsEnd.dpBi )
	    { break;	}

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { break;	}

	part= 0; tp= bi->biParaParticules;
	}

    utilPropMaskNot( &updMask, &updMask );

    if  ( PROPmaskISSET( &updMask, TApropFONTFAMILY ) )
	{
	DocumentFont *		df; df= dfl->dflFonts+ taNew.taFontNumber;

	familyName= df->dfName;
	psFamilyNumber= df->dfPsFamilyNumber;
	encoding= df->dfEncodingUsed;
	}
    else{
	familyName= (char *)0;
	psFamilyNumber= -1;
	encoding= -1;
	}

    *pFamilyName= familyName;
    *pPsFamilyNumber= psFamilyNumber;
    *pEncoding= encoding;
    *pUpdMask= updMask;
    *pTaNew= taNew;

    return;
    }

/************************************************************************/
/*									*/
/*  Get font properties of the current position or selection.		*/
/*									*/
/************************************************************************/

int tedGetDocumentAttributes(	TedDocument *		td,
				const char **		pFamilyName,
				int *			pPsFamilyNumber,
				int *			pEncoding,
				PropertyMask *		pUpdMask,
				TextAttribute *		pTaNew )
    {
    if  ( tedHasIBarSelection( td ) )
	{
	BufferDocument *	bd= td->tdDocument;
	DocumentFontList *	dfl= &(bd->bdProperties.dpFontList);
	TextAttribute		ta= td->tdCurrentTextAttribute;
	DocumentFont *		df= dfl->dflFonts+ ta.taFontNumber;

	if  ( ta.taFontNumber < 0 || ta.taFontNumber >= dfl->dflCount )
	    { LLDEB(ta.taFontNumber,dfl->dflCount); return -1; }

	*pFamilyName= df->dfName;
	*pPsFamilyNumber= df->dfPsFamilyNumber;
	*pEncoding= df->dfEncodingUsed;

	*pTaNew= ta;

	PROPmaskCLEAR( pUpdMask );
	PROPmaskFILL( pUpdMask, TAprop_COUNT );

	return 0;
	}

    if  ( tedHasSelection( td ) )
	{
	tedGetSelectionAttributes( td, pFamilyName, pPsFamilyNumber, pEncoding,
							pUpdMask, pTaNew );

	return 0;
	}

    return 1;
    }

int tedGetDocumentAttributeString(	char *		scratch,
					TedDocument *	td )
    {
    const char *	familyName= (char *)0;
    int			psFamilyNumber= -1;
    int			enc= -1;

    PropertyMask	updMask;
    TextAttribute	taNew;

    if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber, &enc,
							&updMask, &taNew ) )
	{ return -1;	}

    appFontAttributeString( scratch, familyName, &updMask, taNew );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Change the attributes of a particule.				*/
/*									*/
/************************************************************************/

int tedChangeParticuleAttribute( AppDrawingData *	add,
				TextParticule *		tp,
				DocumentFontList *	dfl,
				const PropertyMask *	updMask,
				TextAttribute		taNew )
    {
    TextAttribute	ta;

    PropertyMask	changeMask;

    PROPmaskCLEAR( &changeMask );

    ta= tp->tpTextAttribute;

    docUpdateTextAttribute( &changeMask, &ta, taNew, updMask );

    if  ( ! PROPmaskISEMPTY( &changeMask )	||
	  tp->tpPhysicalFont < 0		)
	{
	int	physicalFont= appOpenDocumentFont( add, dfl, ta );

	if  ( physicalFont < 0 )
	    { LLDEB(ta.taFontIsBold,ta.taFontIsSlanted); return -1; }

	tp->tpTextAttribute= ta;
	tp->tpPhysicalFont= physicalFont;
	}

    return 0;
    }
