/************************************************************************/
/*									*/
/*  Translation of GUI Drawing primitives to the actual implementing	*/
/*  GUI system. As we do not have the pretentence to introduce our own	*/
/*  GUI layer, as much as possible is done through macros. (#defines)	*/
/*									*/
/************************************************************************/

#   ifndef	APP_GUI_BASE_H
#   define	APP_GUI_BASE_H

#   ifdef __VMS
#	if defined(USE_MOTIF) || defined(USE_GTK)
#	    include	<vms_x_fix.h>
#	endif
#   endif

#   ifdef USE_GTK

#   include	<gtk/gtk.h>

#   endif

#   ifdef USE_MOTIF

#   include	<X11/Xlib.h>
#   include	<X11/Intrinsic.h>
#   include	<X11/IntrinsicP.h>
#   include	<Xm/Xm.h>

#   if XtVersion < 11006
#	define	USE_X11_R5	1
#   endif

#   endif

/************************************************************************/
/*									*/
/*  Basic GUI primitives.						*/
/*									*/
/************************************************************************/

#   ifdef USE_GTK

#   define KEY_CONTROL_MASK		GDK_CONTROL_MASK
#   define KEY_SHIFT_MASK		GDK_SHIFT_MASK

typedef		int			APP_INPUT_CONTEXT;
typedef		int			APP_INPUT_METHOD;
typedef		guint			(APP_KEY_VALUE);

typedef		GdkGC			(*APP_GC);
typedef		GtkWidget		(*APP_WIDGET);
typedef		GdkPixmap		(*APP_BITMAP_IMAGE);
typedef		GdkBitmap		(*APP_BITMAP_MASK);
typedef		GdkColor		(APP_COLOR_RGB);
typedef		GdkFont			(APP_FONT);
typedef		GdkDrawable		(*APP_DRAWABLE);
typedef		GdkWindow		(*APP_WINDOW);
typedef		GdkCursor		(*APP_CURSOR);
typedef		GdkAtom			(APP_ATOM);
typedef		GdkPoint		(APP_POINT);
typedef		GdkSegment		(APP_SEGMENT);
typedef		GdkImage		(APP_IMAGE);

typedef		GtkSignalFunc		(APP_CALLBACK_FUNC);

typedef		GtkSignalFunc		(APP_MENU_CALLBACK);
typedef		GtkSignalFunc		(APP_SCROLLBAR_CALLBACK);
typedef		GtkSignalFunc		(APP_BUTTON_CALLBACK);
typedef		GtkSignalFunc		(APP_TOGGLE_CALLBACK);
typedef		GtkSignalFunc		(APP_TEXT_ACTIVATE_CALLBACK);
typedef		GtkSignalFunc		(APP_DRAW_BUTTON_CALLBACK);
typedef		GtkSignalFunc		(APP_EVENT_HANDLER);
typedef		GtkSignalFunc		(APP_LIST_CALLBACK);
typedef		GtkSignalFunc		(APP_CLOSE_CALLBACK);
typedef		GtkSignalFunc		(APP_DESTROY_CALLBACK);
typedef		GtkFunction		(APP_TIMER_CALLBACK);

typedef		GdkEvent		(APP_EVENT);
typedef		GdkEventButton		(APP_MOUSE_CLICK_EVENT);

typedef		GtkSelectionData	(APP_SELECTION_EVENT);

typedef void (*APP_GIVE_COPY)(		GtkWidget *		w,
					APP_SELECTION_EVENT *	event,
					guint			info,
					guint			time,
					void *			through );

typedef void (*APP_PASTE_REPLY)(	GtkWidget *		w,
					APP_SELECTION_EVENT *	gsd,
					guint			time,
					void *			voided );

#define		APP_GIVE_COPY(n,w,e,t)					\
		void n(			GtkWidget *		w,	\
					APP_SELECTION_EVENT *	e,	\
					guint			info,	\
					guint			time,	\
					void *			t	)

#define		APP_PASTE_REPLY(n,w,e,t)				\
		void n(			GtkWidget *		w,	\
					APP_SELECTION_EVENT *	e,	\
					guint			time,	\
					void *			t	)

#define		APP_EVENT_HANDLER(n,w,t,e)				\
		void n(			GtkWidget *		w,	\
					GdkEvent *		e,	\
					void *			t	)

#define		APP_LIST_CALLBACK(n,w,t,c)				\
		void n(			GtkWidget *		w,	\
					void *			c,	\
					void *			t	)

#define		APP_CLOSE_CALLBACK(n,w,t)				\
		void n(			GtkWidget *		w,	\
					GdkEvent *		e,	\
					void *			t	)

#define		APP_DESTROY_CALLBACK(n,w,t)				\
		void n(			GtkWidget *		w,	\
					GdkEvent *		e,	\
					void *			t	)

#define		APP_TIMER_HANDLER(n,d)					\
		int n(			void *			d	)

typedef struct AppDialog
    {
    GtkWidget *		adTopWidget;
    int			adResponse;
    guint		adCloseId;
    GtkAccelGroup *	adAccelGroup;
    } AppDialog;

typedef struct AppToplevel
    {
    GtkWidget *		atTopWidget;
    GtkAccelGroup *	atAccelGroup;
    } AppToplevel;

typedef struct AppOptionmenu
    {
    APP_WIDGET	aomInplace;
    APP_WIDGET	aomPulldown;
    } AppOptionmenu;

#   define	COLUMN_SPACING_GTK	4
#   define	WINDOW_BORDER_GTK	4
#   define	FRAME_BORDER_GTK	4
#   define	ROW_XPADDING_GTK	4
#   define	ROW_YPADDING_GTK	2

#   endif

#   ifdef USE_MOTIF

#   define KEY_CONTROL_MASK		ControlMask
#   define KEY_SHIFT_MASK		ShiftMask

typedef		XIC			APP_INPUT_CONTEXT;
typedef		XIM			APP_INPUT_METHOD;
typedef		KeySym			(APP_KEY_VALUE);

typedef		GC			APP_GC;
typedef		Widget			APP_WIDGET;
typedef		Pixmap			(APP_BITMAP_IMAGE);
typedef		Pixmap			(APP_BITMAP_MASK);
typedef		XColor			(APP_COLOR_RGB);
typedef		XFontStruct		(APP_FONT);
typedef		Drawable		(APP_DRAWABLE);
typedef		Window			(APP_WINDOW);
typedef		Cursor			(APP_CURSOR);
typedef		Atom			(APP_ATOM);
typedef		XPoint			(APP_POINT);
typedef		XSegment		(APP_SEGMENT);
typedef		XImage			(APP_IMAGE);

typedef		XtCallbackProc		(APP_CALLBACK_FUNC);

typedef		XtCallbackProc		(APP_MENU_CALLBACK);
typedef		XtCallbackProc		(APP_SCROLLBAR_CALLBACK);
typedef		XtCallbackProc		(APP_BUTTON_CALLBACK);
typedef		XtCallbackProc		(APP_TOGGLE_CALLBACK);
typedef		XtCallbackProc		(APP_TEXT_ACTIVATE_CALLBACK);
typedef		XtCallbackProc		(APP_DRAW_BUTTON_CALLBACK);

typedef		XtEventHandler		(APP_EVENT_HANDLER);
typedef		XtCallbackProc		(APP_LIST_CALLBACK);
typedef		XtCallbackProc		(APP_CLOSE_CALLBACK);
typedef		XtCallbackProc		(APP_DESTROY_CALLBACK);
typedef		XtTimerCallbackProc	(APP_TIMER_CALLBACK);

typedef		XEvent			(APP_EVENT);
typedef		XButtonEvent		(APP_MOUSE_CLICK_EVENT);

typedef		XEvent			(APP_SELECTION_EVENT);

typedef void (*APP_GIVE_COPY)(	Widget			w,
				void *			through,
				APP_SELECTION_EVENT *	e,
				Boolean *		pRefused );

typedef void (*APP_PASTE_REPLY)( Widget			w,
				void *			through,
				APP_SELECTION_EVENT *	e,
				Boolean *		pRefused );

#define		APP_GIVE_COPY(n,w,e,t)					\
		void n(			Widget			w,	\
					void *			t,	\
					APP_SELECTION_EVENT *	e,	\
					Boolean *		pRefused )

#define		APP_PASTE_REPLY(n,w,e,t)				\
		void n(			Widget			w,	\
					void *			t,	\
					APP_SELECTION_EVENT *	e,	\
					Boolean *		pRefused )

#define		APP_EVENT_HANDLER(n,w,t,e)			\
		void n(			Widget		w,	\
					void *		t,	\
					XEvent *	e,	\
					Boolean *	pRefused )

#define		APP_LIST_CALLBACK(n,w,t,c)				\
		void n(			Widget			w,	\
					void *			t,	\
					void *			c	)

#define		APP_CLOSE_CALLBACK(n,w,t)				\
		void n(			Widget			w,	\
					void *			t,	\
					void *			c	)

#define		APP_DESTROY_CALLBACK(n,w,t)				\
		void n(			Widget			w,	\
					void *			t,	\
					void *			c	)

#define		APP_TIMER_HANDLER(n,d)					\
		void n(			void *			d,	\
					XtIntervalId *		xii	)

typedef struct AppDialog
    {
    Widget	adTopWidget;
    Widget	adDialog;
    int		adResponse;
    int		adContinue;
    } AppDialog;

typedef struct AppToplevel
    {
    Widget		atTopWidget;
    } AppToplevel;

typedef struct AppOptionmenu
    {
    APP_WIDGET	aomInplace;
    APP_WIDGET	aomPulldown;
    } AppOptionmenu;

#   endif

#   endif	/* APP_GUI_BASE_H */
