/************************************************************************/
/*									*/
/*  Page Layout page on an inspector:					*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<limits.h>

#   include	<appDebugon.h>

#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"appFrame.h"
#   include	"appPageLayoutTool.h"

#   define	DRH_MM		45

/************************************************************************/
/*									*/
/*  Refresh the section page.						*/
/*									*/
/************************************************************************/

static void appPageLayoutRefreshPageLayoutPage(	PageLayoutTool *	plt )
    {
    EditApplication *		ea= plt->pltApplication;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dg= &(plt->pltGeometryChosen);
    const int			set= 1;

    char			scratch[50];

    appPaperChooserAdaptToGeometry( &(plt->pltPaperChooser),
						    plt->pltUnitType, dg, set );

    appMarginToolShowMargins( &(plt->pltMarginTool), plt->pltUnitType, dg );

    appExposeRectangle( add, 0, 0, 0, 0 );

    if  ( plt->pltHeaderPositionText )
	{
	appGeoLengthToString( scratch,
				dg->dgHeaderPositionTwips, ea->eaUnitInt );
	appStringToTextWidget( plt->pltHeaderPositionText, scratch );
	}

    if  ( plt->pltFooterPositionText )
	{
	appGeoLengthToString( scratch,
				dg->dgFooterPositionTwips, ea->eaUnitInt );
	appStringToTextWidget( plt->pltFooterPositionText, scratch );
	}

    return;
    }

void appPageLayoutPageRefresh(	PageLayoutTool *		plt,
				int *				pEnabled,
				InspectorSubject *		is,
				const DocumentGeometry *	dgSect,
				const DocumentGeometry *	dgDoc )
    {
    if  ( plt->pltManageSelection )
	{
	plt->pltGeometryChosen= *dgSect;
	plt->pltGeometrySetSelection= *dgSect;
	}
    else{
	plt->pltGeometryChosen= *dgDoc;
	plt->pltGeometrySetSelection= *dgDoc;
	}

    plt->pltGeometrySetDocument= *dgDoc;

    appPageLayoutRefreshPageLayoutPage( plt );

    *pEnabled= 1;

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Change' button of the row tool has been pushed.		*/
/*									*/
/************************************************************************/

static void appPageLayoutChangeLayoutPushed(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidpbcs )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    EditApplication *		ea= plt->pltApplication;

    int				changed;

    PropertyMask		sizeUpdMask;
    PropertyMask		margUpdMask;
    PropertyMask		margChgMask;
    PropertyMask		setMask;

    DocumentGeometry		dgNew;

    const int			minValue= 1;
    const int			adaptToMin= 0;
    const int			maxValue= INT_MAX;
    const int			adaptToMax= 0;

    PROPmaskCLEAR( &sizeUpdMask );
    PROPmaskCLEAR( &margUpdMask );

    PROPmaskCLEAR( &setMask );
    PROPmaskFILL( &setMask, DGprop_COUNT );

    appInitDocumentGeometry( &dgNew );

    dgNew= plt->pltGeometryChosen;

    if  ( appPaperChooserGetSize( &sizeUpdMask, &(plt->pltPaperChooser),
						plt->pltUnitType, &dgNew ) )
	{ LDEB(1); return;	}

    PROPmaskCLEAR( &margChgMask );
    PROPmaskFILL( &margChgMask, DGprop_COUNT );

    if  ( appMarginToolGetMargins( &margUpdMask, &margChgMask, plt->pltUnitType,
					     &(plt->pltMarginTool), &dgNew ) )

    if  ( appMarginToolCheckMargins( &dgNew ) )
	{ return;	}

    if  ( plt->pltManageHeadersFooters )
	{
	if  ( appGetLengthFromTextWidget( plt->pltHeaderPositionText,
			    &(dgNew.dgHeaderPositionTwips),
			    &changed, ea->eaUnitInt,
			    minValue, adaptToMin, maxValue, adaptToMax ) )
	    { return;	}

	if  ( appGetLengthFromTextWidget( plt->pltFooterPositionText,
			    &(dgNew.dgFooterPositionTwips),
			    &changed, ea->eaUnitInt,
			    minValue, adaptToMin, maxValue, adaptToMax ) )
	    { return;	}
	}
    else{
	PROPmaskUNSET( &setMask, DGpropHEADER_POSITION );
	PROPmaskUNSET( &setMask, DGpropFOOTER_POSITION );
	}

    if  ( w == plt->pltChangeSelectionWidget )
	{ (*ea->eaSetPageLayout)( ea, &dgNew, &setMask, 0 );	}
    else{ (*ea->eaSetPageLayout)( ea, &dgNew, &setMask, 1 );	}


    return;
    }

static void appSectHeaderFooterPosChanged(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidpbcs )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    EditApplication *		ea= plt->pltApplication;
    DocumentGeometry *		dgSect= &(plt->pltGeometryChosen);

    int				width;
    int				changed;

    const int			minValue= 1;
    const int			adaptToMin= 0;
    const int			maxValue= INT_MAX;
    const int			adaptToMax= 0;

    if  ( w == plt->pltHeaderPositionText )
	{ width= dgSect->dgHeaderPositionTwips;	}
    if  ( w == plt->pltFooterPositionText )
	{ width= dgSect->dgFooterPositionTwips;	}

    if  ( ! appGetLengthFromTextWidget( w, &width, &changed, ea->eaUnitInt,
				minValue, adaptToMin, maxValue, adaptToMax ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, width, ea->eaUnitInt );
	appStringToTextWidget( w, scratch );
	}
    }

/************************************************************************/
/*									*/
/*  One of the margins has been changed by the user.			*/
/*									*/
/************************************************************************/

static void appPaperMarginChanged(	APP_WIDGET	w,
					void *		voidplt,
					void *		voidcbs	 )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dgSect= &(plt->pltGeometryChosen);

    PropertyMask		dgUpdMask;
    PropertyMask		dgChgMask;

    DocumentGeometry		dg;

    PROPmaskCLEAR( &dgUpdMask );
    PROPmaskCLEAR( &dgChgMask );

    dg= *dgSect;

    PROPmaskFILL( &dgChgMask, DGprop_COUNT );

    if  ( appMarginToolGetMargins( &dgUpdMask, &dgChgMask,
			    plt->pltUnitType, &(plt->pltMarginTool), &dg ) )
	{ return;	}

    if  ( PROPmaskISEMPTY( &dgUpdMask ) )
	{ return;	}

    if  ( appMarginToolCheckMargins( &dg ) )
	{ return;	}

    dgSect->dgLeftMarginTwips= dg.dgLeftMarginTwips;
    dgSect->dgTopMarginTwips= dg.dgTopMarginTwips;
    dgSect->dgRightMarginTwips= dg.dgRightMarginTwips;
    dgSect->dgBottomMarginTwips= dg.dgBottomMarginTwips;

    appExposeRectangle( add, 0, 0, 0, 0 );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Revert' button of the row tool has been pushed.		*/
/*									*/
/************************************************************************/

static void appPageLayoutRevertLayoutPushed(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidpbcs )
    {
    PageLayoutTool *	plt= (PageLayoutTool *)voidplt;

    if  ( w == plt->pltRevertSelectionWidget )
	{ plt->pltGeometryChosen= plt->pltGeometrySetSelection;	}
    else{ plt->pltGeometryChosen= plt->pltGeometrySetDocument;	}

    appPageLayoutRefreshPageLayoutPage( plt );

    return;
    }

/************************************************************************/
/*									*/
/*  Draw a schematic view of the page.					*/
/*									*/
/************************************************************************/

static APP_EVENT_HANDLER( appPageLayoutToolDrawPage, w, voidplt, exposeEvent )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dg= &(plt->pltGeometryChosen);

    appDrawPageDiagram( w, add, DRH_MM, dg );
    }

/************************************************************************/
/*									*/
/*  A paper size was chosen.						*/
/*									*/
/************************************************************************/

static void appPageLayoutToolPaperSizeChosen(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidpbcs )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dg= &(plt->pltGeometryChosen);

    appPaperSizeChosen( w, &(plt->pltPaperChooser), dg, plt->pltUnitType );

    appExposeRectangle( add, 0, 0, 0, 0 );

    return;
    }

static void appPageLayoutToolPaperSizeChanged(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidcbs )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dg= &(plt->pltGeometryChosen);

    const int			set= 0;

    appPaperSizeChanged( &(plt->pltPaperChooser), dg, plt->pltUnitType );

    appPaperChooserAdaptToGeometry( &(plt->pltPaperChooser),
						plt->pltUnitType, dg, set );

    appExposeRectangle( add, 0, 0, 0, 0 );

    return;
    }

/************************************************************************/
/*									*/
/*  One of the orientation toggle buttons has been pushed.		*/
/*									*/
/************************************************************************/

static void appPageLayoutToolOrientationChosen(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidtbcs  )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dg= &(plt->pltGeometryChosen);

    int					changed;

    appPaperOrientationChosen( w, voidtbcs, &changed,
						&(plt->pltPaperChooser),
						plt->pltUnitType, dg );

    if  ( changed )
	{ appExposeRectangle( add, 0, 0, 0, 0 );	}

    return;
    }

/************************************************************************/
/*									*/
/*  Make the frame for the header and footer positions.			*/
/*									*/
/************************************************************************/

static void appPageLayoutMakeHeaderFooterWidgets(
				APP_WIDGET			parent,
				const PageLayoutPageResources *	plpr,
				PageLayoutTool *		plt )
    {
    APP_WIDGET	label;
    APP_WIDGET	row;

    appMakeRowFrameInColumn( &(plt->pltHeaderFooterFrame),
					&(plt->pltHeaderFooterInside),
					parent, 2, plpr->plprPositionsText );

    appMakeColumnInRow( &(plt->pltHeaderFooterLeftColumn),
					plt->pltHeaderFooterInside, 0 );

    appMakeColumnInRow( &(plt->pltHeaderFooterRightColumn),
					plt->pltHeaderFooterInside, 1 );

    /**********************/
#   define	TW	7

    appMakeLabelAndTextRow( &row, &label, &(plt->pltHeaderPositionText),
				    plt->pltHeaderFooterLeftColumn,
				    plpr->plprHeaderPositionText, TW, 1 );

    appMakeLabelAndTextRow( &row, &label, &(plt->pltFooterPositionText),
				    plt->pltHeaderFooterRightColumn,
				    plpr->plprFooterPositionText, TW, 1 );

    appGuiSetGotValueCallbackForText( plt->pltHeaderPositionText,
				appSectHeaderFooterPosChanged, (void *)plt );

    appGuiSetGotValueCallbackForText( plt->pltFooterPositionText,
				appSectHeaderFooterPosChanged, (void *)plt );

    return;
    }

/************************************************************************/
/*									*/
/*  Make a page layout page in an inspector tool.			*/
/*									*/
/************************************************************************/

void appPageLayoutPageFillPage(	PageLayoutTool *		plt,
				int				doHdFt,
				int				doSelection,
				const PageLayoutPageResources *	plpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr )
    {
    EditApplication *	ea= plt->pltApplication;
    APP_WIDGET		row;

    /**/

    plt->pltUnitType= appUnitTypeInt( plpr->plprUnitType );
    if  ( plt->pltUnitType < 0 )
	{ SDEB(plpr->plprUnitType); plt->pltUnitType= UNITtyINCH;	}

    plt->pltHeaderPositionText= (APP_WIDGET)0;
    plt->pltFooterPositionText= (APP_WIDGET)0;
    plt->pltRevertSelectionWidget= (APP_WIDGET)0;
    plt->pltChangeSelectionWidget= (APP_WIDGET)0;

    /**/
    plt->pltPageResources= plpr;
    plt->pltManageHeadersFooters= doHdFt;
    plt->pltManageSelection= doSelection;

    /**/

    appInitDrawingData( &(plt->pltDrawingData) );

    appInitDocumentGeometry( &(plt->pltGeometrySetDocument) );
    appInitDocumentGeometry( &(plt->pltGeometrySetSelection) );
    appInitDocumentGeometry( &(plt->pltGeometryChosen) );

    appInitPaperChooser( &(plt->pltPaperChooser) );

    /**************/

    plt->pltPageDrawing= appMakePageDrawing( pageWidget, ea, DRH_MM,
				    appPageLayoutToolDrawPage, (void *)plt );

    appMakePaperChooserWidgets( pageWidget, plpr->plprPage,
					    &(plt->pltPaperChooser),
					    appPageLayoutToolPaperSizeChanged,
					    (void *)plt );

    appPaperChooserAddOrientationToggles( &(plt->pltPaperChooser),
					    plpr->plprPortraitText,
					    plpr->plprLandscapeText,
					    appPageLayoutToolOrientationChosen,
						(void *)plt );

    /**************/

    appMakeMarginToolWidgets( pageWidget, &(plpr->plprMarginToolResources),
					    &(plt->pltMarginTool),
					    appPaperMarginChanged,
					    (void *)plt );


    /**************/

    if  ( plt->pltManageHeadersFooters )
	{
	appPageLayoutMakeHeaderFooterWidgets( pageWidget, plpr, plt );
	}

    if  ( plt->pltManageSelection )
	{
	appInspectorMakeButtonRow( &row, pageWidget,
	    &(plt->pltRevertSelectionWidget), &(plt->pltChangeSelectionWidget),
	    plpr->plprRevertSelectionText, plpr->plprChangeSelectionText,
	    appPageLayoutRevertLayoutPushed, appPageLayoutChangeLayoutPushed,
	    (void *)plt );
	}

    appInspectorMakeButtonRow( &row, pageWidget,
	    &(is->isRevertButton), &(is->isApplyButton),
	    isr->isrRevert, isr->isrApplyToSubject,
	    appPageLayoutRevertLayoutPushed, appPageLayoutChangeLayoutPushed,
	    (void *)plt );

    plt->pltChangeDocumentWidget= is->isApplyButton;

    return;
    }

/************************************************************************/
/*									*/
/*  Finish the page layout page.					*/
/*									*/
/************************************************************************/

void appPageLayoutPageFillChoosers(	PageLayoutTool *		plt,
					const PageLayoutPageResources *	plpr )
    {
    appPaperChooserFillMenu( &(plt->pltPaperChooser),
			plpr->plprCustomPageSizeText,
			appPageLayoutToolPaperSizeChosen, (void *)plt );

    return;
    }

void appPageLayoutPageFinishPage(	PageLayoutTool *		plt,
					const PageLayoutPageResources *	plpr )
    {
    AppDrawingData *	add= &(plt->pltDrawingData);
    const double	magnification= 1.0;

    appPaperChooserRetreshMenuWidth( &(plt->pltPaperChooser) );

    if  ( appSetDrawingDataForWidget( plt->pltPageDrawing,
						    magnification, add ) )
	{ LDEB(1);				}
    else{ plt->pltDrawingDataAllocated= 1;	}

    return;
    }

/************************************************************************/
/*									*/
/*  Get page layout tool resources.					*/
/*									*/
/************************************************************************/

static AppConfigurableResource APP_PageSubjectResourceTable[]=
    {
    APP_RESOURCE( "tableToolPageLayout",
		offsetof(InspectorSubjectResources,isrSubjectName),
		"Page Layout" ),
    APP_RESOURCE( "tableToolChangeDocumentPageLayout",
		offsetof(InspectorSubjectResources,isrApplyToSubject),
		"Apply to Document" ),
    APP_RESOURCE( "tableToolRevertDocumentPageLayout",
		offsetof(InspectorSubjectResources,isrRevert),
		"Revert to Document" ),
    };

static AppConfigurableResource APP_PageToolResourceTable[]=
    {
    APP_RESOURCE( "tableToolRevertSection",
		offsetof(PageLayoutPageResources,plprRevertSelectionText),
		"Revert to Selection" ),
    APP_RESOURCE( "tableToolChangeSelection",
		offsetof(PageLayoutPageResources,plprChangeSelectionText),
		"Apply to Selection" ),
    /**/
    APP_RESOURCE( "unit",
		offsetof(PageLayoutPageResources,plprUnitType),
		"inch" ),
    APP_RESOURCE( "formatToolPageLayoutPage",
		offsetof(PageLayoutPageResources,plprPage),
		"Page" ),
    APP_RESOURCE( "pageToolCustom",
		offsetof(PageLayoutPageResources,plprCustomPageSizeText),
		"Custom" ),
    APP_RESOURCE( "pageToolPortrait",
		offsetof(PageLayoutPageResources,plprPortraitText),
		"Portrait" ),
    APP_RESOURCE( "pageToolLandscape",
		offsetof(PageLayoutPageResources,plprLandscapeText),
		"Landscape" ),
    /**/
    APP_RESOURCE( "pageToolMargins",
		offsetof(PageLayoutPageResources,
				plprMarginToolResources.mtrTitleText),
		"Margins" ),
    APP_RESOURCE( "pageToolLeftMargin",
		offsetof(PageLayoutPageResources,
				plprMarginToolResources.mtrLeftMarginText),
		"Left" ),
    APP_RESOURCE( "pageToolTopMargin",
		offsetof(PageLayoutPageResources,
				plprMarginToolResources.mtrTopMarginText),
		"Top" ),
    APP_RESOURCE( "pageToolRightMargin",
		offsetof(PageLayoutPageResources,
				plprMarginToolResources.mtrRightMarginText),
		"Right" ),
    APP_RESOURCE( "pageToolBottomMargin",
		offsetof(PageLayoutPageResources,
				plprMarginToolResources.mtrBottomMarginText),
		"Bottom" ),
    /**/
/*!*/
    APP_RESOURCE( "formatToolSectHeaderFooterPositions",
		offsetof(PageLayoutPageResources,plprPositionsText),
		"Positions" ),
    APP_RESOURCE( "formatToolSectHeaderPosition",
		offsetof(PageLayoutPageResources,plprHeaderPositionText),
		"Header" ),
    APP_RESOURCE( "formatToolSectFooterPosition",
		offsetof(PageLayoutPageResources,plprFooterPositionText),
		"Footer" ),
    };

void appPageLayoutPageGetResourceTable(	EditApplication *		ea,
					PageLayoutPageResources *	plpr,
					InspectorSubjectResources *	isr )
    {
    appGuiGetResourceValues( ea, (void *)plpr,
				APP_PageToolResourceTable,
				sizeof(APP_PageToolResourceTable)/
				sizeof(AppConfigurableResource) );

    appGuiGetResourceValues( ea, (void *)isr,
				APP_PageSubjectResourceTable,
				sizeof(APP_PageSubjectResourceTable)/
				sizeof(AppConfigurableResource) );

    return;
    }
