// Copyright (c) 1999, 2000 David A. Bartold
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Create water:
#if (TF_HAVE_WATER)
plane
{
  <0.00, 1.00, 0.00>, 0.00

  texture
  {
    pigment
    {
      color <0.61, 0.73, 0.80, TF_WATER_CLARITY>
    }

    finish
    {
      reflection (1.0 - TF_WATER_CLARITY)
      diffuse    0.15
      roughness  0.01
    }

    normal
    {
      average
      normal_map
      {
        [1.0 ripples 0.20  frequency 1300.0 phase 720.0 * clock]
        [1.0 ripples 0.30  frequency  343.0 phase 720.0 * clock]
      }
    }
  }

  interior
  {
    ior 1.33
  }

  scale vlength (<TF_X_SCALE, TF_Y_SCALE, TF_Z_SCALE>)
  translate <0.00, TF_WATER_LEVEL * TF_Y_SCALE, 0.00>
}
#end // TF_HAVE_WATER


// Create a bottommost plane for water
plane
{
  <0.00, 1.00, 0.00>, 0.00

  texture
  {
    pigment
    {
      color <0.40, 0.34, 0.22>  // Bottom-of-the-sea brown
    }
  }
}
