.TH "LaCheck" "1" "2010-12-10" "%%LACHECKREV%%"
.SH NAME
lacheck - A consistency checker for LaTeX documents.
.SH SYNOPSIS
.B lacheck 
.IR filename [ \fB.tex\fP ]
.SH DESCRIPTION
LaCheck is a general purpose consistency checker for LaTeX documents.
It reads a LaTeX document and displays warning messages, if it finds
bad sequences. It should be noted, that the badness is 
.I very
subjective.  LaCheck is designed to help find common mistakes in LaTeX
documents, especially those made by beginners.
.LP
The things checked are:
.LP
Mismatched groups (braces), environments and math mode
delimiters.  When a mismatch is found, line numbers for
.I "both" 
start and end of the mismatch is given. The error messages comes in
pairs, one for the end match and one for the beginning, marked with
\`<-\' and \`->\' respectively.
.LP
Bad spacing including missing a \`\\ \' after an abbreviation, missing
an \`\\@\' before a punctuation mark in a paragraph that is ended by
an capital letter, double spaces like \` \~\', bad usage of ellipsis
(like using ... instead of \\ldots, or using \\ldots where \\cdots
should be used), missing \~ before a \\cite or \\ref commands, space
before footnotes, italic corrections before comma, point, or italic
text, italic correction after normal text, missing italic correction
when switching from italic to normal text, and double italic
correction.
.LP
Badly placed punctuation marks around end of math mode
delimiters. This is, punctuation placed right after display math end
or punctuation placed right before text math end.  Sequences of
whitespace followed by punctuation marks are also caught.
.LP 
Bad use of quotation characters, i.e. constructs like "\'word" or
"word\`" are warned about, tabs in verbatim environments are caught,
certain TeX primitives are frowned upon, attempts to give font
specifiers arguments such as \\em{text} are noted, and use of @ in
LaTeX macros are reported.
.LP
LaCheck will read files that are input using \\input or \\include.
Files with suffix \`.sty\' are omitted, as they probably will cause
LaCheck to crash.
.LP 
LaCheck may be invoked from within Emacs(1) using compile:

To run:  
.B "M-x compile RET lacheck RET"
, and then 
.B "C-x `"
to parse the messages

.SH OUTPUT
The output is UNIX-error like, and may be parsed using Emacs(1)
compile mode. Here is a sample:

.PD 0
lacheck compiler
.TP
"/usr/mef/compiler.tex", line 34: missing \`\\\\\\\\ \' after "etc."
.TP
"/usr/mef/compiler.tex", line 179: double space at " ~"
.TP
"/usr/mef/compiler.tex", line 186: <- unmatched "}"
.TP
"/usr/mef/compiler.tex", line 181: -> unmatched "$$"
.PD 1
.LP
A control space \`\\ \' should be inserted at line 34, to prevent an
end-of-sentence space. 
Also, at line 179, the first space of the sequence " ~" should
probably be deleted.
The last two lines is an example, where the user mistyped, and
probably inserted an extra "}" somewhere.

.SH DIAGNOSTICS
Some special cases should be explained. In cases where a sentence ends
with something that LaCheck thinks is an abbreviation an missing \`\\
\' error may also occur, if the following sentence begins with a
lowercase letter.
.LP
A mismatch error may cause more to follow, due to the chosen
algorithm. In such cases just correct the
.I "first"
error and run LaCheck again
.LP
Braces, environments and math mode must be balanced within a file.
.LP
LaCheck may be confused by unmatched stuff placed inside verbatim-like
environments called something else than exactly \`verbatim\'.
.SH FILES
%%LACHECKPATH%%
.SH SEE ALSO
tex(1), emacs(1), latex(1)
.SH BUGS
LaCheck gets confused by advanced macros, is fooled by simple macros,
can't figure out if you use a non-standard way to switch italic on or
off, does not like TeX at all, does not provide any options to turn
off specific warnings, and is at best a crude approximation.
.LP
Ideas for improvements and bug reports are very welcome.  Such
should be directed to the maintainers, their email address is
<auc-tex_mgr@sunsite.auc.dk>.
.SH AUTHOR
Kresten Krab Thorup with modifications by Per Abrahamsen.

