%%
%% This is file `ebsthesis.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% ebsthesis.dtx  (with options: `ebsthesis')
%% 
%% The ebsthesis document class and ebstools package
%% Copyright (c) 2003 Philipp N. Baecker. All right reserved.
%%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
%%
\NeedsTeXFormat{LaTeX2e}[2001/06/01]
\ProvidesClass{ebsthesis}
              [2003/11/11 v0.9j EBS Thesis Class (PNB)]
\newif\if@singlespacing
\DeclareOption{onehalfspacing}{\@singlespacingfalse}
\DeclareOption{singlespacing}{\@singlespacingtrue}
\newif\if@headrules
\DeclareOption{headrules}{\@headrulestrue}
\DeclareOption{noheadrules}{\@headrulesfalse}
\newif\if@tools
\DeclareOption{tools}{\@toolstrue}
\DeclareOption{notools}{\@toolsfalse}
\newif\if@fancyfoot
\DeclareOption{fancyfoot}{\@fancyfoottrue}
\DeclareOption{nofancyfoot}{\@fancyfootfalse}
\DeclareOption{8pt}{\OptionNotUsed}
\DeclareOption{10pt}{\OptionNotUsed}
\DeclareOption{11pt}{\OptionNotUsed}
\DeclareOption{12pt}{\OptionNotUsed}
\DeclareOption{14pt}{\OptionNotUsed}
\DeclareOption{17pt}{\OptionNotUsed}
\DeclareOption{20pt}{\OptionNotUsed}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{extbook}}
\ExecuteOptions{onehalfspacing,headrules,notools,nomathematica,nofancyfoot}
\ProcessOptions\relax
\LoadClass[9pt]{extbook}[1999/01/07]
%% Modified generic headings and names
\renewcommand{\contentsname}{Table of Contents}
\renewcommand{\figurename}{Fig.}
\renewcommand{\tablename}{Table}
%% New generic headings and names
\newcommand{\abkuerzungsverzeichnisname}{List of Abbreviations}
\newcommand{\geleitwortname}{Foreword}
\newcommand{\inhaltsubersichtname}{Summary of Contents}
\newcommand{\symbolverzeichnisname}{List of Symbols}
\newcommand{\vorwortname}{Preface}
\newcommand{\appendicesname}{Appendices}
\newcommand{\listappendixname}{List of Appendices}
%% Babel support
\AtBeginDocument{%
  \@ifpackageloaded{babel}{%
     \addto\captionsenglish{%
       \renewcommand{\contentsname}{Table of Contents}%
       \renewcommand{\figurename}{Fig.}%
       \renewcommand{\tablename}{Table}%
     }%
     \addto\extrasenglish{%
       \renewcommand{\abkuerzungsverzeichnisname}{List of Abbreviations}%
       \renewcommand{\geleitwortname}{Foreword}%
       \renewcommand{\inhaltsubersichtname}{Summary of Contents}%
       \renewcommand{\symbolverzeichnisname}{List of Symbols}%
       \renewcommand{\vorwortname}{Preface}%
       \renewcommand{\appendicesname}{Appendices}%
       \renewcommand{\listappendixname}{List of Appendices}%
     }
     \addto{\captionsngerman}{%
       \renewcommand{\figurename}{Abb.}%
       \renewcommand{\tablename}{Tab.}%
     }
     \addto{\extrasngerman}{%
       \renewcommand{\abkuerzungsverzeichnisname}{Abk^^fcrzungsverzeichnis}%
       \renewcommand{\geleitwortname}{Geleitwort}%
       \renewcommand{\inhaltsubersichtname}{Inhalts^^fcbersicht}%
       \renewcommand{\symbolverzeichnisname}{Symbolverzeichnis}%
       \renewcommand{\vorwortname}{Vorwort}%
       \renewcommand{\appendicesname}{Anhang}%
       \renewcommand{\listappendixname}{Verzeichnis des Anhangs}%
     }%
   }{\relax}%
 }
%% New paper format and margins
\RequirePackage{geometry}[2002/07/08]
\geometry{%
  a5paper,%
  includeheadfoot,%
  centering,%
  totalwidth=11.5cm,%
  totalheight=18cm}
%% New linespacing
\RequirePackage[nodisplayskipstretch]{setspace}[2000/12/01]
\if@singlespacing
\setstretch{1.1}
\else
\setstretch{1.3}
\fi
%% New figures and tables
\RequirePackage{float}[2001/11/08]
\newcommand\floatc@ebs[2]{\small{\@fs@cfont #1}\enspace#2\par}
\newcommand\fs@ebsbottom{%
  \def\@fs@cfont{\bfseries}
  \let\@fs@capt\floatc@ebs%
  \def\@fs@pre{}%
  \def\@fs@mid{\vspace\abovecaptionskip\relax}%
  \def\@fs@post{}%
  \let\@fs@iftopcapt\iffalse}
\newcommand\fs@ebstop{%
  \def\@fs@cfont{\bfseries}%
  \let\@fs@capt\floatc@ebs%
  \def\@fs@pre{}%
  \def\@fs@mid{\vspace\belowcaptionskip\relax}%
  \def\@fs@post{}%
  \let\@fs@iftopcapt\iftrue}
\floatstyle{ebsbottom}
\restylefloat{figure}
\floatstyle{ebstop}
\restylefloat{table}
\setlength{\belowcaptionskip}{10pt}
%% New footnotes
\RequirePackage[hang,splitrule,stable]{footmisc}[2003/01/27]
\setlength{\footnotemargin}{\parindent}
\renewcommand{\mpfootnoterule}{\relax}
\if@fancyfoot
  \def\@makefntext#1{%
    \ifFN@hangfoot
      \@hangfrom{%
        \ifdim\footnotemargin>0pt
          \hb@xt@\footnotemargin{\hbox{\normalfont\@thefnmark}.\hss}%
        \else
          \@makefnmark
        \fi
      }%
    \else
      \parindent1em
      \noindent
      \ifdim\footnotemargin>0pt
        \hb@xt@ \footnotemargin{\hss\@makefnmark}%
      \else
        \ifdim\footnotemargin=0pt
          \llap{\textsuperscript{\@thefnmark}}%
        \else
          \llap{\hb@xt@ -\footnotemargin{\textsuperscript{\@thefnmark}\hss}}%
        \fi
      \fi
    \fi
    \footnotelayout#1%
  }
\fi
%% New headings
\RequirePackage[nobottomtitles*,%
                newparttoc,%
                clearempty,%
                pagestyles]{titlesec}[2002/04/07]
                \RequirePackage{calc}[1998/07/07]
\titleformat{\part}[display]{%
  \thispagestyle{empty}\normalfont\huge\mdseries}{%
  \bfseries\partname~\thepart}{0pt}{}
\titlespacing*{\part}{%
  0pt}{-\headheight-\headsep}{1.5ex plus .2ex}
\titleformat{\chapter}{%
  \normalfont\Large\bfseries}{%
  \thechapter}{1em}{}
\titlespacing*{\chapter}{%
  0pt}{-\headheight-\headsep}{1.5ex plus .2ex}
\titleformat{\section}{%
  \normalfont\large\bfseries}{%
  \thesection}{1em}{}
\titlespacing*{\section}{%
  0pt}{3.25ex plus 1ex minus .2ex}{1.5ex plus .2ex}
\titleformat{\subsection}{%
  \normalfont\normalsize\mdseries\itshape}{%
  \upshape\thesubsection}{1em}{}
\titlespacing*{\subsection}{%
  0pt}{3.25ex plus 1ex minus .2ex}{1.5ex plus .2ex}
\titleformat{\subsubsection}{%
  \normalfont\normalsize\mdseries\upshape}{%
  \thesubsubsection}{1em}{}
\titlespacing*{\subsubsection}{%
  0pt}{3.25ex plus 1ex minus .2ex}{1.5ex plus .2ex}
\titleformat{\paragraph}{%
  \normalfont\normalsize\mdseries\itshape}{%
  \upshape\theparagraph}{1em}{}
\titlespacing*{\paragraph}{%
  0pt}{3.25ex plus 1ex minus .2ex}{1.5ex plus .2ex}
\titleformat{\subparagraph}{%
  \normalfont\normalsize\mdseries\upshape}{%
  \thesubparagraph}{1em}{}
\titlespacing*{\subparagraph}{%
  0pt}{3.25ex plus 1ex minus .2ex}{1.5ex plus .2ex}
%% New numbering
\setcounter{secnumdepth}{3}
%% New headers and footers
\renewpagestyle{plain}[\small]{
  \sethead[][][]%
          {}{}{}
  \setfoot[\usepage][][]%
          {}{}{\usepage}
}
\if@headrules
\newlength{\headrulewidth}
\setlength{\headrulewidth}{0.05em}
\fi
\newpagestyle{ebs}[\small]{
  \if@headrules
  \headrule
  \setheadrule{\headrulewidth}
  \fi
  \sethead[\usepage][][\ifthechapter{\thechapter\quad}{}\textit{\chaptertitle}]%
          {\ifthesection{\thesection\quad}{}\textit{\sectiontitle}}{}{\usepage}
  \setfoot[][][]%
          {}{}{}
}
\pagestyle{ebs}
\RequirePackage{titletoc}[2002/03/27]
%% New part TOC entry
\titlecontents{part}[0pt]{%
  \addvspace{10pt}\filright}{%
  \textbf{\partname\space\thecontentslabel:\enspace}}{}{}
%% Appendix
\newcommand{\listofappendices}{%
  \section*{\listappendixname\sectionmark{\listappendixname}}
  \printcontents[appendix]{1}{1}{\setcounter{tocdepth}{3}}
}
\renewcommand{\appendix}{%
  \ClassWarningNoLine{ebsthesis}{%
    Use \noexpand\appendices to start the appendix}
  \appendices}
\newcommand{\appendices}{%
  \ttl@toclabelfalse
  \ttl@setifthe{chapter}
  \setcounter{chapter}{0}
  \setcounter{section}{0}
  \renewcommand{\chaptername}{\appendixname}
  \renewcommand{\thesection}{\Alph{section}}
  \chapter*{\appendicesname\chaptermark{\appendicesname}}
  \addcontentsline{toc}{chapter}{\appendicesname}
  \titleformat{\section}{%
    \normalfont\large\bfseries}{%
    \chaptertitlename~\thesection}{1em}{}
  \stopcontents[main]
  \startcontents[appendix]
}
%% New titlepage
\newcommand{\thegrad}{Doctor rerum politicarum}
\newcommand{\grad}[1]{%
  \renewcommand{\thegrad}{#1}}
\newcommand{\thetitel}{%
  \ClassWarningNoLine{ebsthesis}{%
    Kein \noexpand\titel angegeben}}
\newcommand{\titel}[1]{%
  \renewcommand{\thetitel}{#1}}
\newcommand{\theuntertitel}{}
\newcommand{\untertitel}[1]{%
  \renewcommand{\theuntertitel}{#1}}
\newcommand{\thefachbereich}{Betriebswirtschaftslehre}
\newcommand{\fachbereich}[1]{%
  \renewcommand{\thefachbereich}{#1}}
\newcommand{\thehochschule}{%
  European Business School}
\newcommand{\hochschule}[1]{%
  \renewcommand{\thehochschule}{#1}}
\newcommand{\thename}{%
  \ClassWarningNoLine{ebsthesis}{%
    Kein \noexpand\name angegeben}}
\newcommand{\name}[1]{%
  \renewcommand{\thename}{#1}}
\newcommand{\thegeburtsort}{%
  \ClassWarningNoLine{ebsthesis}{%
    Kein \noexpand\geburtsort angegeben}}
\newcommand{\geburtsort}[1]{%
  \renewcommand{\thegeburtsort}{#1}}
\newcommand{\thereferenten}{%
  \ClassWarningNoLine{ebsthesis}{%
    Keine \noexpand\referenten angegeben}}
\newcommand{\referenten}[1]{%
  \renewcommand{\thereferenten}{#1}}
\newcommand{\theeinreichungstermin}{%
  \ClassWarningNoLine{ebsthesis}{%
    Kein \noexpand\einreichungstermin angegeben}}
\newcommand{\einreichungstermin}[1]{%
  \renewcommand{\theeinreichungstermin}{#1}}
\newcommand{\thepruefungstermin}{%
  \ClassWarningNoLine{ebsthesis}{%
    Kein \noexpand\pruefungstermin angegeben}}
\newcommand{\pruefungstermin}[1]{%
  \renewcommand{\thepruefungstermin}{#1}}
\newcommand{\theerscheinungsort}{Wiesbaden}
\newcommand{\erscheinungsort}[1]{%
  \renewcommand{\theerscheinungsort}{#1}}
\newcommand{\theerscheinungsjahr}{%
  \ClassWarningNoLine{ebsthesis}{%
    Kein \noexpand\erscheinungsjahr angegeben}}
\newcommand{\erscheinungsjahr}[1]{%
  \renewcommand{\theerscheinungsjahr}{#1}}
\newcommand{\thehochschulkennziffer}{154}
\newcommand{\hochschulkennziffer}[1]{%
  \renewcommand{\thehochschulkennziffer}{#1}}
\RequirePackage{array}[1998/05/13]
\renewcommand{\maketitle}{%
  \renewcommand{\and}{\tabularnewline &}
  \begin{titlepage}
    \begin{singlespacing}
      \begin{center}
        {\Large\bfseries Dissertation}\\
        zur Erlangung des akademischen Grades\\
        \thegrad\par
        \vspace{\stretch{1}}
        {\huge\bfseries\thetitel\par\mdseries\theuntertitel\par}
        \vspace{\stretch{1.618033988}}
        \begin{tabular}{@{}>{\bfseries}ll@{}}
          Fachbereich:&\thefachbereich\tabularnewline
          Hochschule:&\thehochschule\tabularnewline
          Name:&\thename\tabularnewline
          Geburtsort:&\thegeburtsort\tabularnewline
          Referenten:&\thereferenten\tabularnewline
          Einreichungstermin:&\theeinreichungstermin\tabularnewline
          Pr^^fcfungstermin:&\thepruefungstermin\tabularnewline
          Erscheinungsort:&\theerscheinungsort\tabularnewline
          Erscheinungsjahr:&\theerscheinungsjahr\tabularnewline
          Hochschulkennziffer:&\thehochschulkennziffer\tabularnewline
        \end{tabular}
      \end{center}
    \end{singlespacing}
  \end{titlepage}
  \startcontents[main]
}
%% Summary and table of contents
\newcommand{\inhaltsuebersicht}{%
  \chapter*{\inhaltsubersichtname\chaptermark{\inhaltsubersichtname}}
  \printcontents[main]{0}{-1}{\setcounter{tocdepth}{1}}
}
\renewcommand{\tableofcontents}{%
  \chapter*{\contentsname\chaptermark{\contentsname}}
  \printcontents[main]{0}{-1}{\setcounter{tocdepth}{3}}
}
%% Page composition
\setcounter{topnumber}{3}
\setcounter{bottomnumber}{2}
\setcounter{totalnumber}{4}
\renewcommand{\topfraction}{0.85}
\renewcommand{\bottomfraction}{0.5}
\renewcommand{\textfraction}{0.15}
\renewcommand{\floatpagefraction}{0.7}
\interfootnotelinepenalty=10000
\clubpenalty=10000
\widowpenalty=10000
\displaywidowpenalty=10000
\renewcommand{\frontmatter}{%
  \cleardoublepage
  \@mainmatterfalse
  \pagenumbering{Roman}
}
\RequirePackage[nottoc]{tocbibind}[2003/02/04]
%% Preface and Foreword
\newcommand{\geleitwort}{%
  \chapter*{\geleitwortname\chaptermark{\geleitwortname}}
}
\newcommand{\vorwort}{%
  \chapter*{\vorwortname\chaptermark{\vorwortname}}
}
%% List of Symbols
\RequirePackage{nomencl}[2000/12/03]
\RequirePackage{mdwlist}[1996/05/02]
\newcommand{\symbolverzeichnis}{\printglossary}
\renewcommand{\nomname}{\symbolverzeichnisname}
\newlength{\glossindent}
\setlength{\glossindent}{3em}
\def\theglossary{%
  \chapter*{\nomname\chaptermark{\nomname}}
  \addcontentsline{toc}{chapter}{\nomname}
  \nompreamble
  \addvspace{10pt}
  \begin{basedescript}{%
      \desclabelwidth{\glossindent}
      \desclabelstyle{\nextlinelabel}
      \renewcommand{\makelabel}[1]{##1}
      \parskip\z@\itemsep\z@
    }
}
\def\endtheglossary{%
  \end{basedescript}
  \nompostamble
}
\makeglossary
%% List of Abbreviations
\newcommand{\abkuerzungsverzeichnis}{%
  \chapter*{\abkuerzungsverzeichnisname\chaptermark{%
      \abkuerzungsverzeichnisname}}
  \addcontentsline{toc}{chapter}{\abkuerzungsverzeichnisname}
  \addvspace{10pt}%
}
\RequirePackage{acronym}[2000/05/21]
\newlength{\acroindent}
\setlength{\acroindent}{6em}
\renewenvironment{acronym}{%
  \begin{basedescript}{%
      \desclabelwidth{\acroindent}
      \desclabelstyle{\nextlinelabel}
      \renewcommand{\makelabel}[1]{##1}
      \parskip\z@\itemsep\z@
    }
    \providecommand*{\acro}[1]{\AC@dblargafter{##1}\AC@acro}%
  }{%
  \end{basedescript}%
}
%% Advanced mathematics functions and equation alignment
\RequirePackage[leqno,centertags]{amsmath}[2000/07/18]
\if@tools
\RequirePackage{ebstools}[2003/11/11]
\fi
\endinput
%%
%% End of file `ebsthesis.cls'.
