% European curriculum vitae class
% Author: Nicola Vitacolonna (vitacolo@dimi.uniud.it)
% This material is subject to the LaTeX Project Public License.
% See  http://www.ctan.org/tex-archive/help/Catalogue/licenses.lppl.html
% for the details of that license
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{europecv}[2005/04/08 European curriculum vitae class]

% CV models and instructions:
%   http://europass.cedefop.eu.int/htm/index.htm
% Recommendations:
%   http://europa.eu.int/scadplus/leg/en/cha/c11057.htm

% Set language
\DeclareOption{english}{%
  \InputIfFileExists{ecven.def}{}{%
  \ClassError{europecv}{English definition file 'ecven.def' not found}%
   {The file should be inside the europecv folder.\MessageBreak
    Try to re-install the europecv class.}}%
}
\DeclareOption{italian}{%
  \InputIfFileExists{ecvit.def}{}{%
  \ClassWarningNoLine{europecv}{Italian definition file 'ecvit.def' not found}}%
}
\DeclareOption{spanish}{%
  \InputIfFileExists{ecves.def}{}{%
  \ClassWarningNoLine{europecv}{Spanish definition file 'ecves.def' not found}}%
}
\DeclareOption{french}{%
  \InputIfFileExists{ecvfr.def}{}{%
  \ClassWarningNoLine{europecv}{French definition file 'ecvfr.def' not found}}%
}
\DeclareOption{danish}{%
  \InputIfFileExists{ecvda.def}{}{%
  \ClassWarningNoLine{europecv}{Danish definition file 'ecvda.def' not found}}%
}
\DeclareOption{german}{%
  \InputIfFileExists{ecvde.def}{}{%
  \ClassWarningNoLine{europecv}{German definition file 'ecvde.def' not found}}%
}
\DeclareOption{finnish}{%
  \InputIfFileExists{ecvfi.def}{}{%
  \ClassWarningNoLine{europecv}{Finnish definition file 'ecvfi.def' not found}}%
}
\DeclareOption{portuges}{%
  \InputIfFileExists{ecvpt.def}{}{%
  \ClassWarningNoLine{europecv}{Portuguese definition file 'ecvpt.def' not found}}%
}
\DeclareOption{portuguese}{%
  \InputIfFileExists{ecvpt.def}{}{%
  \ClassWarningNoLine{europecv}{Portuguese definition file 'ecvpt.def' not found}}%
}
\DeclareOption{swedish}{%
  \InputIfFileExists{ecvsv.def}{}{%
  \ClassWarningNoLine{europecv}{Swedish definition file 'ecvsv.def' not found}}%
}
\DeclareOption{norwegian}{%
  \InputIfFileExists{ecvno.def}{}{%
  \ClassWarningNoLine{europecv}{Norwegian definition file 'ecvno.def' not found}}%
}
\DeclareOption{dutch}{%
  \InputIfFileExists{ecvnl.def}{}{%
  \ClassWarningNoLine{europecv}{Dutch definition file 'ecvnl.def' not found}}%
}
\DeclareOption{catalan}{%
  \InputIfFileExists{ecvca.def}{}{%
  \ClassWarningNoLine{europecv}{Catalan definition file 'ecvca.def' not found}}%
}
\DeclareOption{polish}{%
  \InputIfFileExists{ecvpl.def}{}{%
  \ClassWarningNoLine{europecv}{Polish definition file 'ecvpl.def' not found}}%
}

% Set font
\DeclareOption{helvetica}{%                       
  \renewcommand{\rmdefault}{phv}
  \renewcommand{\sfdefault}{phv}
}
\DeclareOption{arial}{%                       
  \renewcommand{\rmdefault}{ma1} % (this font is NOT installed by default!)
  \renewcommand{\sfdefault}{ma1}
}
\DeclareOption{narrow}{
  \renewcommand{\seriesdefault}{mc} % Narrow
  \renewcommand{\bfdefault}{bc}  % Boldface narrow
}
% No title
\DeclareOption{notitle}{\renewcommand*\ecvtitle{}}

% Europass logo
\DeclareOption{logo}{%
\providecommand*\draweuropasslogo{%
   \includegraphics[width=\ecv@logowidth]{europasslogo}}
}
\DeclareOption{nologo}{\renewcommand*\draweuropasslogo{}}

% Flag pictures of the EC can be found at 
%   http://europa.eu.int/abc/symbols/emblem/index_en.htm
\DeclareOption{noflag}{\providecommand*\draweuropeflag{}}
\DeclareOption{flagWB}{%
  \renewcommand*\draweuropeflag{%
    \includegraphics[width=\ecv@flagwidth]{EuropeFlagWB}}
}
\DeclareOption{flagBW}{%
  \renewcommand*\draweuropeflag{%
    \includegraphics[width=\ecv@flagwidth]{EuropeFlagBW}}
}
\DeclareOption{flagCMYK}{%
  \renewcommand*\draweuropeflag{%
    \includegraphics[width=\ecv@flagwidth]{EuropeFlagCMYK}}
}
\DeclareOption{flagBlueCMYK}{%
 \renewcommand*\draweuropeflag{%
   \includegraphics[width=\ecv@flagwidth]{EuropeFlagBlueCMYK}}
}

% Pass all other options (a4paper, 10pt, draft, openbib, etc...) to article
\DeclareOption*{%
  \PassOptionsToClass{\CurrentOption}{article}%
} 

\ExecuteOptions{english,noflag,logo,hrule} % Default options

\ProcessOptions\relax

\LoadClass{article}
\RequirePackage{array}
\RequirePackage{longtable}
\RequirePackage{fancyhdr} % For page numbering

\newcommand*{\ecvfirstname}[1]{\def\ecv@firstname{#1}}
\newcommand*{\ecvlastname}[1]{\def\ecv@lastname{#1}}
\newcommand*{\ecvaddress}[1]{\def\ecv@address{#1}}
\newcommand*{\ecvtelephone}[1]{\def\ecv@telephone{#1}}
\newcommand*{\ecvfax}[1]{\def\ecv@fax{#1}}
\newcommand*{\ecvemail}[1]{\def\ecv@email{#1}}
\newcommand*{\ecvnationality}[1]{\def\ecv@nationality{#1}}
\newcommand*{\ecvdateofbirth}[1]{\def\ecv@birth{#1}}
\newcommand*{\ecvgender}[1]{\def\ecv@gender{#1}}
% Personal picture
\newcommand*{\ecvdrawpicture}{}
\newcommand*{\ecvbeforepicture}[1]{\def\ecv@beforepic{#1}}
\newcommand*{\ecvafterpicture}[1]{\def\ecv@afterpic{#1}}
\newcommand*\ecvpicture{%
\@ifnextchar[\ecv@picture{\ecv@picture[]}}
\def\ecv@picture[#1]#2{%
\def\ecvarg{#2}
\ifx\@empty\ecvarg\renewcommand*{\ecvdrawpicture}{}\else
\renewcommand*{\ecvdrawpicture}{\includegraphics[#1]{#2}}
\fi}
\ecvbeforepicture{\raggedright}
\ecvafterpicture{}
\ecvfirstname{}
\ecvlastname{}
\ecvaddress{}
\ecvtelephone{}
\ecvfax{}
\ecvemail{}
\ecvnationality{}
\ecvdateofbirth{}
\ecvgender{}
\ecvpicture{}

\providecommand{\ecvpersonalinfo}[1][0pt]{%
{\large\par\textbf{\ecv@infosectionkey}} & \tabularnewline & \tabularnewline
\ecv@namekey        & \large\textbf{\ecv@lastname\ \ecv@firstname}\tabularnewline[5pt]
\ifx\@empty\ecv@address\else
\ecv@addresskey     & \large\ecv@address   \tabularnewline[5pt]
\fi
\ifx\@empty\ecv@telephone\else
\ecv@telkey         & \large\ecv@telephone \tabularnewline[5pt]
\fi
\ifx\@empty\ecv@fax\else
\ecv@faxkey         & \large\ecv@fax \tabularnewline[5pt]
\fi
\ifx\@empty\ecv@email\else
\ecv@emailkey       & \large\ecv@email \tabularnewline[5pt]
\fi
\ifx\@empty\ecv@nationality\else
\ecv@nationalitykey & \ecv@nationality \tabularnewline[5pt]
\fi
\ifx\@empty\ecv@birth\else
\ecv@birthkey       & \ecv@birth \tabularnewline[5pt]
\fi
\ifx\@empty\ecv@gender\else
\ecv@genderkey      & \ecv@gender \tabularnewline[#1]
\fi
}

% Spoken language information
\newcommand*\ecvmothertongue[2][0pt]{%
{\large\ecv@mothertonguekey} & \large\textbf{#2}\tabularnewline[#1]
}
\newlength\ecv@langparwidth
\newcommand*\ecvlanguageheader[1]{%
{\large\textit{\ecv@assesskey}}\\ \textit{\ecv@levelkey}${}^{\mbox{\scriptsize#1}}$&
\setlength\extrarowheight{0pt}
\begin{tabular}[t]{|m{\ecv@langparwidth}|m{\ecv@langparwidth}|m{\ecv@langparwidth}|m{\ecv@langparwidth}|m{\ecv@langparwidth}|}
\firsthline
\multicolumn{2}{|c|}{\textbf{\ecv@understandkey}}&\multicolumn{2}{c|}{\textbf{\ecv@speakkey}}&\centering\textbf{\ecv@writekey}\tabularnewline\cline{1-4}
\centering\small{\ecv@listenkey}   & \centering \small{\ecv@readkey} &\centering \small{\ecv@interactkey} &\centering \small{\ecv@productkey} & \tabularnewline
\lasthline
\end{tabular}\vspace{2\arrayrulewidth}\tabularnewline
}

\newcommand*\ecvlanguagefooter[2][0pt]{\ecvitem[#1]{}{\quad\footnotesize{${}^{\mbox{\tiny#2}}$\textit{\ecv@langfooterkey}}}}

\newcommand*\ecvlanguage[7][0pt]{
{\textbf{#2}} &
\setlength\extrarowheight{0pt}
\begin{tabular}{|m{\ecv@langparwidth}|m{\ecv@langparwidth}|m{\ecv@langparwidth}|m{\ecv@langparwidth}|m{\ecv@langparwidth}|}
\hline
 #3 & #4 & #5 & #6 & #7 \tabularnewline
\hline
\end{tabular}\vspace{#1}
\tabularnewline[-\arrayrulewidth]
}

% See the Common European Framework of Reference for Languages:
% http://www.coe.int/T/E/Cultural_Co-operation/education/Languages/Language_Policy/Common_Framework_of_Reference/default.asp
\newcommand*\ecvCEF[2]{%
%\setlength\tabcolsep{1mm}
\begin{tabular}{@{}>{\footnotesize}p{.2\ecv@langparwidth}@{\hspace{1mm}}>{\footnotesize\centering}p{.74\ecv@langparwidth}@{}}
#1 & #2\tabularnewline
\end{tabular}
}

\newcommand*\ecvAOne{\ecvCEF{A1}{\ecv@cefbasickey}}
\newcommand*\ecvATwo{\ecvCEF{A2}{\ecv@cefbasickey}}
\newcommand*\ecvBOne{\ecvCEF{B1}{\ecv@cefindepkey}}
\newcommand*\ecvBTwo{\ecvCEF{B2}{\ecv@cefindepkey}}
\newcommand*\ecvCOne{\ecvCEF{C1}{\ecv@cefprofkey}}
\newcommand*\ecvCTwo{\ecvCEF{C2}{\ecv@cefprofkey}}

\def\ecv@kern{\kern0.5pt}
%\def\ecv@kern{}
\newcommand*{\ecvTitleKern}[1]{\def\ecv@kern{\kern#1}}
\newlength\ecv@rulewidth
\newlength\ecv@colsep
\newlength\ecv@leftcolwidth
\newlength\ecv@rightcolwidth
\newlength\ecv@extrarowheight
\newcommand*{\ecvRuleWidth}[1]{\setlength\ecv@rulewidth{#1}}
\newcommand*{\ecvColSep}[1]{%
  \addtolength{\ecv@leftcolwidth}{\ecv@colsep}
  \addtolength{\ecv@rightcolwidth}{\ecv@colsep}
  \setlength\ecv@colsep{#1}
  \addtolength{\ecv@leftcolwidth}{-\ecv@colsep}
  \addtolength{\ecv@rightcolwidth}{-\ecv@colsep}}
\newcommand*{\ecvLeftColumnWidth}[1]{\setlength\ecv@leftcolwidth{#1}%
             \setlength{\ecv@rightcolwidth}{\textwidth}
            \addtolength{\ecv@rightcolwidth}{-\ecv@leftcolwidth}
            \addtolength{\ecv@rightcolwidth}{-2\ecv@colsep}
            \addtolength{\ecv@rightcolwidth}{-\ecv@rulewidth}}
\newcommand*{\ecvExtraRowHeight}[1]{\setlength\ecv@extrarowheight{#1}}
\newcommand*{\ecvNoHorRule}{\def\ecv@hrule{}}
\newcommand*{\ecvWithHorRule}{\def\ecv@hrule{\cline{1-1}}}
% Initialization
\ecvRuleWidth{\arrayrulewidth}
\setlength\ecv@colsep{12pt}
\setlength\ecv@leftcolwidth{50mm}
\ecvExtraRowHeight{0pt}
\ecvWithHorRule

% Flag size
\newlength\ecv@flagwidth
\newcommand*{\ecvFlagWidth}[1]{\setlength\ecv@flagwidth{#1}}
\ecvFlagWidth{10mm}

% Logo size
\newlength\ecv@logowidth
\newlength\ecv@logooffset
\newcommand*{\ecvLogoWidth}[1]{\setlength\ecv@logowidth{#1}}
\newcommand*{\ecvLogoOffset}[1]{\setlength\ecv@logooffset{#1}}
\ecvLogoWidth{2.30cm}
\ecvLogoOffset{1cm}
%\typeout{logo width=\the\ecv@logowidth}
%\typeout{logo offset=\the\ecv@logooffset}

% Footnote or footer to be shown on every page
\newcommand\ecvfootnote[1]{%
  \rfoot{\begin{minipage}{60mm}
     \footnotesize #1%
  \end{minipage}}}

% Set layout
\pagestyle{fancy}
\lhead{}
\chead{}
\rhead{}
\lfoot{\ecvlfoot}
\cfoot{}
\rfoot{}
\renewcommand{\headrulewidth}{0pt}

% Text bullet
\newcommand{\ecvbullet}{\raisebox{.35ex}[0cm][0cm]{\tiny\textbullet}}

                                          
\newenvironment{europecv}{%
  \ecvLeftColumnWidth{\ecv@leftcolwidth}
  \setlength\arrayrulewidth{\ecv@rulewidth}
  \setlength\extrarowheight{\ecv@extrarowheight}
  \setlength\LTleft{0pt}
  \setlength\LTright{0pt}
  % Language table paragraph width
  \setlength\ecv@langparwidth{.199\ecv@rightcolwidth}
  \addtolength{\ecv@langparwidth}{-2\tabcolsep}
  \addtolength{\ecv@langparwidth}{-2\arrayrulewidth}
% Begin
\begin{longtable}[l]{@{}>{\raggedleft}p{\ecv@leftcolwidth}@{\hspace{\ecv@colsep}}|@{\extracolsep{\ecv@colsep}}p{\ecv@rightcolwidth}@{}}
  \ecv@hrule
  \ifx\@empty\draweuropasslogo\else
    % Any better way of achieving the same result?!?
    \vskip-\ecv@logooffset\draweuropasslogo\hfill\phantom{.}& \tabularnewline
  \fi
  \ifx\@empty\ecvtitle\else
    \ecvtitle &\tabularnewline
  \fi
  \ifx\@empty\ecvdrawpicture\else
     &\ecv@beforepic\ecvdrawpicture\ecv@afterpic\tabularnewline
  \fi
    \ifx\@empty\draweuropeflag\else
     \draweuropeflag& \tabularnewline
  \fi
}
{\end{longtable}}

\newcommand{\ecvsection}[2][10pt]{%
  {\large{\par\textbf{#2}}}\vspace{#1} & \tabularnewline\nopagebreak
}
          
\newif\if@ecvitemstar
\newcommand\ecvitem{\@ifstar{\@ecvitemstartrue \@ecvitem}%
  {\@ecvitemstarfalse\@ecvitem}}
\newcommand\@ecvitem[3][2pt]{%
  \if@ecvitemstar \ecvbullet\ \fi #2\vspace{#1} & #3
    \vspace{#1}\tabularnewline}
  
