\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{ncc}
         [2005/07/02 v1.08 NCC-LaTeX document class (NCC)]
%
% \changes{v1.01}{2002/03/24}{This version is uploaded to CTAN}
% \changes{v1.02}{2002/04/03}{Bug in loading book class fixed}
% \changes{v1.03}{2004/04/08}{The processing of 'russian' option is improved}
% \changes{v1.04}{2004/09/23}{Provide index making commands via the makeidx}
% \changes{v1.05}{2004/11/30}{Remove \NCC@null from the titlepage env.}
% \changes{v1.05}{2004/11/30}{Rename \NCC@null to \StartFromTextArea}
% \changes{v1.05}{2004/11/30}{Add the \StartFromHeaderArea command}
% \changes{v1.06}{2004/12/16}{Remove \NCC@gempty command}
% \changes{v1.07}{2005/01/12}{Remove options passed to packages}
% \changes{v1.07}{2005/02/21}{Set tbtags as default option}
% \changes{v1.07}{2005/03/23}{Add optional arg. to \alloweqbreak}
% \changes{v1.07}{2005/03/30}{Fix bug in the \preprint command}
% \changes{v1.07}{2005/05/20}{Move \StartFromTextArea to the nccsect package}
% \changes{v1.07}{2005/05/20}{Move \StartFromHeaderArea to the nccsect package}
% \changes{v1.08}{2005/06/18}{Add titlepage*, \ExpandTextArea, \RestoreTextArea}
% \changes{v1.08}{2005/07/02}{Improve \ExpandTextArea command}
% 
\newcommand*\partmark[1]{}
\newcommand\@ptsize{}
\newif\if@restonecol
\newdimen\bibindent
\setlength\bibindent{1.5em}
\let\@openbib@code\@empty
%
% \openrightorany clears page or double page depending on openright
% mode selected.
%
\newif\if@openright
\newcommand{\openrightorany}{\clearpage\relax
  \if@openright \if@twoside
    \begingroup\let\leftmark\relax \cleardoublepage\endgroup
  \fi\fi
}
%
% What goes first in title: author or title
%
\newif\ifNCC@authorbeforetitle
\newcommand{\AuthorBeforeTitle}{\NCC@authorbeforetitletrue}
\newcommand{\TitleBeforeAuthor}{\NCC@authorbeforetitlefalse}
\@onlypreamble\AuthorBeforeTitle
\@onlypreamble\TitleBeforeAuthor
%
% \SetTOCStyle{STYLE} sets a TOC style
%
\newcommand*{\SetTOCStyle}[1]{\def\NCC@tocstyle{#1}}
\SetTOCStyle{}
\@onlypreamble\SetTOCStyle
%
% Paper size options
%
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{a5a4paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\DeclareOption{fittopage}{}
%
% Base font size options
%
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\DeclareOption{14pt}{\renewcommand\@ptsize{4}%
                     \PassOptionsToPackage{small}{ncclatex}}
%
% Layout options
%
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{twoside}{\@twosidetrue \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{openany}{\@openrightfalse}
\DeclareOption{openright}{\@openrighttrue}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{twocolumn}{\@twocolumntrue}
%
% Special openbib option
%
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
    \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
%
% Display math options are defined in nccmath. We need not define them here,
% because they ar passed to nccmath as global options.
%
%\DeclareOption{fleqn}{\PassOptionsToPackage{\CurrentOption}{nccmath}}
%\DeclareOption{leqno}{\PassOptionsToPackage{\CurrentOption}{nccmath}}
%
% Small headings in sections option is also not necessary here.
%
%\DeclareOption{small}{\PassOptionsToPackage{\CurrentOption}{ncclatex}}
%
\newcommand*{\setyear}[1]{\gdef\theyear{#1}}
\newcommand\theyear{\number\year}
%
% Subclass selection options
%
\DeclareOption{article}{%
  \def\NCC@clsload{%
    \TitleBeforeAuthor
    \input{nccart.clo}%
    \newcommand*{\setseries}[1]{\gdef\theseries{##1}}%
    \newcommand*{\setvolume}[1]{\gdef\thevolume{##1}}%
    \newcommand*{\setissue}[1]{\gdef\theissue{##1}}%
    \setseries{}\setvolume{}\setissue{}%
    \AtEndDocument{%
      \clearpage
      \if@filesw \advance\c@page\m@ne
        \immediate\write\@mainaux{\string\newlabel
          {NCC@lastpage}{{}{\thepage}}}%
        \advance\c@page\@ne
      \fi
      \openrightorany
    }%
    \pagestyle{myheadings}%
    \countstyle{}%
    \InputIfFileExists{nccadd.sty}{}{}%
  }%
  \let\chapter\relax
  \let\thechapter\relax
}
\DeclareOption{preprint}{%
  \def\NCC@clsload{%
    \AuthorBeforeTitle
    \input{nccart.clo}%
    \let\maketitle\relax    % Remove these commands to allow creating
    \let\abstract\relax     % them with \newcommand.
    \let\endabstract\relax  %
    \input{ncctitle.clo}%
    \newcommand*{\preprint}[1]{%
      \def\thepreprint{##1}%
      \ifx\thepreprint\@empty
        \titlecomment{}%
      \else
        \titlecomment{\bfseries \preprintname\\[1.5ex]\thepreprint}%
      \fi
    }%
    \preprint{}%
    \pagestyle{headings}%
    \countstyle{}%
  }%
  \let\chapter\relax
  \let\thechapter\relax
}
\DeclareOption{book}{%
  \def\NCC@clsload{%
    \AuthorBeforeTitle
    \input{nccbook.clo}
    \input{ncctitle.clo}%
    \let\bookeditor\titlecomment
    \pagestyle{headings}%
    \countstyle{chapter}%
  }%
  \let\chapter\@empty    % nccsect and russianb packages test an existence of
  \let\thechapter\@empty % \thechapter and \chapter to understand what class
}                        % was loaded
\DeclareOption{report}{\ExecuteOptions{book,oneside}}
%
% The russian option is also removed because it is passed as global one.
%
%\DeclareOption{russian}{\PassOptionsToPackage{\CurrentOption}{ncclatex}}
%
% We set tbtags as the default tags positioning in split environment
%
\def\NCC@temp{\PassOptionsToPackage{tbtags}{nccmath}}
\DeclareOption{centertags}{\let\NCC@temp\relax}
%
% Process options and load size option file
%
\ExecuteOptions{a4paper,10pt,article,twoside,onecolumn,final,openany}
\ProcessOptions\relax
\NCC@temp \let\NCC@temp\relax
\input{ncc1\@ptsize.clo}
\@ifclasswith{ncc}{fittopage}{\input{nccfit.clo}}{}
%
% Center text on the page taking into account the header only,
% because default NCC-LaTeX style is headings or myheadings and
% marginal notes are useless. The top margin is bounded by 1.5in.
%
\RequirePackage{tocenter}
\ToCenter[h]{\textwidth}{\textheight}
\ifdim\topmargin >.5in \topmargin=.5in \fi
%
% Set list margins
%
\if@twocolumn
  \setlength\leftmargini  {2em}
  \setlength\leftmarginii {1.7em}
  \setlength\leftmarginiii{1.5em}
  \setlength\leftmarginiv {1.2em}
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmargini  {2.5em}
  \setlength\leftmarginii {2.2em}
  \setlength\leftmarginiii{1.87em}
  \setlength\leftmarginiv {1.7em}
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength\labelsep{.5em}
\leftmargin\leftmargini
\def\NCC@labelwidth{\labelwidth\leftmargin\advance\labelwidth-\labelsep}
\NCC@labelwidth
%
% Set enumeration styles
%
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
%
% Set other dimensions, skips, and penalties
%
\if@twocolumn \setlength\parindent{1em}
\else         \setlength\parindent{1.5em}
\fi
\setlength\smallskipamount{3\p@ \@plus \p@ \@minus \p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}
\setlength\maxdepth{.5\topskip}
\setlength\lineskip{\p@}
\setlength\normallineskip{\p@}
\renewcommand\baselinestretch{}
\setlength\columnseprule{0\p@}
\setlength\parskip{\z@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\setcounter{topnumber}{4}
\renewcommand\topfraction{.8}
\setcounter{bottomnumber}{2}
\renewcommand\bottomfraction{.6}
\setcounter{totalnumber}{6}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{4}
\renewcommand\dbltopfraction{.8}
\renewcommand\dblfloatpagefraction{.5}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\def\@dotsep{4.5}
%
% Declare old font selection commands
%
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
%
% Create section counters. We use \countstyle command from dcounter package.
%
\RequirePackage{dcounter}
\newcounter{part}
\renewcommand\thepart{\@Roman\c@part}
\@ifundefined{chapter}{
  \countstyle[section]{}
}{
  \countstyle[chapter]{}
  \countstyle[section]{chapter}
}
\countstyle[subsection]{section}
\countstyle[subsubsection]{subsection}
\countstyle[paragraph]{subsubsection}
\countstyle[subparagraph]{paragraph}
%
% Declare floats
%
\DeclareDynamicCounter{figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename\nobreakspace\thefigure}
\newenvironment{figure}{\@float{figure}}{\end@float}
\newenvironment{figure*}{\@dblfloat{figure}}{\end@dblfloat}
\DeclareDynamicCounter{table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename\nobreakspace\thetable}
\newenvironment{table}{\@float{table}}{\end@float}
\newenvironment{table*}{\@dblfloat{table}}{\end@dblfloat}
%
% Names of english captions
%
\newcommand\prefacename{Preface}
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\bibname{Bibliography}
\newcommand\indexname{Index}
\newcommand\glossaryname{Glossary}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\chaptername{Chapter}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
\newcommand\preprintname{Preprint}
%
% English version of \today
%
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
%
% Prepare commands for making indices
%
\RequirePackage{makeidx}
\newcommand\printglossary{\@input@{\jobname.gls}}
%
% Load remaining packages
%
\RequirePackage{watermark}
\RequirePackage{ncclatex}
\RequirePackage{nccold}
\ifNCC@rus \frenchspacing \fi % French spacing in russian typesetting
%
% noeqbreak supresses page breaks before display equations
% alloweqbreak[number] allows page breaks before display equations
% (default is alloweqbreak[4])
%
\newenvironment{noeqbreak}{\predisplaypenalty\@M
  \ignorespaces
}{\ignorespacesafterend}
\newenvironment*{alloweqbreak}[1][4]{%
  \predisplaypenalty 
  \ifcase #1\@highpenalty
    \or \@lowpenalty
    \or \z@
    \or \@beginparpenalty
    \else \@secpenalty
  \fi
  \ignorespaces
}{\ignorespacesafterend}
\alloweqbreak                 % Break before display formulas is allowed
\allowdisplaybreaks           % Breaks in display formulas are allowed
%
% Verse, quotation, quote. The description is already defined in ncclatex
%
\newenvironment{verse}{%
  \let\\\centercr
  \list{}{\itemsep \z@ \itemindent -1.5em \listparindent\itemindent
          \rightmargin \leftmargin \advance\leftmargin 1.5em}%
  \item\relax
}{\endlist}
\newenvironment{quotation}{%
  \list{}{\listparindent 1.5em \itemindent \listparindent
          \rightmargin \leftmargin \parsep \z@ \@plus \p@}%
  \item\relax
}{\endlist}
\newenvironment{quote}{%
  \list{}{\rightmargin\leftmargin}\item\relax
}{\endlist}
%
% The titlepage environment. Sets the empty page style at the top-level
% title page. We suppose that a title page can contain many pages and many
% title pages inside. The page counter is restored to its
% original value after leaving a top-level title page.
%
\newif\ifNCC@intitle \NCC@intitlefalse
\newenvironment{titlepage}{%
  \clearpage
  \if@twocolumn \@restonecoltrue \onecolumn \else \@restonecolfalse \fi
  \ifNCC@intitle 
    \let\NCC@restorepagecount\@empty
  \else 
    \pagestyle{empty}
    \edef\NCC@restorepagecount{%
      \noexpand\global\noexpand\c@page \@arabic\c@page\relax}%
    \setcounter{page}\z@ 
    \c@footnote\z@ \def\thefootnote{\@fnsymbol\c@footnote}%
    \NCC@intitletrue
  \fi
  \let\NCC@restoretextarea\@empty
}{%
  \clearpage 
  \NCC@restoretextarea 
  \if@restonecol\twocolumn \fi
  \NCC@restorepagecount
}
%
% The star-form of the titlepage environment works as an inner one,
% i.e. it does not change the page counter.
\newenvironment{titlepage*}{\NCC@intitletrue
  \clearpage\pagestyle{empty}\titlepage
}{\endtitlepage}
%
% A text area can be expanded on the header, footer, and margins if
% the \ExpandTextArea[hfm] command is used at the beginning of a page
% in one-column mode.
% The letters in optional argument mean the following: h (header),
% f (footer), and m (margins). If an optional argument is omitted, or equal to
% [*] the temporary expansion to the header is applied with the
% \StartFromHeaderArea command.
\newcommand*\RestoreTextArea{}
\newcommand*\ExpandTextArea[1][*]{%
  \if@twocolumn
    \ClassError{ncc}{The \string\ExpandTextArea\space command\MessageBreak
                     cannot work in two-column mode}{}%
  \else
   \def\@tempa{*}\edef\@tempb{#1}%
   \ifx\@tempa\@tempb
     \StartFromHeaderArea
   \else
    \ifx\RestoreTextArea\@empty 
     \let\NCC@h\@empty \global\let\NCC@restore@h\@empty
     \let\NCC@f\@empty \global\let\NCC@restore@f\@empty
     \let\NCC@m\@empty \global\let\NCC@restore@m\@empty
     \expandafter\@tfor\expandafter\@tempa\expandafter:\expandafter=#1\do{%
       \if h\@tempa
        \def\NCC@h{\NCC@adjusttoheader{}}%
        \gdef\NCC@restore@h{\NCC@adjusttoheader-}%
       \else
        \if f\@tempa
         \def\NCC@f{\NCC@adjusttofooter{}}%
         \gdef\NCC@restore@f{\NCC@adjusttofooter-}%
        \else
         \if m\@tempa
          \if@reversemargin \@tempcnta\@ne \else \@tempcnta\tw@ \fi
          \edef\NCC@m{\noexpand\NCC@adjusttomargin{}{\the\@tempcnta}}%
          \xdef\NCC@restore@m{\noexpand\NCC@adjusttomargin-{\the\@tempcnta}}%
         \fi
        \fi
       \fi
     }%
     \NCC@h\NCC@f\NCC@m
     \StartFromTextArea
     \gdef\RestoreTextArea{%
       \NCC@restore@h\NCC@restore@f\NCC@restore@m
       \global\let\RestoreTextArea\@empty
     }%
     \def\NCC@restoretextarea{\RestoreTextArea}%
    \fi
   \fi
  \fi
}
\def\NCC@adjusttoheader#1{%
  \@tempdima #1\headheight
  \advance\@tempdima #1\headsep
  \global\advance\textheight\@tempdima
  \global\advance\topmargin-\@tempdima
  \global\@colht\textheight 
  \global\@colroom\textheight
  \global\vsize\textheight
}
\def\NCC@adjusttofooter#1{%
  \global\advance\textheight#1\footskip
  \global\@colht\textheight 
  \global\@colroom\textheight
  \global\vsize\textheight
}
\def\NCC@adjusttomargin#1#2{%
  \@tempdima #1\marginparwidth
  \advance\@tempdima #1\marginparsep
  \@tempcnta#2%
  \ifodd\@tempcnta
    \global\advance\oddsidemargin -\@tempdima
  \else
    \global\advance\evensidemargin -\@tempdima
  \fi
  \global\advance\textwidth\@tempdima
  \global\columnwidth\textwidth 
  \global\linewidth\textwidth 
  \global\hsize\textwidth
}
%
% Bibliography without header. It is possible to set starting number
% for bibliography counter.
%
% \begin{biblist}[start number]{prototype} ... \end{biblist}
%
\newcommand{\bibliststyle}{\small}
\newenvironment*{biblist}[2][0]{
  \bibliststyle
  \list{\@biblabel{\@arabic\c@enumiv}}{%
    \settowidth\labelwidth{\@biblabel{#2}}%
    \leftmargin\labelwidth \advance\leftmargin\labelsep \itemsep\parsep
    \@openbib@code
    \usecounter{enumiv}\let\p@enumiv\@empty
    \renewcommand\theenumiv{\@arabic\c@enumiv}%
  }%
  \setcounter{enumiv}{#1}%
   \sloppy \widowpenalty 4000
   \clubpenalty 4000 \@clubpenalty \clubpenalty
   \sfcode`\.\@m
}{\def\@noitemerr{\@latex@warning{Empty `biblist' environment}}%
  \endlist
}
\newcommand{\newblock}{\hskip .11em\@plus .33em\@minus .07em}
%
% Footnote make commands.
%
\renewcommand{\footnoterule}{%
  \kern-3\p@ \hrule\@width .4\columnwidth \kern2.6\p@
}
\newcommand{\@makefntext}[1]{%
  \parindent 1em \noindent
  \hb@xt@ 1.8em{\hss\@makefnmark}#1}
%
% \tableofcontents, \listoffigures, \listoftables
%
% They use the \NCC@tochead{header} command defined later in subclasses
%
\newcommand{\tableofcontents}{\NCC@toc\contentsname{toc}}
\newcommand{\listoffigures}{\NCC@toc\listfigurename{lof}}
\newcommand{\listoftables}{\NCC@toc\listtablename{lot}}
\def\NCC@toc#1#2{%
  \NCC@tochead{#1}%
  \begingroup
    \normalfont \NCC@tocstyle\NCC@setpnum
    \@starttoc{#2}%
  \endgroup
}
%
% theindex and theglossary. They are based on \NCC@idxhead{header}
% defined later in subclasses
%
\newenvironment{theindex}{\NCC@index\indexname}{\endNCC@index}
\newenvironment{theglossary}{\NCC@index\glossaryname}{\endNCC@index}
\newenvironment*{NCC@index}[1]{%
  \if@twocolumn \@restonecolfalse \else \@restonecoltrue \fi
  \columnseprule \z@ \columnsep 35\p@
  \NCC@idxhead{#1}%
  \parindent\z@ \parskip\z@ \@plus .3\p@
  \let\item\@idxitem \small
}{\if@restonecol\onecolumn \else \clearpage\fi}
\newcommand\@idxitem{\par\hangindent 5em}
\newcommand\subitem{\@idxitem \hspace*{2em}}
\newcommand\subsubitem{\@idxitem \hspace*{4em}}
\newcommand\indexspace{\par \addvspace{4ex \@plus 1ex \@minus .5ex}}
%
% NCC page style with headings
%
\def\NCC@setpsheading{%
  \let\@oddfoot\@empty\let\@evenfoot\@empty
  \def\@evenhead{%
    \thepage\hfil
    {\small\itshape\ignorespaces\leftmark\unskip}\hfil
  }%
  \def\@oddhead{%
    \hfil{\small\itshape\ignorespaces\rightmark\unskip}\hfil
    \thepage
  }%
  \reset@font
}
\def\NCC@firstmark#1{\markboth{#1}{#1}}
\def\NCC@secondmark#1{\markright{#1}}
%
% Final actions
%
\pagenumbering{arabic}
\NCC@clsload % load specified subclass
\@onlypreamble\NCC@clsload
\if@twocolumn
  \twocolumn \sloppy \flushbottom
\else
  \onecolumn
  \if@twoside \flushbottom \else \raggedbottom \fi
\fi
\endinput
