/***************************************************************************
                           th-fake-dialog.h
                           ----------------
    begin                : Wed Feb 16 2005
    copyright            : (C) 2005 by Tim-Philipp Müller
    email                : tim centricular net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _th_fake_dialog_included_h_
#define _th_fake_dialog_included_h_

#include <gtk/gtkvbox.h>

#define TH_RESPONSE_DESTROYED 44195

#define TH_TYPE_FAKE_DIALOG             (th_fake_dialog_get_type())
#define TH_FAKE_DIALOG(obj)             (G_TYPE_CHECK_INSTANCE_CAST (obj,  TH_TYPE_FAKE_DIALOG, ThFakeDialog))
#define TH_FAKE_DIALOG_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST (klass,   TH_TYPE_FAKE_DIALOG, ThFakeDialogClass))
#define TH_IS_FAKE_DIALOG(obj)          (G_TYPE_CHECK_INSTANCE_TYPE (obj,  TH_TYPE_FAKE_DIALOG))
#define TH_IS_FAKE_DIALOG_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), TH_TYPE_FAKE_DIALOG))

typedef struct _ThFakeDialog        ThFakeDialog;
typedef struct _ThFakeDialogClass   ThFakeDialogClass;
typedef struct _ThFakeDialogPrivate ThFakeDialogPrivate;

struct _ThFakeDialog
{
	GtkVBox  vbox_parent_obj;
	
	GtkWidget  *action_area;
	GtkWidget  *separator;
	GtkWidget  *vbox;

	ThFakeDialogPrivate  *priv;
};

struct _ThFakeDialogClass
{
	GtkVBoxClass  vbox_class;

	void (* response) (ThFakeDialog *dialog, gint response_id);
};

/* functions */

GType            th_fake_dialog_get_type (void) G_GNUC_CONST;

void             th_fake_dialog_response             (ThFakeDialog *fd, 
                                                      gint          response_id);

void             th_fake_dialog_add_action_widget    (ThFakeDialog *fdialog,
                                                      GtkWidget    *child,
                                                      gint          response_id);

GtkWidget       *th_fake_dialog_add_button           (ThFakeDialog  *fdialog,
                                                      const gchar   *button_text,
                                                      gint           response_id);

void             th_fake_dialog_set_default_response (ThFakeDialog *dialog,
                                                      gint          response_id);

gint             th_fake_dialog_run                  (ThFakeDialog  *fdialog);

#endif /* _th_fake_dialog_included_h_ */

