/* -*- mode: c; c-file-style: "gnu" -*-
 * fabs.h -- file abstraction layer, prototypes
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file fabs.h
 * File abstraction layer, prototypes.
 */

#ifndef _THY_FABS_H
#define _THY_FABS_H 1 /**< fabs.h multi-inclusion guard. */

#include <sys/stat.h>

int fabs_open (const char *file, int flags);
int fabs_close (int fd);
void fabs_init (void);
void fabs_mmap (int fd);
void fabs_munmap (int fd);

char *fabs_realpath (const char *file);
char *fabs_urlmap (const char *url, const char *host, const char *absuri);
int fabs_stat (const char *file, struct stat *st);
int fabs_access (const char *file, int mode);

#endif /* !_THY_FABS_H */
