/*  tilp - a linking program for TI graphing calculators
 *  Copyright (C) 1999-2002  Romain Lievin
 *
 *  This program is free software you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TILP_CORE__
#define __TILP_CORE__

/*
  This header contains the exported functions of the TiLP core.
  They can be used for developing a TiLP with a different GUI.
  You must use these functions with the name beginnig by tilp_...
  You do not have to use any other function, please !
*/

//// Gui_fncts: change create_pbar_xx by create_pbar(number)

#ifdef __cplusplus
extern "C" {
#endif

#include "../src/tilibs.h"
#include "../src/struct.h"
#include "../src/version.h"
#include "../src/paths.h"
#include "../src/error.h"
#include "../src/defs.h"
#include "../src/gui_indep.h"
#include "../src/sub_main.h"
#include "../src/cb_calc.h"
#include "../src/cb_misc.h"
#include "../src/rcfile.h"
#include "../src/files.h"
#include "../src/vars.h"
#include "../src/select.h"
#include "../src/img_fmt.h"

	// gui_indep.h
#define tilp_set_gui_fncts		set_gui_fncts

	// sub_main.h
#define tilp_init_core			main_init

	// error.h
//#define tilp_error error

	// cb_calc.h, cb_screen.h
#define tilp_calc_is_ready		cb_calc_is_ready
#define tilp_send_backup		cb_send_backup
#define tilp_recv_backup		cb_recv_backup
#define tilp_get_idlist			cb_id_list
#define tilp_rom_dump			cb_rom_dump
#define tilp_rom_version		cb_rom_version
#define tilp_send_var			cb_send_var
#define tilp_recv_var			cb_recv_var
#define tilp_dirlist			cb_dirlist
#define tilp_send_flash_app		cb_send_flash_app
#define tilp_send_flash_os		cb_send_flash_os
#define tilp_recv_app			cb_recv_app
#define tilp_capture_screen		cb_screen_capture
#define tilp_save_screen		cb_screen_save
#define tilp_ams2rom			cb_ams_to_rom

	// cb_misc.h
#define tilp_save_config_file	cb_save_config_file
#define tilp_load_config_file	cb_load_config_file
#define tilp_default_config		cb_default_config
#define tilp_probe_calc			cb_probe_calc
#define tilp_probe_port			cb_probe_port
#define tilp_change_drive		cb_change_drive
#define tilp_send_cmdline		cb_send_cmdline

	//rcfile.h
#define tilp_check_access		check_access
#define tilp_rcfile_read		read_rc_file
#define tilp_rcfile_write		write_rc_file
#define tilp_rcfile_exist		is_rcfile_exist
#define tilp_rcfile_version		rcfile_version

	//select.h
#define tilp_clist_selection_destroy		clist_selection_destroy
#define tilp_ctree_selection_destroy		clist_selection_destroy
#define tilp_clist_file_selection_destroy	clist_file_selection_destroy
#define tilp_add_file_to_file_selection		add_file_to_file_selection
#define tilp_delete_selected_files			delete_selected_files
#define tilp_rename_selected_files			rename_selected_files

	//files.h
#define tilp_process_buffer		process_buffer
#define tilp_process_unix2dos	process_unix2dos
#define tilp_copy_file			copy_file
#define tilp_move_file			move_file
#define tilp_delete_file		delete_file

  //vars.h

	//img_fmt.h
#define tilp_write_pcx_format			write_pcx_format
#define tilp_read_pcx_format			read_pcx_format
#define tilp_write_jpg_format			write_jpg_format
#define tilp_read_jpg_format			read_jpg_format
#define tilp_write_jpg_true_colors		write_jpg_true_colors
#define tilp_write_xpm_format			write_xpm_format
#define tilp_read_xpm_format			read_xpm_format

#define tilp_convert_pixmap_to_bytemap	convert_pixmap_to_bytemap
#define tilp_convert_bytemap_to_pixmap	convert_bytemap_to_pixmap
#define tilp_convert_bitmap_to_pixmap	convert_bitmap_to_pixmap
#define tilp_convert_bitmap_to_bytemap	convert_bitmap_to_bytemap
#define tilp_convert_bytemap_to_bitmap	convert_bytemap_to_bitmap

#define tilp_compute_colormap			compute_colormap
#define tilp_convert_bytemap_to_rgbmap	convert_bytemap_to_rgbmap
#define tilp_convert_rgbmap_to_bytemap	convert_rgbmap_to_bytemap
#define tilp_convert_rgbmap_to_bytemap	convert_rgbmap_to_bytemap

#define tilp_delete_bitmap				delete_bitmap
#define tilp_delete_bytemap				delete_bytemap
#define tilp_delete_colormap			delete_colormap
#define tilp_delete_pixmap				delete_pixmap
#define tilp_delete_rgbmap				delete_rgbmap
#define tilp_delete_image				delete_image

#define tilp_alloc_bitmap				alloc_bitmap
#define tilp_alloc_colormap				alloc_colormap
#define tilp_alloc_bytemap				alloc_bytemap
#define tilp_alloc_rgbmap				alloc_rgbmap

#define tilp_invert_bitmap				invert_bitmap
#define tilp_invert_bytemap				invert_bytemap

#ifdef __cplusplus
}
#endif

#endif


