#include "TintSplash.hpp"

#include "TintApp.hpp"
#include "TintWindow.hpp"
#include "../reg/Components.hpp"
#include "../../images/tint.hpp"
#include "../../../nuvola/nuvola.hpp"

#include "wx/button.h"
#include "wx/gbsizer.h"
#include "wx/filedlg.h"
#include "wx/richtext/richtextctrl.h"

using namespace indii::tint;
using namespace indii::tint::gui;
using namespace indii::tint::reg;

TintSplash::TintSplash(wxWindow* parent, TintApp* app) :
    wxFrame(parent, wxID_ANY, _("indii.org/tintii"), wxDefaultPosition,
    wxDefaultSize, wxCLOSE_BOX|wxMINIMIZE_BOX|wxCAPTION|wxCLIP_CHILDREN|
    wxSYSTEM_MENU), app(app) {
  static const int PADDING = 4;

  SetBackgroundStyle(wxBG_STYLE_COLOUR);
  SetBackgroundColour(*wxWHITE);
  
  /* menu bar for Mac */
  #ifdef __WXMAC__
  wxMenuBar* mbMenu = new wxMenuBar();
      
  wxMenu* mnFile = new wxMenu();
  mnFile->Append(wxID_OPEN);
  mnFile->Append(wxID_ABOUT); // moved to program menu
  mnFile->Append(wxID_EXIT); // moved to program menu
      
  wxMenu* mnView = new wxMenu();
  mnView->Append(ID_BUT_SPLASH, _("Splash"));

  mbMenu->Append(mnFile, _("File"));
  mbMenu->Append(mnView, _("View"));

  this->SetMenuBar(mbMenu);
  #endif
      
  /* toolbar */
  wxToolBar* tbTop = this->CreateToolBar(wxNO_BORDER|wxTB_HORIZONTAL|wxTB_TEXT);
  tbTop->SetToolBitmapSize(wxSize(32,32));
  tbTop->AddTool(wxID_OPEN, _("Open"), *_img_nuvola_fileopen);
  if (!Components::allActivated()) {
    tbTop->AddSeparator();
    tbTop->AddTool(ID_BUT_REGISTER, _("Register"), *_img_nuvola_password);
  }

  #ifndef __WXMAC__
  /* on Mac, would expect to just use X button in title bar to close, and
   * have menubar for about */
  tbTop->AddSeparator();
  tbTop->AddTool(wxID_ABOUT, _("About"), *_img_nuvola_messagebox_info);
  tbTop->AddTool(wxID_CLOSE, _("Close"), *_img_nuvola_exit);
  #endif

  tbTop->Realize();

  /* text */
  wxGridBagSizer* sizer = new wxGridBagSizer();
  wxStaticBitmap* bmpSplash = new wxStaticBitmap(this, wxID_ANY,
      *_img_tint_splash);
  sizer->Add(bmpSplash, wxGBPosition(0,0));

  if (!Components::allActivated()) {
    wxStaticText* txtReg = new wxStaticText(this, wxID_ANY,
        _("tintii is best used as a plugin for Adobe Photoshop or Corel "
        "Paint Shop Pro, but this standalone trial version will let you try "
        "the effect. Click the Open button above and select a photo to work "
        "with. To upgrade to the plugin version, click the Register "
        "button."));
    #ifdef __WXMAC__
    txtReg->SetFont(*wxSMALL_FONT);
    #endif
    txtReg->Wrap(318);
    sizer->Add(txtReg, wxGBPosition(1,0), wxDefaultSpan, wxEXPAND|wxALL,
        PADDING);
  }

  SetSizerAndFit(sizer);
  wxSize size(GetSize());
  size.SetWidth(330);
  SetSize(size);
}

TintSplash::~TintSplash() {  
  //
}

void TintSplash::OnSystemClose(wxCloseEvent& evt) {
  if (app != NULL) {
    app->notifySplashClose(this);
  }
  #ifdef __WXMAC__
  Show(false);
  #else
  Destroy();
  #endif
}

void TintSplash::OnButtonClose(wxCommandEvent& evt) {
  Close();
}

BEGIN_EVENT_TABLE(TintSplash, wxFrame)
EVT_CLOSE(TintSplash::OnSystemClose)
EVT_TOOL(wxID_CLOSE, TintSplash::OnButtonClose)
END_EVENT_TABLE()

