/***************************************************************************
                          stoppuhr.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jan 11 21:09:39 MET 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "stoppuhr.h"
#include "wx/wx.h"

#include <cstdio>
#include <iostream>


//**********************************************************************
//* Konstruktor der Stoppuhr Klasse
//**********************************************************************

stoppuhr::stoppuhr()
{
  time(&m_s);
  m_stopp = 0;
};

//**********************************************************************
//* Destruktor der Stoppuhr Klasse
//**********************************************************************

stoppuhr::~stoppuhr()
{
};

//**********************************************************************
//* Stoppuhrzeit bekommen
//**********************************************************************

wxString stoppuhr::GetZeit()
{
  char c[10];
  time_t temp;
  time(&temp);
  if (m_stopp == 0)
    {
      temp -= m_s;
    }
  else
    {
      temp = m_stopp - m_s;
    }
   m_tm = localtime(&temp);
   m_tm->tm_hour = m_tm->tm_hour - 1;
   wxString s;
   strftime(c, 10, "%X", m_tm);
   s  << c;
   return s;
}



//**********************************************************************
//* int GetSek() Zeit in Sekunden zurckgeben
//**********************************************************************

int stoppuhr::GetSek()
{
  time_t temp;
  time(&temp);
  if (m_stopp == 0)
    {
      temp -= m_s;
    }
  else
    {
      temp = m_stopp - m_s;
    }
   return temp;
}

time_t stoppuhr::GetTZeit()
{
   time_t temp;
  time(&temp);
  if (m_stopp == 0)
    {
      temp -= m_s;
    }
  else
    {
      temp = m_stopp - m_s;
    }
   return temp;
}

//**********************************************************************
//* Wann wurde die Uhr gestartet?
//**********************************************************************

wxString stoppuhr::GetStartZeit()
{
  char c[8];
  m_tm = localtime(&m_s);
  strftime(c, 8, "%X", m_tm);
  wxString s = c;
  return s;
}

//**********************************************************************
//* Wann wurde die Uhr gestoppt?
//**********************************************************************

wxString stoppuhr::GetStoppZeit()
{
  char c[8];
  m_tm = localtime(&m_stopp);
  strftime(c, 8, "%X", m_tm);
  wxString s = c;
  return s;
}

//***********************************************************************
//* Uhr starten
//***********************************************************************

bool stoppuhr::Start()
{
  // 
 time(&m_s);
  m_stopp = 0;
  return true;
}

//***********************************************************************
//* Uhr stoppen
//***********************************************************************

bool stoppuhr::Stopp()
{
  time(&m_stopp);
  return true;
}

//***********************************************************************
//* Pause
//***********************************************************************

bool stoppuhr::Pause()
{
  time(&m_stopp);
  time(&m_ps);
  return true;
}

//***********************************************************************
//* Uhr wieder laufen lassen, ohne auf null zu stellen
//***********************************************************************

bool stoppuhr::Weiter()
{
  m_stopp = 0;
  time(&m_pe);
  // Die nchste Zeile ist ntig, da sonst in der Pause die Uhr weiterluft.
  m_s += (m_pe - m_ps);
  return true;
}

bool stoppuhr::Clear()
{
  m_s = 0;
  m_stopp = 0;
  return true;
}
