/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


//
// $Id: FPU.h 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $
//

#ifndef _FPU_h
#define _FPU_h

class FloatingPointUnit {
public:

    enum TrapType {
	No_FPU_Trap		= 0,
	IEEE_754_exception 	= 1,
	unfinished_FPop		= 2,
	unimplemented_FPop	= 3,
	sequence_error		= 4,
	hardware_error		= 5,
	invalid_fp_register	= 6,
	reserved		= 7
    };

    // public Constructors / Destructors
    //
    FloatingPointUnit();
    ~FloatingPointUnit();

    // public Member functions
    //     
    void	reset();
    int		dispatch_instruction(const Instruction&);


    // FPU register query/modify
    //
    UInt32	ireg(UInt32);			//for convert instructions
    Float_s	freg(UInt32);
    Float_d	dreg(UInt32);

    void	ireg(UInt32, UInt32);
    void	freg(UInt32, Float_s);
    void	dreg(UInt32, Float_d);

    UInt32	FSR();
    void	FSR(UInt32);


    // FSR field query
    //
    UInt32	RD();
    UInt32	TEM();
    UInt32	NS();
    UInt32	ver();
    UInt32	ftt();
    UInt32	qne();
    UInt32	fcc();
    UInt32	aexc();
    UInt32	cexc();

private:
    FloatingPointUnit(const FloatingPointUnit&);    // Declare away
    void operator = (const FloatingPointUnit&);	    // Declare away

    enum Opf {
	FiTOs  = 0x0c4,
	FiTOd  = 0x0c8,
	FiTOq  = 0x0cc,

	FsTOi  = 0x0d1,
	FdTOi  = 0x0d2,
	FqTOi  = 0x0d3,

	FsTOd  = 0x0c9,
	FsTOq  = 0x0cd,
	FdTOs  = 0x0c6,
	FdTOq  = 0x0ce,
	FqTOs  = 0x0c7,
	FqTOd  = 0x0cb,

        FMOVs  = 0x001,
        FNEGs  = 0x005,
        FABSs  = 0x009,

        FSQRTs = 0x029,
        FSQRTd = 0x02a,
        FSQRTq = 0x02b,

        FADDs  = 0x041,
        FADDd  = 0x042,
        FADDq  = 0x043,
        FSUBs  = 0x045,
        FSUBd  = 0x046,
        FSUBq  = 0x047,

        FMULs  = 0x049,
        FMULd  = 0x04a,
        FMULq  = 0x04b,
        FsMULd = 0x069,
        FdMULq = 0x06e,
        FDIVs  = 0x04d,
        FDIVd  = 0x04e,
        FDIVq  = 0x04f,

	FCMPs  = 0x051,
	FCMPd  = 0x052,
	FCMPq  = 0x053,
	FCMPEs = 0x055,
	FCMPEd = 0x056,
	FCMPEq = 0x057
    };

    int	convert_itof(const Instruction&);
    int	convert_ftoi(const Instruction&);
    int	convert_ftof(const Instruction&);
    int	move(const Instruction&);
    int	square_root(const Instruction&);
    int	add_subtract(const Instruction&);
    int	multiply_divide(const Instruction&);
    int	compare(const Instruction&);
    int	unimplemented();


    // FPU f Registers
    // 
    union {
	UInt32		_ireg[32];	// sizeof(UInt32) == sizeof(Float_s)
	Float_s		_freg[32];
	Float_d		_dreg[16];
    };


    // FSR fields
    //
    UInt32	_RD;	// FSR<31:30>
    UInt32	_TEM;	// FSR<27:23>
    UInt32	_NS;	// FSR<22>
    UInt32	_ver;	// FSR<19:17>
    UInt32	_ftt;	// FSR<16:14>
    UInt32	_qne;	// FSR<13>
    UInt32	_fcc;	// FSR<11:10>
    UInt32	_aexc;	// FSR<9:5>
    UInt32	_cexc;	// FSR<4:0>
};

#endif /* _FPU_h */
