// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef KNN_INC
#define KNN_INC

#include "Machine.h"
#include "DataSet.h"

namespace Torch {

/** This machine implements the K-nearest-neighbors (KNN) algorithm.
    Given a dataset (in the constructor), the #forward# method returns
    for a given input the average of the outputs of the K nearest examples
    (in the input space, using the Euclidean distance). As a side effect,
    the machine also keep the table of distances of the K-nearest-neighbors.

    @author Samy Bengio (bengio@idiap.ch)
*/
class KNN : public Machine
{
  public:

    /// The number of nearest neighbors. Controls the capacity of the machine
    int K;
    /// For each nearest neighbor, keeps its distance to the current input
    real* distances;
    /// For each nearest neighbor, keeps its index in the dataset
    int* indices;
    /// The dataset that contains the potential neaghbors
    DataSet* data;

    /// the indices of the training examples
    int *real_examples;
    int n_real_examples;

    ///
    KNN(DataSet* data_,int K_);

    virtual void forward(List *inputs);
    virtual void reset();

    /// change the value of K
    virtual void setK(int K_);

    virtual ~KNN();
};


}

#endif
