// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef KMEANS_INC
#define KMEANS_INC

#include "DiagonalGMM.h"

namespace Torch {

/** This class can be used to do a "kmeans" on a given set of data.
    It has been implemented in the framework of a Distribution that can
    be trained with EM. This means that the kmeans distance is in fact
    returned by the method logProbability.

    Note that as Kmeans is a subclass of DiagonalGMM, they share the same
    parameter structure. Hence, a DiagonalGMM can be easily initialized by
    a Kmeans.

    @author Samy Bengio (bengio@idiap.ch)
*/
class Kmeans : public DiagonalGMM
{
  public:

    /// for each example, keep the index of the neirest cluster
    int* min_cluster;

    /** we need the dataset in order to initialize correctly the centers
        of the clusters.
    */
    SeqDataSet* data;

    ///
    Kmeans(int n_observations_, int n_gaussians_, real* stdev_threshold_, real prior_weights_, SeqDataSet* data_);

    virtual void reset();

    virtual void eMIterInitialize();
    virtual void frameEMAccPosteriors(real *observations, real log_posterior, real *inputs, int t);
    virtual void eMUpdate();

    virtual void allocateMemory();
    virtual void freeMemory();
    virtual void eMSequenceInitialize(List* inputs);

    /** note that this method returns in fact the euclidean distance between 
        the observation and the neirest cluster
    */
    virtual real frameLogProbability(real *observations, real *inputs, int t);


    virtual ~Kmeans();
};


}

#endif
