// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef CLASS_LL_CRITERION_INC
#define CLASS_LL_CRITERION_INC

#include "Criterion.h"
#include "ClassFormat.h"

namespace Torch {

/** This criterion can be used to train *in classification* a #GradientMachine#
    object using the #GMTrainer# trainer. It then maximizes the log likelihood
    of the data.

    If we write $o_i$ for the output $i$ of the #GradientMachine#, it supposes that
    \begin{itemize}
      \item the outputs $o_i$ are log-probabilities.
      \item $exp(o_i)$ is the probability for the class $i$
      \item the predicted class follows a multinomial distribution with parameters
            $(exp(o_1), exp(o_2), exp(o_3)...)$
    \end{itemize}

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class ClassLLCriterion : public Criterion
{
  public:
    ClassFormat *class_format;
    int beta_on;

    /// The ClassFormat is needed just to know how the targets are encoded in the data.
    ClassLLCriterion(ClassFormat *class_format);

    virtual void reset();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);
    virtual ~ClassLLCriterion();
};


}

#endif
