// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "EuclideanDataSet.h"

namespace Torch {

EuclideanDataSet::EuclideanDataSet()
{
}

real EuclideanDataSet::dotProduct(int i, int j)
{
  if(select_examples)
    return(realRealDotProduct(selected_examples[i], selected_examples[j]));
  else
    return(realRealDotProduct(i, j));
}

real EuclideanDataSet::dotProduct(int i, List *y)
{
  if(select_examples)
    return(realDotProduct(selected_examples[i], y));
  else
    return(realDotProduct(i, y));
}

real EuclideanDataSet::realDotProduct(int i, int j)
{
  if(select_examples)
    return(realRealDotProduct(i, selected_examples[j]));
  else
    return(realRealDotProduct(i, j));
}

EuclideanDataSet::~EuclideanDataSet()
{
}

}

