// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "OneHotClassFormat.h"

namespace Torch {

OneHotClassFormat::OneHotClassFormat(DataSet *data)
{
  n_classes = data->n_targets;
  class_labels_buffer = (real *)xalloc(sizeof(real)*n_classes*n_classes);
  class_labels = (real **)xalloc(sizeof(real *)*n_classes);
  for(int i = 0; i < n_classes; i++)
  {
    class_labels[i] = class_labels_buffer+i*n_classes;
    for(int j = 0; j < n_classes; j++)
      class_labels[i][j] = 0.;
    class_labels[i][i] = 1.;
  }
  message("OneHotClassFormat: %d classes detected", n_classes);
}

OneHotClassFormat::OneHotClassFormat(int n_targets)
{
  n_classes = n_targets;
  class_labels_buffer = (real *)xalloc(sizeof(real)*n_classes*n_classes);
  class_labels = (real **)xalloc(sizeof(real *)*n_classes);
  for(int i = 0; i < n_classes; i++)
  {
    class_labels[i] = class_labels_buffer+i*n_classes;
    for(int j = 0; j < n_classes; j++)
      class_labels[i][j] = 0.;
    class_labels[i][i] = 1.;
  }
  message("OneHotClassFormat: %d classes detected", n_classes);
}

int OneHotClassFormat::getOutputSize()
{
  return n_classes;
}

void OneHotClassFormat::fromOneHot(List *outputs, List *one_hot_outputs)
{
  copyList(outputs,one_hot_outputs);
}

void OneHotClassFormat::toOneHot(List *outputs, List *one_hot_outputs)
{
  copyList(one_hot_outputs,outputs);
}

int OneHotClassFormat::getTargetClass(void *target)
{
  real *out = (real *)target;

  real z = *out++;
  int index = 0;
  for(int i = 1; i < n_classes; i++)
  {
    if(*out > z)
    {
      index = i;
      z  = *out;
    }
    out++;
  }
  
  return(index);
}

int OneHotClassFormat::getOutputClass(List *outputs)
{
  real z = *((real *)outputs->ptr);
  int index = 0;

  int i = 0;
  while(outputs)
  {
    real *out = (real *)outputs->ptr;
    for(int j = 0; j < outputs->n; j++)
    {
      if(*out > z)
      {
        index = i;
        z = *out;
      }
      out++;
      i++;
    }
    outputs = outputs->next;
  }
  
  return(index);
}

OneHotClassFormat::~OneHotClassFormat()
{
  free(class_labels_buffer);
  free(class_labels);
}

}

