// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "SVMClassification.h"

namespace Torch {

SVMClassification::SVMClassification(Kernel *kernel_, real *C_) : SVM(kernel_)
{
  l = data->n_real_examples;
  Cuser = C_;

  Cup = (real *)xalloc(sizeof(real)*l);
  for(int i = 0; i < l; i++)
    Cup[i] = C_cst;

  Cdown = (real *)xalloc(sizeof(real)*l);
  for(int i = 0; i < l; i++)
    Cdown[i] = 0;

  alpha = (real *)xalloc(sizeof(real)*l);
  grad = (real *)xalloc(sizeof(real)*l);
  y = (real *)xalloc(sizeof(real)*l);

  l = data->n_examples;
}

void SVMClassification::reset()
{
  l = data->n_examples;
  if(Cuser)
  {
    for(int i = 0; i < l; i++)
      Cup[i] = Cuser[data->selected_examples[i]];
  }

  for(int i = 0; i < l; i++)
    alpha[i] = 0;

  b = 0;

  for(int i = 0; i < l; i++)
  {
    data->setExample(i);
    y[i] = ((real *)data->targets)[0];
    grad[i] = -1;
  }

  n_support_vectors = 0;
  n_support_vectors_bound = 0;

  kernel->reset();
}

void SVMClassification::checkSupportVectors()
{
  // La je prie pour que l'utilisateur normal utilise
  // un processeur deterministe ///
  n_support_vectors = 0;
  n_support_vectors_bound = 0;
  for(int i = 0; i < l; i++)
  {
    if(alpha[i] > eps_bornes)
    {
      if(alpha[i] > Cup[i] - eps_bornes)
        n_support_vectors_bound++;
      
      n_support_vectors++;
    }
  }
  support_vectors = (int *)xrealloc(support_vectors, sizeof(int)*n_support_vectors);
  real_index = (int *)xrealloc(real_index, sizeof(int)*n_support_vectors);

  n_support_vectors = 0;
  for(int i = 0; i < l; i++)
  {
    if(alpha[i] > eps_bornes)
    {
      support_vectors[n_support_vectors  ] = i;
           real_index[n_support_vectors++] = data->selected_examples[i];
    }
  }

  if(!bCompute())
  {
    warning("SVMClassification: b is not unique. It's probably wrong");
    warning("SVMClassification: I think you are using silly parameters");
  }
}

SVMClassification::~SVMClassification()
{
  free(Cup);
  free(Cdown);
  free(alpha);
  free(grad);
  free(support_vectors);
  free(real_index);
  free(y);
}

}

