// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SVM_REGRESSION_INC
#define SVM_REGRESSION_INC

#include "SVM.h"

namespace Torch {

/** SVM in regression.

    Try to find the hyperplane f(x) = w.x+b
    as
    $(w,b)$ minimize $0.5*||w||^2 + \sum_j C_j |w.x_j+b -y_j -eps|_+$
                             $+ \sum_j C_(j+n) |y_j -w.x_j-b -eps|_+$
    
    (where $|x|_+ = x$ if $x > 0$, else $0$)
    (and $n$ is the number of training examples)
    (the size of $C$ is here 2*$n$)

    ("eps" is #eps_regression# in the code)

    (in fact, we use a kernel #kernel# instead of
    a dot product)

    The $C_j$ coefficients are given by #C_# when you
    call the constructor. If this one is NULL, all
    #C_j# will have the value given by the "C" option.
    (The size of #C_# \emph{must be} #2*data->n_real_examples#)

    Options:
    \begin{tabular}{lcll}
      "eps regression"  &  real  & size of the error tube  & [0.7]
    \end{tabular}

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class SVMRegression : public SVM
{
  public:
    bool C_is_allocated;
    real eps_regression;
    real *Cuser;

    //-----

    ///
    SVMRegression(Kernel *kernel_, real *C_=NULL);

    //-----

    virtual void checkSupportVectors();
    virtual void reset();

    virtual ~SVMRegression();    
};


}

#endif
