// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "SumMachine.h"

namespace Torch {


SumMachine::SumMachine(int n_units,int n_machines_)
{
  n_machines = n_machines_;
  n_inputs = n_units * n_machines;
  n_outputs = n_units;
}

int SumMachine::numberOfParams()
{
  return(0);
}

void SumMachine::forward(List *inputs)
{
  real *ptr_out = (real *)outputs->ptr;
  for (int i=0;i<n_outputs;i++)
    *ptr_out++ = 0;
  ptr_out = (real *)outputs->ptr;
  int i=0;
  while(inputs)
  {
    real *x = (real *)inputs->ptr;
    for(int j = 0; j < inputs->n; j++,i++)
      *ptr_out++ += *x++;
    if (i%n_outputs == 0)
      ptr_out = (real *)outputs->ptr;
    inputs = inputs->next;
  }
}

void SumMachine::backward(List *inputs, real *alpha)
{
  real *beta_ptr = beta;
  for (int i=0;i<n_machines;i++) {
    real *alpha_ptr = alpha;
    for (int j=0;j<n_outputs;j++)
      *beta_ptr++ = *alpha_ptr++; 
  }
}

SumMachine::~SumMachine()
{
}

}

