// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef TIME_MEASURER_INC
#define TIME_MEASURER_INC

#include "Measurer.h"

namespace Torch {

/** Measure the time (in seconds) between
    two  #measureIter()# calls.

    Save in #file# the sum of these time,
    at each iteration.

    #measure# = {[real] sum of time in sec}

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class TimeMeasurer : public Measurer
{
  public:
    long time_start;
    long time_end;
    double *the_time;

    //-----

    ///
    TimeMeasurer(DataSet *data_, FILE *file_);
    ///
    TimeMeasurer(DataSet *data_, const char *filename);

    //-----

    virtual void init();
    virtual void reset();
    virtual void measureIter();
    virtual void measureEnd();

    virtual ~TimeMeasurer();
};


}

#endif
