// Copyright (C) 2002 Johnny Mariethoz (Johnny.Mariethoz@idiap.ch)
//                and Samy Bengio (bengio@idiap.ch)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "general.h"
#include "string_utils.h"
#include <stdarg.h>

namespace Torch {

char *strBaseName(char *filename) {
   char *p = strrchr(filename, '/');
   return p ? (p+1) : filename;
}

char *strRemoveSuffix(char *filename, char c)
{
  char *copy = NULL;
  int len = strlen(filename);
  char *p = filename + len - 1;
  int i=len;
  while (*p != c && i-- >=0) p--;
  if (i>0) {
    //*p = '\0';
    copy = (char*)xalloc(sizeof(char)*i);
    strncpy(copy,filename,i-1);
    copy[i-1] = '\0';
  } else {
    copy = (char*)xalloc(sizeof(char)*(len+1));
    strcpy(copy,filename);
  }
  return copy;
}

char *strConcat(int n, ...)
{
  char **strs = (char **)xalloc(sizeof(char *)*n);

  int taille = 0;
  va_list args;
  va_start(args, n);
  for(int i = 0; i < n; i++)
  {
    strs[i] = va_arg(args, char *);
    taille += strlen(strs[i]);
  }
  va_end(args);
  taille++; // Pour le truc de fin

  char *the_concat = (char *)xalloc(sizeof(char)*taille);
  the_concat[0] = '\0';

  for(int i = 0; i < n; i++)
    strcat(the_concat, strs[i]);

  free(strs);

  return(the_concat);
}

}

