/* hci.c -- Hardware Configuration Interface
 *
 * Copyright (c) 1998/99  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
 *
 *   This code is covered by the GNU GPL and you are free to make any
 *   changes you wish to it under the terms of the license. However the
 *   code has the potential to render your computer and/or someone else's
 *   unuseable. Unless you truely understand what is going on, I urge you
 *   not to make any modifications and use it as it stands.
 *   
 * $Log: hci.c,v $
 * Revision 1.4  2002/01/29 01:13:26  schwitrs
 * removed segfault signal hack
 * replaced with extra element on stack hack
 *
 * Revision 1.3  2002/01/23 19:47:53  schwitrs
 * HciFunction: now set all SSM registers
 * involves major hack to get around segfault in asm: catch signal and restart.
 *
 * Revision 1.2  2001/05/14 16:39:51  schwitrs
 * redid HciGetMachineID- stuff from Jonathan's kernel module
 *
 * Revision 1.1  2000/02/03 02:49:03  schwitrs
 * Initial revision
 *
 * Revision 1.2  1999/08/15 10:43:28  jab
 * removed the HciGet and HciSet and replaced with HciFunction
 *
 * Revision 1.1  1999/03/11 20:27:06  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

static const char rcsid[]="$Id: hci.c,v 1.4 2002/01/29 01:13:26 schwitrs Exp $";

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/mman.h>

#include <setjmp.h>
#include <signal.h>

#include"hci.h"

static jmp_buf jmpEnvironment;

//static void
//handleSegfault(int num)
//{
// //printf("handleSegfault called\n");
// longjmp(jmpEnvironment, 1);
//}


static int id=0xfc2f;

int HciFunction(SMMRegisters *reg)
{
 unsigned int eax,ebx,ecx,edx,esi,edi;
 int fail=1;

 while (fail) {
   setjmp( jmpEnvironment );
//   if ( signal(SIGSEGV, handleSegfault) == SIG_ERR ) {
//     printf("HciFunction: error installing signal handler.\n");
//     abort();
//   }
   

   eax = reg->eax;
   ebx = reg->ebx;
   ecx = reg->ecx;
   edx = reg->edx;
   esi = reg->esi;
   edi = reg->edi;

   /* emulate the HCI fan function for the Portage 610 and Tecra 700 */
   
   if ((id==0xfccb) && (ebx==HCI_FAN)) {
     asm("movw %1,%%ax\n\t" \
	 "movw %2,%%cx\n\t" \
	 "cli\n\t" \
	 "movb $0xbe,%%al\n\t" \
	 "outb %%al,$0xe4\n\t" \
	 "inb $0xe5,%%al\n\t" \
	 "cmpb $0xfe,%%ah\n\t" \
	 "je 3f\n\t" \
	 "cmpw $0x0001,%%cx\n\t" \
	 "jne 1f\n\t" \
	 "andb $0xfe,%%al\n\t" \
	 "jmp 2f\n\t" \
	 "1: orb $0x01,%%al\n\t" \
	 "2: movb %%al,%%ah\n\t" \
	 "movb $0xbe,%%al\n\t" \
	 "outb %%al,$0xe4\n\t" \
	 "movb %%ah,%%al\n\t" \
	 "outb %%al,$0xe5\n\t" \
	 "3: sti\n\t" \
	 "andw $0x0001,%%ax\n\t" \
	 "movw %%ax,%0\n" \
	 :"=m" (ecx) : "m" (eax), "m" (ecx) : "memory" );
     ecx = (ecx==0x00) ? 0x01:0x00;
     eax = 0x0000;
   } else if ((id==0xfccb) && (ebx==HCI_FAN)) {
     asm("movw %1,%%ax\n\t" \
	 "movw %2,%%cx\n\t" \
	 "cli\n\t" \
	 "movw $0x00e4,%%dx\n\t" \
	 "movb $0xe0,%%al\n\t" \
	 "outb %%al,%%dx\n\t" \
	 "incw %%dx\n\t" \
	 "inb %%dx,%%al\n\t" \
	 "cmpb $0xfe,%%ah\n\t" \
	 "je 3f\n\t" \
	 "cmpw $0x0001,%%cx\n\t" \
	 "jne 1f\n\t" \
	 "orw $0x0001,%%ax\n\t" \
	 "jmp 2f\n\t" \
	 "1: andw $0xfffe,%%ax\n\t" \
	 "2: decw %%dx\n\t" \
	 "movb %%al,%%ah\n\t" \
	 "movb $0xe0,%%al\n\t" \
	 "outw %%ax,%%dx\n\t" \
	 "3: sti\n\t" \
	 "andw $0x0001,%%ax\n\t" \
	 "movw %%ax,%0\n" \
	 :"=m" (ecx) : "m" (eax), "m" (ecx) : "memory" );
     eax = 0x0000;		
   } else {
#if 1
     //#ifdef DONTUSE
     /* note that an extra dummy push onto the stack is made.
      *	Somehow this entry sometimes get overwritten causing an
      * eventual segfault. 
      */
     asm("# load the values into the registers\n\t" \
	  "pushl %%eax\n\t" \
	  "pushl %%eax\n\t" \
	 "movl 0(%%eax),%%edx\n\t" \
	 "pushl %%edx\n\t" \
	 "movl 4(%%eax),%%ebx\n\t" \
	 "movl 8(%%eax),%%ecx\n\t" \
	 "movl 12(%%eax),%%edx\n\t" \
	 "movl 16(%%eax),%%esi\n\t" \
	 "movl 20(%%eax),%%edi\n\t" \
	 "popl %%eax\n\t" \
	 "# call the System Management mode\n\t" \
	 "inb $0xb2,%%al\n\t" \
	 "# fill out the memory with the values in the registers\n\t" \
	 "xchgl %%eax,(%%esp)\n\t" \
	 "popl %%eax\n\t" \
	 "xchgl %%eax,(%%esp)\n\t" \
	 "movl %%ebx,4(%%eax)\n\t" \
	 "movl %%ecx,8(%%eax)\n\t" \
	 "movl %%edx,12(%%eax)\n\t" \
	 "movl %%esi,16(%%eax)\n\t" \
	 "movl %%edi,20(%%eax)\n\t" \
	 "popl %%edx\n\t" \
	 "movl %%edx,0(%%eax)\n\t" \
	 :
	 : "eax" (reg)
	 : "%ebx", "%ecx", "%edx", "%esi", "%edi", "memory", "cc");
	//#endif
//	  asm volatile ("# call the System Management mode\n\t" 
//			"movl %1,%%esi\n"
//			"inb $0xb2,%%al\n" 
//			"movl %%esi,%0\n"
//			: "=eax" (eax), "=ebx" (ebx), 
//			"=ecx" (ecx)
//			, "=edx" (edx), "=r" (esi) 
//			: "eax" (eax), "ebx" (ebx), "ecx" (ecx)
//			, "edx" (edx), "r" (esi) 
//			: "%esi", "memory", "cc");
//	  
//	  if ( ( eax & 0xff00)>>8 )  //will segfault if we don't return
//	    return  ( eax & 0xff00)>>8;
//	  
//	  reg->eax = eax;
//	  reg->ebx = ebx;
//	  reg->ecx = ecx;
//	  reg->edx = edx;
//	  reg->esi = esi;
//	    reg->edi = edi;
#else
     asm ("inb $0xb2,%%al\n" \
	  :"=eax" (eax), "=ebx" (ebx), "=ecx" (ecx), "=edx" (edx) \
	  :"eax" (eax), "ebx" (ebx), "ecx" (ecx), "edx" (edx) \
	  : "memory" );
     reg->eax = eax;
     reg->ebx = ebx;
     reg->ecx = ecx;
     reg->edx = edx;
     reg->esi = esi;
     reg->edi = edi;
#endif
   }
   fail=0;
 }
	

 // signal(SIGSEGV, SIG_DFL);
 return (int) (reg->eax & 0xff00)>>8;
}


/*
 * Return the BIOS version of the laptop
 *
 *   I may or may not follow the Toshiba version of this function. The
 *   Toshiba function would appear to read from this area of memory, but
 *   exactly what it does I am not sure. This implemenation is impirically
 *   based on the contents of these memory locations on my Satellite Pro
 *   400CS and Libretto 50CT. I have confirmed that it returns the correct
 *   information on a Tecra 750CDT and a T4900 as well.
 */
int HciGetBiosVersion(void)
{
	int device,major,minor;
	unsigned char *mem;


	if ((device = open("/dev/mem", O_RDWR))==-1)
		return HCI_FAILURE;

	mem = mmap(0, 0x1000, PROT_READ, MAP_SHARED, device, 0xfe000);
	if (mem==(unsigned char *)-1)
		return HCI_FAILURE;

	major = (char) mem[0x0009]-'0';
	minor = (((char) mem[0x000b]-'0')*10)+((char) mem[0x000c]-'0');

	munmap(mem, 0x1000);
	close(device);

	id = (major*0x100)+minor;

	return id;
}


/*
 * Get the Toshiba machine identification number
 *
 *     0xfc2f: New style Machine ID
 *     0xfcc3: Tecra 720x
 *     0xfcca: Satellite Pro 400x
 *     0xfccb: Portage 610CT
 *     0xfccc: Tecra 700x
 *     0xfcdd: Satellite 110x
 *     0xfcd7: Satellite Pro 430x
 *     0xfcdf: Tecra 500x
 */
int HciGetMachineID(int *id)
{
	int device;
	unsigned char *mem;
	unsigned short bx;
	//	unsigned char fl;

	if ((device = open("/dev/mem", O_RDWR))==-1)
		return HCI_FAILURE;

	mem = mmap(0, 0x100000, PROT_READ, MAP_SHARED, device,0); // 0xfe000);
	if (mem==(unsigned char *)-1)
		return HCI_FAILURE;

	*id = (0x100*((int) mem[0xffffe]))+((int) mem[0xffffa]);
	/* do we have a SCTTable machine identication number on our hands */

	  if (*id==0xfc2f) {
	    unsigned char ah;
	    unsigned short cx;
	    unsigned long address;

		  /* start by getting a pointer into the BIOS */

		  asm ("movw $0xc000,%%ax\n\t" \
			  "movw $0x0000,%%bx\n\t" \
			  "movw $0x0000,%%cx\n\t" \
			  "inb $0xb2,%%al\n\t" \
			  "movb %%ah,%%al\n" \
			  : "=b" (bx), "=a" (ah) : : "%ecx");

		  /* printf("bx: %x  mem: %x\n",bx,mem); */

		  /* At this point in the Toshiba routines under MS Windows
		     the bx register holds 0xe6f5. However my code is producing
		     a different value! For the time being I will just fudge the
		     value. This has been verified on a Satellite Pro 430CDT,
		     Tecra 750CDT, Tecra 780DVD and Satellite 310CDT. */
		  bx = 0xe6f5;

		  /* now twiddle with our pointer a bit */

		  address = 0x000f0000+bx;
		  //		cx = readw(address);
		  //		  address = bx - 0xe000;
		  cx = *(unsigned short*)(mem+address);
		  address = 0x000f0009+bx+cx;
		  //		  address = 0x9+bx+cx - 0xe000;
		  //		cx = readw(address);
		  cx = *(unsigned short*)(mem+address);
		  address = 0x000f000a+cx;
		  //		  address = 0xa+cx - 0xe000;
		  //		cx = readw(address);
		  cx = *(unsigned short*)(mem+address);

		  /* now construct our machine identification number */

		  *id = ((cx & 0xff)<<8)+((cx & 0xff00)>>8);
	  }

	munmap(mem, 0x1000);
	close(device);


	return HCI_SUCCESS;
}


/*
 * Return the LCD Panel type
 *
 */
int HciGetLCDPanelType(unsigned short mode, unsigned short *status)
{
	unsigned short ax,bx,cx;
	unsigned char fl;

	bx = mode;
	cx = *status;
	
	asm ("movw $0xfefe,%%ax\n\t" \
		"movw $0x0011,%%bx\n\t" \
		"inb $0xb2,%%al\n\t" \
		"movw %%ax,%0\n\t" \
		"movw %%bx,%1\n\t" \
		"movw %%cx,%2\n\t" \
		"lahf\n\t" \
		"movb %%ah,%3\n"
		:"=m" (ax), "=m" (bx), "=m" (cx), "=m" (fl) \
		:"m" (bx), "m" (cx) \
		: "memory" );

	*status = cx;

	return (int) (fl & 0x01);
}


/*
 * Return the status of the Fn key
 */
int HciFnStatus(void)
{
        unsigned char al;

        asm ("cli\n\t" \
                "movw $0x008e,%%ax\n\t" \
                "outb %%al,$0xe4\n\t" \
                "inb $0xe5,%%al\n\t" \
                "movb %%al,%0\n\t" \
                "sti\n"
                :"=m" (al) : : "memory" );

        return (int) al;
}
