#include "tra.h"

typedef struct Arg Arg;
struct Arg
{
	Fdbuf *fd;
	char c;
	Chan *done;
};

enum
{
	BUFSZ = (1<<15)
};

void
copy(void *v)
{
	Fdbuf *fd;
	char c;
	char *buf;
	char tag[10];
	int n;
	Arg *a;

	a = v;
	fd = a->fd;
	c = a->c;

	buf = emalloc(BUFSZ);
	while((n = readfdbuf(fd, buf, sizeof buf)) > 0){
		sprintf(tag, "%c%.4X", c, n);
		write(1, tag, 5);
		write(1, buf, n);
	}
	sendp(a->done, nil);
}

/* BUG: this should be in the system dependent stuff, but not yet */
void
run(char *argv[], int *p, int *q)
{
	int ps[2], pe[2];

	if(pipe(ps) < 0 || pipe(pe) < 0)
		sysfatal("pipe: %r");

	switch(fork()){
	case -1:
		sysfatal("fork: %r");

	case 0:
		close(ps[0]); close(pe[0]);
		/* Plan 9 dup; Unix dup2 */
		if(dup(ps[1], 1) < 0 || dup(pe[1], 2) < 0)
			sysfatal("dup: %r");
		execvp(argv[0], argv);
		sysfatal("exec: %r");

	default:
		close(ps[1]); close(pe[1]);
		*p = ps[0];
		*q = pe[0];
	}
}

void
usage(void)
{
	fprint(2, "usage: stdmerge cmd ...\n");
	exits("usage");
}

void
threadmain(int argc, char *argv[])
{
	int p, q;
	Arg *a;
	Chan *done;

	ARGBEGIN{
	default:
		usage();
	}ARGEND

	if(argc < 1)
		usage();

	run(argv, &p, &q);

	done = chan(void*);
	a = emalloc(2*sizeof(Arg));

	a[0].fd = openfdbuf(p);
	a[0].c = 'o';
	a[0].done = done;
	threadcreate(copy, &a[0]);

	a[1].fd = openfdbuf(q);
	a[1].c = 'e';
	a[1].done = done;
	threadcreate(copy, &a[1]);

	recvp(done);
	recvp(done);

	exits(nil);
}
