/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* 
 * setup_label.c - Sets the labels up for different parameters
 * including the tooltip text
 */

#include <string.h>
#include "transcalc.h"

void
setup_label (short ttype, trans_label *tlabel)
{
  
  /*  tlabel = g_malloc(sizeof (*tlabel));*/
  /*  tlabel = calloc(8, 30*sizeof (char));*/

  switch (ttype) {
  case MICROSTRIP:
    /* substrate names */
    tlabel->substrate_label_name[0] = "Er";
    tlabel->substrate_label_name[1] = "Mur";
    tlabel->substrate_label_name[2] = "H";
    tlabel->substrate_label_name[3] = "H_t";
    tlabel->substrate_label_name[4] = "T";
    tlabel->substrate_label_name[5] = "Cond";
    tlabel->substrate_label_name[6] = "Tand";
    tlabel->substrate_label_name[7] = "Rough";
    tlabel->substrate_label_name[8] = NULL;
    /* component names */
    tlabel->component_label_name[0] = "Freq";
    tlabel->component_label_name[1] = NULL;
    tlabel->component_label_name[2] = NULL;
    /* physical parameter names */
    tlabel->physical_label_name[0] = "W"; 
    tlabel->physical_label_name[1] = "L"; 
    tlabel->physical_label_name[2] = NULL; 
    tlabel->physical_label_name[3] = NULL; 
    /* electrical parameter names */
    tlabel->electrical_label_name[0] = "Z0"; 
    tlabel->electrical_label_name[1] = "E_eff"; 
    tlabel->electrical_label_name[2] = NULL; 
    tlabel->electrical_label_name[3] = NULL; 
    /* substrate tooltips */
    tlabel->stooltips_helptext[0] = "Relative Permittivity";
    tlabel->stooltips_helptext[1] = "Relative Permeability";
    tlabel->stooltips_helptext[2] = "Height of substrate";
    tlabel->stooltips_helptext[3] = "Height of Box top";
    tlabel->stooltips_helptext[4] = "Thickness of Strip";
    tlabel->stooltips_helptext[5] = "Conductivity of strip";
    tlabel->stooltips_helptext[6] = "Dielectric Loss Tangent";
    tlabel->stooltips_helptext[7] = "Conductor Roughness";
    tlabel->stooltips_helptext[8] = NULL;
    /* component tooltips */
    tlabel->ctooltips_helptext[0] = "Frequency";
    tlabel->ctooltips_helptext[1] = NULL;
    tlabel->ctooltips_helptext[2] = NULL;
    /* physical tooltips */
    tlabel->ptooltips_helptext[0] = "Line Width";
    tlabel->ptooltips_helptext[1] = "Line Length";
    tlabel->ptooltips_helptext[2] = NULL;
    tlabel->ptooltips_helptext[3] = NULL;
    /* electrical tooltips */
    tlabel->etooltips_helptext[0] = "Characteristic Impedance";
    tlabel->etooltips_helptext[1] = "Electrical Length";
    tlabel->etooltips_helptext[2] = NULL;
    tlabel->etooltips_helptext[3] = NULL;
    
    break;

  case RECTWAVEGUIDE:
    /* substrate names */
    tlabel->substrate_label_name[0] = "Er";
    tlabel->substrate_label_name[1] = "Mur";
    tlabel->substrate_label_name[2] = "Cond";
    tlabel->substrate_label_name[3] = "Tand";
    tlabel->substrate_label_name[4] = "TanM";
    tlabel->substrate_label_name[5] = NULL;
    tlabel->substrate_label_name[6] = NULL;
    tlabel->substrate_label_name[7] = NULL;
    tlabel->substrate_label_name[8] = NULL;
    /* component names */
    tlabel->component_label_name[0] = "Freq";
    tlabel->component_label_name[1] = NULL;
    tlabel->component_label_name[2] = NULL;
    /* physical parameter names */
    tlabel->physical_label_name[0] = "a"; 
    tlabel->physical_label_name[1] = "b"; 
    tlabel->physical_label_name[2] = "L"; 
    tlabel->physical_label_name[3] = NULL; 
    /* electrical parameter names */
    tlabel->electrical_label_name[0] = "Z0"; 
    tlabel->electrical_label_name[1] = "E_eff"; 
    tlabel->electrical_label_name[2] = NULL; 
    tlabel->electrical_label_name[3] = NULL; 
    /* substrate tooltips */
    tlabel->stooltips_helptext[0] = "Relative Permittivity";
    tlabel->stooltips_helptext[1] = "Relative Permeability";
    tlabel->stooltips_helptext[2] = "Conductivity of Metal";
    tlabel->stooltips_helptext[3] = "Dielectric Loss Tangent";
    tlabel->stooltips_helptext[4] = "Magnetic Loss Tangent";
    tlabel->stooltips_helptext[5] = NULL;
    tlabel->stooltips_helptext[6] = NULL;
    tlabel->stooltips_helptext[7] = NULL;
    tlabel->stooltips_helptext[8] = NULL;
    /* component tooltips */
    tlabel->ctooltips_helptext[0] = "Frequency";
    tlabel->ctooltips_helptext[1] = NULL;
    tlabel->ctooltips_helptext[2] = NULL;
    /* physical tooltips */
    tlabel->ptooltips_helptext[0] = "Width of Waveguide";
    tlabel->ptooltips_helptext[1] = "Height of Waveguide";
    tlabel->ptooltips_helptext[2] = "Length";
    tlabel->ptooltips_helptext[3] = NULL;
    /* electrical tooltips */
    tlabel->etooltips_helptext[0] = "Characteristic Impedance";
    tlabel->etooltips_helptext[1] = "Electrical Length";
    tlabel->etooltips_helptext[2] = NULL;
    tlabel->etooltips_helptext[3] = NULL;
    break;
  }
}


