// uba.h - VAX Unibus Interface
//
// Written by
//  Timothy Stark <sword7@speakeasy.org>
//
// This file is part of the TS10 Emulator.
// See ReadMe for copyright notice.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "vax/nexus.h"

// 0000 UBA_CSR    Configuration Register (NEX_CSR)
// 0004 UBA_CR     Control Register
// 0008 UBA_SR     Status Register
// 000C UBA_DCR    Diagnostic Control Register
// 0010 UBA_FMER   Failed Map Entry Register
// 0014 UBA_FUBAR  Failed UNIBUS Address Register
// 0018 Reserved
// 001C Reserved
// 0020 UBA_BRSVR  Send Vector Registers (4)
// 0030 UBA_BRRVR  Receive Vector Registers (4)
// 0040 UBA_DPR    Buffered Data Path Registers (16)
// 0080 Reserved
// 0800 UBA_MAP    Unibus Map Registers (496)
// 0FC0 Reserved

// 0004 UBA_CR - Control Register

#define UBCR_MRD      0x7C000000 // Map Register Disable bit 4-0
#define UBCR_IFS      0x00000040 // Interrupt Field Switch
#define UBCR_BRIE     0x00000020 // BR Interrupt Enable
#define UBCR_USEFIE   0x00000010 // UNIBUS to SBI Error Field IE
#define UBCR_SUEFIE   0x00000008 // SBI to UNIBUS Error Field IE
#define UBCR_CNFIE    0x00000004 // Configuration Interrupt Enable
#define UBCR_UPF      0x00000002 // UNIBUS Power Fail
#define UBCR_ADINIT   0x00000001 // Adapter Initialization

// 0008 UBA_SR - Status Register

#define UBSR_BR7FULL  0x08000000 // BR7 Receive Vector Register Full
#define UBSR_BR6FULL  0x04000000 // BR6 Receive Vector Register Full
#define UBSR_BR5FULL  0x02000000 // BR5 Receive Vector Register Full
#define UBSR_BR4FULL  0x01000000 // BR4 Receive Vector Register Full
#define UBSR_RDTO     0x00000400 // UNIBUS to SBI Read Data Timeout
#define UBSR_RDS      0x00000200 // Read Data Substitute
#define UBSR_CRD      0x00000100 // Corrected Read Data
#define UBSR_CXTER    0x00000080 // Command Transmit Error
#define UBSR_CXTMO    0x00000040 // Command Transmit Timeout
#define UBSR_DPPE     0x00000020 // Data Path Parity Error
#define UBSR_IVMR     0x00000010 // Invalid Map Register
#define UBSR_MRPF     0x00000008 // Map Register Parity Failure
#define UBSR_LEB      0x00000004 // Lost Error
#define UBSR_UBSTO    0x00000002 // UNIBUS Select Timeout
#define UBSR_UBBSYNTO 0x00000001 // UNIBUS Slave Sync Timeout

// UBA_BRRVR

#define UBBRRVR_AIRI  0x80000000 // Adapter Interrupt Request
#define UBBRRVR_DIV   0x0000FFFF // Device Interrupt Vector Field

// UBA_DPR

#define UBDPR_BNE     0x80000000 // Buffer Not Empty - Purge
#define UBDPR_BTE     0x40000000 // Buffer Transfer Error
#define UBDPR_DPF     0x20000000 // DP Function (RO)
#define UBDPR_BS      0x007F0000 // Buffer State Field
#define UBDPR_BUBA    0x0000FFFF // Buffered Unibus Address

#define UBDPR_ERROR   0x80000000 // Error Occured
#define UBDPR_NXM     0x40000000 // Non-Existant Memory
#define UBDPR_UCE     0x20000000 // Uncorrectable Error
#define UBDPR_PURGE   0x00000001 // Purge BDP

// UBA_MR - Unibus Map Register
#define UBMR_MRV      0x80000000 // Map Register Valid
#define UBMR_BO       0x02000000 // Byte Offset Bit
#define UBMR_DPDB     0x01E00000 // Data Path Designator Field
#define UBMR_SBIPFN   0x000FFFFF // SBI Page Address Field

#define UBMR_P_DPDB   21         // Position of Data Shift Desinator
