function shareArticle(id) {
	try {
		if (dijit.byId("shareArticleDlg"))
			dijit.byId("shareArticleDlg").destroyRecursive();

		var query = "backend.php?op=pluginhandler&plugin=share&method=shareArticle&param=" + param_escape(id);

		dialog = new dijit.Dialog({
			id: "shareArticleDlg",
			title: __("Share article by URL"),
			style: "width: 600px",
			newurl: function() {
				if (confirm(__("Generate new share URL for this article?"))) {

					notify_progress("Trying to change URL...", true);

					const query = { op: "pluginhandler", plugin: "share", method: "newkey", id: id };

					xhrJson("backend.php", query, (reply) => {
						if (reply) {
							const new_link = reply.link;
							const e = $('gen_article_url');

							if (new_link) {

								e.innerHTML = e.innerHTML.replace(/\&amp;key=.*$/,
									"&amp;key=" + new_link);

								e.href = e.href.replace(/\&key=.*$/,
									"&key=" + new_link);

								new Effect.Highlight(e);

								const img = $("SHARE-IMG-" + id);
								if (img) img.src = img.src.replace("notshared.png", "share.png");

								notify('');

							} else {
								notify_error("Could not change URL.");
							}
						}
					});
				}

			},
			unshare: function() {
				if (confirm(__("Remove sharing for this article?"))) {

					notify_progress("Trying to unshare...", true);

					const query = { op: "pluginhandler", plugin: "share", method: "unshare", id: id };

					xhrPost("backend.php", query, () => {
						notify("Article unshared.");

						var img = $("SHARE-IMG-" + id);
						if (img) img.src = img.src.replace("share.png", "notshared.png");

						dialog.hide();
					});
				}

			},
			href: query});

		dialog.show();

		const img = $("SHARE-IMG-" + id);
		if (img) img.src = img.src.replace("notshared.png", "share.png");

	} catch (e) {
		exception_error("shareArticle", e);
	}
}


