/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"


struct fifo *glog = NULL;
struct fifo *gtalk = NULL;
struct fifo *gsked = NULL;

struct fifo *init_fifo(int maxlen){
    struct fifo *fifo;

/*    dbg("init_fifo(%d)\n", maxlen);*/

    fifo = g_new0(struct fifo, 1);
    fifo->maxlen = maxlen;
    fifo->items = g_ptr_array_new();
    return fifo;
}


void free_fifo(struct fifo *fifo){
    sw_unset_unread(fifo);
    g_ptr_array_free_all(fifo->items);
    g_free(fifo);
}

void drop_fifo(struct fifo *fifo){
    int i;
    for (i=fifo->items->len-1; i>=0; i--){
		g_free(g_ptr_array_index(fifo->items, i));
        g_ptr_array_remove_index_fast(fifo->items, i);
    }
}

void fifo_resize(struct fifo *fifo, int x, int y, int w, int h){
    fifo->x = x;
    fifo->y = y;
    fifo->w = w;
    fifo->h = h;
} 

int fifo_len(struct fifo *fifo){
    return fifo->items->len;
}

gchar *fifo_index(struct fifo *fifo, int index){
    return g_ptr_array_index(fifo->items, index);
}



void fifo_check_len(struct fifo *fifo){
    gpointer p;
    
    if (fifo->items->len == fifo->maxlen){
        p = g_ptr_array_index(fifo->items, 0);   
        g_free(p);
        g_ptr_array_remove_index(fifo->items, 0);
    }
}


gchar *hour_min(void){
    time_t now;
    struct tm utc;
    gchar *res;

    time(&now);
    gmtime_r(&now, &utc);

    res=g_strdup_printf("%2d.%02d",utc.tm_hour, utc.tm_min);
    return res;
}

void fifo_adds(struct fifo *fifo, gchar *str){
    int l,i;
    gchar *c, *now;
    struct subwin *sw;

    if (!fifo || !str) return;
    if (!fifo->withouttime){
        now = hour_min();
        c = g_strconcat(now, " ", str, NULL);
        g_free(now);
    }else{
        c = g_strdup(str);
    }
        
    
    l = strlen(c);
    if (l>0 && c[l-1]=='\n') c[l-1]='\0';
    if (l>0 && c[l-1]=='\r') c[l-1]='\0';

    if (gses){
        for (i=0; i<gses->subwins->len; i++){
            sw = (struct subwin *)g_ptr_array_index(gses->subwins, i);
            if (sw->fifo!=fifo) continue;
            if (sw->offset > 0 && sw->offset < sw->maxlen-sw->h) sw->offset++;
        }
    }
    
    g_ptr_array_add(fifo->items, c);
    if (ctest && ctest->logfile && fifo==glog){
        fprintf(ctest->logfile, "%s\n", c);
    }
    fifo_check_len(fifo);
    sw_set_unread(fifo);
    
    if (term) redraw_later();
        
}

void fifo_addf(struct fifo *fifo, char *m, ...){ 
    gchar *c, *d, *now;
    int l;
    va_list v;

    if (!fifo) return;
    
    va_start(v, m);
    c = g_strdup_vprintf(m, v);
    va_end(v);
    l = strlen(c);
    if (l>0 && c[l-1]=='\n') c[l-1]='\0';
    if (l>0 && c[l-1]=='\r') c[l-1]='\0';
    
    if (!fifo->withouttime){
        now = hour_min();
        d = g_strconcat(now, " ", c, NULL);
        g_free(now);
        g_free(c);
    }
    else{
        d=c;
    }
    
    g_ptr_array_add(fifo->items, d);
    if (ctest && ctest->logfile && fifo==glog){
        fprintf(ctest->logfile, "%s\n", d);
    }
    fifo_check_len(fifo);
    sw_set_unread(fifo);
    if (term) redraw_later();
}

void fifo_addfq(struct fifo *fifo, char *m, ...){ 
    gchar *c, *d, *now;
    int l;
    va_list v;

    if (!fifo) return;
    
    va_start(v, m);
    c = g_strdup_vprintf(m, v);
    va_end(v);
    l = strlen(c);
    if (l>0 && c[l-1]=='\n') c[l-1]='\0';
    if (l>0 && c[l-1]=='\r') c[l-1]='\0';
    
    if (!fifo->withouttime){
        now = hour_min();
        d = g_strconcat(now, " ", c, NULL);
        g_free(now);
        g_free(c);
    }
    else{
        d=c;
    }
    
    g_ptr_array_add(fifo->items, d);
    fifo_check_len(fifo);
    if (term) redraw_later();
}

void log_addf(char *m, ...){ 
    gchar *c, *d, *now;
    int l;
    va_list v;

    if (!glog) return;
    
    va_start(v, m);
    c = g_strdup_vprintf(m, v);
    va_end(v);
    l = strlen(c);
    if (l>0 && c[l-1]=='\n') c[l-1]='\0';
    if (l>0 && c[l-1]=='\r') c[l-1]='\0';
    
    now = hour_min();
    d = g_strconcat(now, " ", c, NULL);
    g_free(now);
    g_free(c);
    
    g_ptr_array_add(glog->items, d);
    if (ctest && ctest->logfile){
        fprintf(ctest->logfile, "%s\n", d);
    }
    fifo_check_len(glog);
    if (term) redraw_later();
}


void log_draw(struct fifo *fifo){
    int i,index;
    gchar *c;

    fill_area(fifo->x, fifo->y, fifo->w, fifo->h, COL_BG);
    for (i=0;i<fifo->h; i++){
        index = fifo->items->len-fifo->h+i;
        if (index<0)
           c = "~"; 
        else
           c = g_ptr_array_index(fifo->items, index);
		
		if (c && strlen(c)>fifo->ho) 
	        print_text(fifo->x, fifo->y+i, fifo->w, c+fifo->ho, COL_NORM);
    }
    
}       


int save_fifo_to_file(struct fifo *fifo, gchar *filename){
    FILE *f;
    int i,ret;
    gchar *c;

    f = fopen(filename, "wt");
    if (!f){
        log_addf(VTEXT(T_CANT_WRITE_S), filename);
        return errno;
    }
    
    for (i=0; i<fifo->items->len; i++){
        c=g_ptr_array_index(fifo->items, i);
        ret = fprintf(f, "%s\n", c);
        if (ret!=strlen(c)+1) {
            log_addf(VTEXT(T_CANT_WRITE_S), filename);
            return errno;
        }
    }
    
    fclose(f);
    return 0;
    
}

int load_fifo_from_file(struct fifo *fifo, gchar *filename, int drop){
    FILE *f;
    GString *gs;
    gchar *c;

    f = fopen(filename, "rt");
    if (!f){
        log_addf(VTEXT(T_CANT_READ_S), filename);
        return errno;
    }
    
    if (drop) drop_fifo(fifo);
    sw_unset_unread(fifo);
    gs=g_string_sized_new(100);
    fifo->withouttime=1;
    while( (c=safe_fgets(gs, f, 0)) != NULL){
        fifo_adds(fifo, c);
    }
    fifo->withouttime=0;
    
    g_string_free(gs, TRUE);
    sw_unset_unread(fifo);
    
    fclose(f);
    return 0;
}
