#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if (QT_REL == 3)
#include <qevent.h>
#else
#ifdef  _WIN32
// compilation pb workaround
#include <windows.h>
#endif
#include <QtGui/qevent.h>
#include "tulip/Qt3ForTulip.h"
#endif

#include <tulip/SuperGraph.h>
#include <tulip/LayoutProxy.h>
#include <tulip/ColorsProxy.h>
#include <tulip/GlGraphWidget.h>


#include <tulip/MouseAddNode.h>

void MouseAddNode::mPressEvent(GlGraphWidget *glGraphWidget, QMouseEvent *qMouseEv){
  SuperGraph*_superGraph=glGraphWidget->getSuperGraph();
  LayoutProxy* mLayout=_superGraph->getProperty<LayoutProxy>("viewLayout");
  //  ColorsProxy* mColors=_superGraph->getProperty<ColorsProxy>("viewColor");
  node newNode;
  float x1,y1,z1;
  switch(qMouseEv->button()) {
    case Qt::LeftButton :
      newNode = _superGraph->addNode();
      //if (isViewStrahler()) orderedNode.push_front(newNode);
      x1 = (double) glGraphWidget->width() - (double) qMouseEv->x() ;y1 = (double) qMouseEv->y();z1 = 0;
      glGraphWidget->screenTo3DWorld(x1,y1,z1);
      mLayout->setNodeValue(newNode, Coord(x1,y1,z1));
      //      mColors->setNodeValue(newNode,((Application *)qApp)->nodeColor);
      glGraphWidget->redraw();
      break;
  default:
      break;
    }
}
void MouseAddNode::mPaint(GlGraphWidget *){}
void MouseAddNode:: mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}
void MouseAddNode:: mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}
