//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef BEZIER_H
#define BEZIER_H
#ifndef DOXYGEN_NOTFOR_DEVEL

namespace tlp {

/*
 * Compute the position of a point 'p' at mu (0 <= mu < 1)
 * along Bezier curve defined by control points 'points'
 * IMPORTANT: THE LAST POINT IS NOT COMPUTED
 */
void Bezier(double (&p)[3], const double (*points)[3], unsigned int size, double mu);

/*
 * optimized version with 3 or four control points. General Bezier uses the functions in that case.
 */
void Bezier3(double (&p)[3], const double p1[3], const double p2[3], const double p3[3], double mu);
void Bezier4(double (&p)[3], const double p1[3], const double p2[3], const double p3[3], const double p4[3], double mu);

}

#endif //DOXYGEN_NOTFOR_DEVEL
#endif //BEZIER_H
